/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public abstract class AbstractDecoration<T> {
    private final ContentPanelController contentPanelController;
    private final FXOMObject fxomObject;
    private final Class<T> sceneGraphClass;
    private final Group rootNode = new Group();
    private T sceneGraphObject;
    private final ChangeListener<Bounds> layoutBoundsListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> ov, Bounds v1, Bounds v2) {
            AbstractDecoration.this.layoutDecoration();
        }
    };
    private final ChangeListener<Bounds> boundsInParentListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> ov, Bounds v1, Bounds v2) {
            AbstractDecoration.this.layoutDecoration();
        }
    };
    private final ChangeListener<Transform> localToSceneTransformListener = new ChangeListener<Transform>(){

        public void changed(ObservableValue<? extends Transform> ov, Transform v1, Transform v2) {
            AbstractDecoration.this.layoutDecoration();
        }
    };

    public AbstractDecoration(ContentPanelController contentPanelController, FXOMObject fxomObject, Class<T> sceneGraphClass) {
        assert (contentPanelController != null);
        assert (fxomObject != null);
        assert (fxomObject.getSceneGraphObject() != null);
        assert (fxomObject.getFxomDocument() == contentPanelController.getEditorController().getFxomDocument());
        assert (sceneGraphClass != null);
        this.contentPanelController = contentPanelController;
        this.fxomObject = fxomObject;
        this.sceneGraphClass = sceneGraphClass;
        this.sceneGraphObject = sceneGraphClass.cast(fxomObject.getSceneGraphObject());
        this.rootNode.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> ov, Scene v1, Scene v2) {
                AbstractDecoration.this.rootNodeSceneDidChange();
            }
        });
        this.rootNode.getStyleClass().add((Object)"theme-presets");
        this.rootNode.getStyleClass().add((Object)"SBKIT-content-panel");
    }

    public ContentPanelController getContentPanelController() {
        return this.contentPanelController;
    }

    public FXOMObject getFxomObject() {
        return this.fxomObject;
    }

    public T getSceneGraphObject() {
        return this.sceneGraphObject;
    }

    public Group getRootNode() {
        return this.rootNode;
    }

    public State getState() {
        State result = this.fxomObject.getSceneGraphObject() == this.sceneGraphObject ? State.CLEAN : (this.fxomObject.getSceneGraphObject() == null ? State.NEEDS_REPLACE : (this.fxomObject.getSceneGraphObject().getClass() == this.sceneGraphClass ? State.NEEDS_RECONCILE : State.NEEDS_REPLACE));
        return result;
    }

    public void reconcile() {
        assert (this.getState() == State.NEEDS_RECONCILE);
        this.stopListeningToSceneGraphObject();
        this.updateSceneGraphObject();
        this.startListeningToSceneGraphObject();
        this.layoutDecoration();
    }

    public Point2D sceneGraphObjectToDecoration(double x, double y, boolean snapToPixel) {
        Point2D result = this.sceneGraphObjectToDecoration(x, y);
        if (snapToPixel) {
            double rx = Math.round(result.getX());
            double ry = Math.round(result.getY());
            result = new Point2D(rx, ry);
        }
        return result;
    }

    public Transform getSceneGraphObjectToDecorationTransform() {
        Transform result;
        Transform t1 = this.getSceneGraphToSceneTransform();
        Transform t2 = this.getRootNode().getLocalToSceneTransform();
        try {
            Transform i2 = t2.createInverse();
            result = i2.createConcatenation(t1);
        }
        catch (NonInvertibleTransformException x) {
            throw new RuntimeException(x);
        }
        return result;
    }

    public abstract Bounds getSceneGraphObjectBounds();

    public abstract Transform getSceneGraphToSceneTransform();

    public abstract Point2D sceneGraphObjectToScene(double var1, double var3);

    public abstract Point2D sceneToSceneGraphObject(double var1, double var3);

    protected abstract void startListeningToSceneGraphObject();

    protected abstract void stopListeningToSceneGraphObject();

    protected abstract void layoutDecoration();

    public Point2D sceneGraphObjectToDecoration(double x, double y) {
        return this.getRootNode().sceneToLocal(this.sceneGraphObjectToScene(x, y));
    }

    protected void startListeningToLayoutBounds(Node node) {
        assert (node != null);
        node.layoutBoundsProperty().addListener(this.layoutBoundsListener);
    }

    protected void stopListeningToLayoutBounds(Node node) {
        assert (node != null);
        node.layoutBoundsProperty().removeListener(this.layoutBoundsListener);
    }

    protected void startListeningToBoundsInParent(Node node) {
        assert (node != null);
        node.boundsInParentProperty().addListener(this.boundsInParentListener);
    }

    protected void stopListeningToBoundsInParent(Node node) {
        assert (node != null);
        node.boundsInParentProperty().removeListener(this.boundsInParentListener);
    }

    protected void startListeningToLocalToSceneTransform(Node node) {
        assert (node != null);
        node.localToSceneTransformProperty().addListener(this.localToSceneTransformListener);
    }

    protected void stopListeningToLocalToSceneTransform(Node node) {
        assert (node != null);
        node.localToSceneTransformProperty().removeListener(this.localToSceneTransformListener);
    }

    protected void rootNodeSceneDidChange() {
        if (this.rootNode.getScene() == null) {
            this.stopListeningToSceneGraphObject();
        } else {
            this.startListeningToSceneGraphObject();
            this.layoutDecoration();
        }
    }

    protected void updateSceneGraphObject() {
        this.sceneGraphObject = this.sceneGraphClass.cast(this.fxomObject.getSceneGraphObject());
    }

    public static enum State {
        CLEAN,
        NEEDS_RECONCILE,
        NEEDS_REPLACE;

    }
}

