/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.HudWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.WorkspaceController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.BorderPaneDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.FlowPaneDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.GenericDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.GridPaneDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.HBoxDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.LineDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.SplitPaneDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabPaneDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TableColumnDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TableViewDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TextFlowDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.ToolBarDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TreeTableColumnDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TreeTableViewDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.VBoxDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.outline.NodeOutline;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode.AbstractModeController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode.EditModeController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode.PickModeController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.BoundsUnion;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.Picker;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.ScrollPaneBooster;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.editor.util.ContextMenuController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.TextFlow;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public class ContentPanelController
extends AbstractFxmlPanelController
implements FXOMDocument.SceneGraphHolder {
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private Pane workspacePane;
    @FXML
    private Rectangle extensionRect;
    @FXML
    private Label backgroundPane;
    @FXML
    private Group scalingGroup;
    @FXML
    private Group contentGroup;
    @FXML
    private Pane glassLayer;
    @FXML
    private Group outlineLayer;
    @FXML
    private Group pringLayer;
    @FXML
    private Group handleLayer;
    @FXML
    private Group rudderLayer;
    private boolean guidesVisible = true;
    private Paint pringColor = Color.rgb((int)238, (int)168, (int)47);
    private Paint guidesColor = Color.RED;
    private final WorkspaceController workspaceController = new WorkspaceController();
    private final HudWindowController hudWindowController = new HudWindowController();
    private final EditModeController editModeController;
    private final PickModeController pickModeController;
    private AbstractModeController currentModeController;
    private boolean tracingEvents;
    private final Picker picker = new Picker();
    private final List<NodeOutline> outlines = new ArrayList<NodeOutline>();
    private final EventHandler<Event> eventTracingFilter = new EventHandler<Event>(){

        public void handle(Event e) {
            ContentPanelController.this.traceEvent(e);
        }
    };

    public ContentPanelController(EditorController editorController) {
        super(ContentPanelController.class.getResource("ContentPanel.fxml"), I18N.getBundle(), editorController);
        this.editModeController = new EditModeController(this);
        this.pickModeController = new PickModeController(this);
        editorController.getDragController().dragSourceProperty().addListener((ChangeListener)new ChangeListener<AbstractDragSource>(){

            public void changed(ObservableValue<? extends AbstractDragSource> ov, AbstractDragSource t, AbstractDragSource t1) {
                ContentPanelController.this.dragSourceDidChange();
            }
        });
        editorController.getDragController().dropTargetProperty().addListener((ChangeListener)new ChangeListener<AbstractDropTarget>(){

            public void changed(ObservableValue<? extends AbstractDropTarget> ov, AbstractDropTarget t, AbstractDropTarget t1) {
                ContentPanelController.this.dropTargetDidChange();
            }
        });
        editorController.themeProperty().addListener((ChangeListener)new ChangeListener<EditorPlatform.Theme>(){

            public void changed(ObservableValue<? extends EditorPlatform.Theme> ov, EditorPlatform.Theme t, EditorPlatform.Theme t1) {
                ContentPanelController.this.themeDidChange();
            }
        });
        editorController.sceneStyleSheetProperty().addListener((ListChangeListener)new ListChangeListener<File>(){

            public void onChanged(ListChangeListener.Change<? extends File> change) {
                ContentPanelController.this.sceneStyleSheetsDidChange();
            }
        });
        editorController.pickModeEnabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                ContentPanelController.this.pickModeDidChange();
            }
        });
    }

    public boolean isOutlinesVisible() {
        return this.contentGroup != null && !this.contentGroup.isVisible();
    }

    public void setOutlinesVisible(boolean outlinesVisible) {
        if (outlinesVisible != this.isOutlinesVisible()) {
            if (outlinesVisible) {
                this.beginShowingOutlines();
            } else {
                this.endShowingOutlines();
            }
        }
    }

    public boolean isGuidesVisible() {
        return this.guidesVisible;
    }

    public void setGuidesVisible(boolean guidesVisible) {
        this.guidesVisible = guidesVisible;
    }

    public Paint getPringColor() {
        return this.pringColor;
    }

    public void setPringColor(Paint pringColor) {
        this.pringColor = pringColor;
    }

    public Paint getGuidesColor() {
        return this.guidesColor;
    }

    public void setGuidesColor(Paint guidesColor) {
        this.guidesColor = guidesColor;
    }

    public double getScaling() {
        return this.workspaceController.getScaling();
    }

    public void setScaling(double scaling) {
        this.workspaceController.setScaling(scaling);
    }

    public boolean isAutoResize3DContent() {
        return this.workspaceController.isAutoResize3DContent();
    }

    public void setAutoResize3DContent(boolean autoResize3DContent) {
        this.workspaceController.setAutoResize3DContent(autoResize3DContent);
    }

    public void scrollToSelection() {
        BoundsUnion union = new BoundsUnion();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject i : osg.getItems()) {
                DesignHierarchyMask mask = new DesignHierarchyMask(i);
                FXOMObject nodeFxomObject = mask.getClosestFxNode();
                if (nodeFxomObject == null) continue;
                Node node = (Node)nodeFxomObject.getSceneGraphObject();
                union.add(node.localToScene(node.getLayoutBounds()));
            }
        }
        if (union.getResult() != null) {
            Node content = this.scrollPane.getContent();
            Bounds enclosing = content.sceneToLocal(union.getResult());
            ScrollPaneBooster spb = new ScrollPaneBooster(this.scrollPane);
            spb.scrollTo(enclosing);
        }
    }

    public void reveal(FXOMObject targetFxomObject) {
        FXOMObject fxomObject = targetFxomObject;
        while (fxomObject != null) {
            TitledPane titledPane;
            Object sceneGraphObject = fxomObject.getSceneGraphObject();
            if (sceneGraphObject instanceof Tab) {
                Tab tab = (Tab)sceneGraphObject;
                TabPane tabPane = tab.getTabPane();
                assert (tabPane != null);
                tabPane.getSelectionModel().select((Object)tab);
            } else if (sceneGraphObject instanceof TitledPane && (titledPane = (TitledPane)sceneGraphObject).getParent() instanceof Accordion) {
                Accordion accordion = (Accordion)titledPane.getParent();
                accordion.setExpandedPane(titledPane);
            }
            DesignHierarchyMask mask = new DesignHierarchyMask(fxomObject);
            fxomObject = mask.getParentFXOMObject();
        }
    }

    public FXOMObject pick(double sceneX, double sceneY) {
        return this.pick(sceneX, sceneY, Collections.emptySet());
    }

    public FXOMObject pick(double sceneX, double sceneY, Set<FXOMObject> excludes) {
        FXOMObject result;
        if (this.isContentDisplayable()) {
            FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
            assert (fxomDocument != null);
            if (fxomDocument.getFxomRoot() == null || excludes.contains(fxomDocument.getFxomRoot())) {
                result = null;
            } else {
                assert (fxomDocument.getFxomRoot().getSceneGraphObject() instanceof Node);
                result = this.pick(fxomDocument.getFxomRoot(), sceneX, sceneY, excludes);
            }
        } else {
            result = null;
        }
        return result;
    }

    public FXOMObject pick(FXOMObject startObject, double sceneX, double sceneY, Set<FXOMObject> excludes) {
        FXOMObject result;
        assert (this.isContentDisplayable());
        assert (startObject != null);
        assert (startObject.getSceneGraphObject() instanceof Node);
        assert (excludes != null);
        assert (!excludes.contains(startObject));
        this.picker.getExcludes().clear();
        for (FXOMObject exclude : excludes) {
            if (!(exclude.getSceneGraphObject() instanceof Node)) continue;
            this.picker.getExcludes().add((Node)exclude.getSceneGraphObject());
        }
        Node startNode = (Node)startObject.getSceneGraphObject();
        List<Node> hitNodes = this.picker.pick(startNode, sceneX, sceneY);
        if (hitNodes == null) {
            result = null;
        } else {
            assert (!hitNodes.isEmpty());
            FXOMObject hitObject = null;
            Iterator<Node> it = hitNodes.iterator();
            while (hitObject == null && it.hasNext()) {
                Node hitNode = it.next();
                hitObject = this.searchWithNode(hitNode, sceneX, sceneY);
                if (!excludes.contains(hitObject)) continue;
                hitObject = null;
            }
            result = hitObject;
        }
        return result;
    }

    public FXOMObject searchWithNode(Node sceneGraphNode, double sceneX, double sceneY) {
        FXOMObject result;
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMObject match = fxomDocument.searchWithSceneGraphObject(sceneGraphNode);
        if (match != null) {
            AbstractDriver driver = this.lookupDriver(match);
            result = driver.refinePick(sceneGraphNode, sceneX, sceneY, match);
        } else {
            result = null;
        }
        return result;
    }

    public boolean isTracingEvents() {
        return this.tracingEvents;
    }

    public void setTracingEvents(boolean tracingEvents) {
        if (this.tracingEvents != tracingEvents) {
            this.tracingEvents = tracingEvents;
            this.setupEventTracingFilter();
        }
    }

    public void layoutContent(boolean applyCSS) {
        this.workspaceController.layoutContent(applyCSS);
    }

    public void beginInteraction() {
        this.workspaceController.beginInteraction();
    }

    public void endInteraction() {
        this.workspaceController.endInteraction();
    }

    public Pane getWorkspacePane() {
        return this.workspacePane;
    }

    public Pane getGlassLayer() {
        return this.glassLayer;
    }

    public Group getOutlineLayer() {
        return this.outlineLayer;
    }

    public Group getPringLayer() {
        return this.pringLayer;
    }

    public Group getHandleLayer() {
        return this.handleLayer;
    }

    public Group getRudderLayer() {
        return this.rudderLayer;
    }

    public Transform computeSceneGraphToRudderLayerTransform(Node sceneGraphObject) {
        Transform result;
        assert (sceneGraphObject != null);
        assert (sceneGraphObject.getScene() == this.rudderLayer.getScene());
        Transform t1 = sceneGraphObject.getLocalToSceneTransform();
        Transform t2 = this.rudderLayer.getLocalToSceneTransform();
        try {
            Transform i2 = t2.createInverse();
            result = i2.createConcatenation(t1);
        }
        catch (NonInvertibleTransformException x) {
            throw new RuntimeException(x);
        }
        return result;
    }

    public HudWindowController getHudWindowController() {
        return this.hudWindowController;
    }

    public boolean isPickModeEnabled() {
        return this.currentModeController == this.pickModeController;
    }

    public AbstractHandles<?> lookupHandles(FXOMObject fxomObject) {
        AbstractHandles<?> result = this.currentModeController != this.editModeController ? null : this.editModeController.lookupHandles(fxomObject);
        return result;
    }

    public boolean isContentDisplayable() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        boolean result = fxomDocument == null ? false : (fxomDocument.getFxomRoot() == null ? true : fxomDocument.getFxomRoot().isNode() && this.workspaceController.getLayoutException() == null);
        return result;
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
        FXOMDocument fxomDocument;
        if (oldDocument != null) {
            assert (oldDocument.getSceneGraphHolder() == this);
            oldDocument.endHoldingSceneGraph();
        }
        if ((fxomDocument = this.getEditorController().getFxomDocument()) != null) {
            assert (fxomDocument.getSceneGraphHolder() == null);
            fxomDocument.beginHoldingSceneGraph(this);
        }
        RuntimeException currentLayoutException = this.workspaceController.getLayoutException();
        this.workspaceController.setFxomDocument(fxomDocument);
        RuntimeException newLayoutException = this.workspaceController.getLayoutException();
        if (newLayoutException != null && newLayoutException != currentLayoutException) {
            this.getEditorController().getMessageLog().logWarningMessage("log.warning.layout.failed", newLayoutException.getMessage());
        }
        if (this.isOutlinesVisible()) {
            this.updateOutlines();
        }
        if (this.currentModeController != null) {
            this.currentModeController.fxomDocumentDidChange(oldDocument);
        }
        this.resetViewport();
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
        this.getEditorController().setPickModeEnabled(false);
        this.fxomDocumentDidRefreshSceneGraph(this.getEditorController().getFxomDocument());
    }

    @Override
    protected void editorSelectionDidChange() {
        if (this.currentModeController != null) {
            this.currentModeController.editorSelectionDidChange();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.scrollPane != null);
        assert (this.workspacePane != null);
        assert (this.workspacePane.getPrefWidth() == -1.0);
        assert (this.workspacePane.getPrefHeight() == -1.0);
        assert (this.workspacePane.getMaxWidth() == Double.MAX_VALUE);
        assert (this.workspacePane.getMaxHeight() == Double.MAX_VALUE);
        assert (this.workspacePane.getMinWidth() == Double.NEGATIVE_INFINITY);
        assert (this.workspacePane.getMinHeight() == Double.NEGATIVE_INFINITY);
        assert (this.extensionRect != null);
        assert (this.extensionRect.getLayoutX() == 0.0);
        assert (this.extensionRect.getLayoutY() == 0.0);
        assert (this.backgroundPane != null);
        assert (this.backgroundPane.getLayoutX() == 0.0);
        assert (this.backgroundPane.getLayoutY() == 0.0);
        assert (this.backgroundPane.getMaxWidth() == Double.NEGATIVE_INFINITY);
        assert (this.backgroundPane.getMaxHeight() == Double.NEGATIVE_INFINITY);
        assert (this.backgroundPane.getMinWidth() == Double.NEGATIVE_INFINITY);
        assert (this.backgroundPane.getMinHeight() == Double.NEGATIVE_INFINITY);
        assert (this.scalingGroup != null);
        assert (this.contentGroup != null);
        assert (this.contentGroup.getLayoutX() == 0.0);
        assert (this.contentGroup.getLayoutY() == 0.0);
        assert (this.contentGroup.getParent() == this.scalingGroup);
        assert (this.glassLayer != null);
        assert (!this.glassLayer.isMouseTransparent());
        assert (this.glassLayer.isFocusTraversable());
        assert (this.outlineLayer != null);
        assert (this.outlineLayer.isMouseTransparent());
        assert (!this.outlineLayer.isFocusTraversable());
        assert (this.pringLayer != null);
        assert (!this.pringLayer.isMouseTransparent());
        assert (!this.pringLayer.isFocusTraversable());
        assert (this.handleLayer != null);
        assert (!this.handleLayer.isMouseTransparent());
        assert (!this.handleLayer.isFocusTraversable());
        assert (this.rudderLayer != null);
        assert (this.rudderLayer.isMouseTransparent());
        assert (!this.rudderLayer.isFocusTraversable());
        this.outlineLayer.setManaged(false);
        this.pringLayer.setManaged(false);
        this.handleLayer.setManaged(false);
        this.rudderLayer.setManaged(false);
        this.installStylingIsolationGroup();
        this.backgroundPane.setText("");
        this.workspaceController.panelControllerDidLoadFxml(this.scrollPane, this.scalingGroup, this.contentGroup, this.backgroundPane, this.extensionRect);
        this.themeDidChange();
        this.pickModeDidChange();
        this.resetViewport();
        this.setupEventTracingFilter();
        ContextMenuController contextMenuController = this.getEditorController().getContextMenuController();
        this.scrollPane.setContextMenu(contextMenuController.getContextMenu());
    }

    @Override
    public void fxomDocumentWillRefreshSceneGraph(FXOMDocument fxomDocument) {
    }

    @Override
    public void fxomDocumentDidRefreshSceneGraph(FXOMDocument fxomDocument) {
        this.workspaceController.sceneGraphDidChange();
        if (this.isOutlinesVisible()) {
            this.updateOutlines();
        }
        if (this.currentModeController != null) {
            this.currentModeController.fxomDocumentDidRefreshSceneGraph();
        }
    }

    private void changeModeController(AbstractModeController nextModeController) {
        assert (nextModeController != this.currentModeController);
        assert (nextModeController != null);
        if (this.currentModeController != null) {
            this.currentModeController.willResignActive(nextModeController);
        }
        AbstractModeController previousModeController = this.currentModeController;
        this.currentModeController = nextModeController;
        this.currentModeController.didBecomeActive(previousModeController);
    }

    public AbstractDriver lookupDriver(FXOMObject fxomObject) {
        Object sceneGraphObject = fxomObject.getSceneGraphObject();
        AbstractDriver result = sceneGraphObject instanceof HBox ? new HBoxDriver(this) : (sceneGraphObject instanceof VBox ? new VBoxDriver(this) : (sceneGraphObject instanceof GridPane ? new GridPaneDriver(this) : (sceneGraphObject instanceof BorderPane ? new BorderPaneDriver(this) : (sceneGraphObject instanceof Line ? new LineDriver(this) : (sceneGraphObject instanceof FlowPane ? new FlowPaneDriver(this) : (sceneGraphObject instanceof TextFlow ? new TextFlowDriver(this) : (sceneGraphObject instanceof ToolBar ? new ToolBarDriver(this) : (sceneGraphObject instanceof SplitPane ? new SplitPaneDriver(this) : (sceneGraphObject instanceof Tab ? new TabDriver(this) : (sceneGraphObject instanceof TabPane ? new TabPaneDriver(this) : (sceneGraphObject instanceof TableView ? new TableViewDriver(this) : (sceneGraphObject instanceof TableColumn ? new TableColumnDriver(this) : (sceneGraphObject instanceof TreeTableView ? new TreeTableViewDriver(this) : (sceneGraphObject instanceof TreeTableColumn ? new TreeTableColumnDriver(this) : (sceneGraphObject instanceof Node ? new GenericDriver(this) : null)))))))))))))));
        return result;
    }

    private void resetViewport() {
        if (this.scrollPane != null) {
            this.scrollPane.setHvalue(0.5);
            this.scrollPane.setVvalue(0.5);
        }
    }

    private void setupEventTracingFilter() {
        if (this.glassLayer != null) {
            if (this.tracingEvents) {
                this.glassLayer.addEventFilter(InputEvent.ANY, this.eventTracingFilter);
            } else {
                this.glassLayer.removeEventFilter(InputEvent.ANY, this.eventTracingFilter);
            }
        }
    }

    private void traceEvent(Event e) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContentPanelController: eventType=");
        sb.append(e.getEventType());
        sb.append(", target=");
        sb.append(e.getTarget());
        if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            sb.append(", keyCode=");
            sb.append(ke.getCode());
        }
        System.out.println(sb.toString());
    }

    private void dragSourceDidChange() {
        this.getEditorController().setPickModeEnabled(false);
    }

    private void dropTargetDidChange() {
        if (this.currentModeController != null) {
            this.currentModeController.dropTargetDidChange();
        }
    }

    private void themeDidChange() {
        if (this.contentGroup != null) {
            EditorPlatform.Theme theme = this.getEditorController().getTheme();
            List<URL> themeStyleSheets = EditorPlatform.getThemeStylesheetURLs(theme);
            this.workspaceController.setThemeStyleSheets(themeStyleSheets);
        }
    }

    private void sceneStyleSheetsDidChange() {
        if (this.contentGroup != null) {
            ObservableList<File> sceneStyleSheets = this.getEditorController().getSceneStyleSheets();
            ArrayList<String> sceneStyleSheetURLs = new ArrayList<String>();
            for (File f : sceneStyleSheets) {
                sceneStyleSheetURLs.add(f.toURI().toString());
            }
            this.workspaceController.setPreviewStyleSheets(sceneStyleSheetURLs);
        }
    }

    private void pickModeDidChange() {
        AbstractModeController newModeController = this.getEditorController().isPickModeEnabled() ? this.pickModeController : this.editModeController;
        this.changeModeController(newModeController);
    }

    private void installStylingIsolationGroup() {
        assert (this.contentGroup.getParent() == this.scalingGroup);
        Group isolationGroupA = Deprecation.makeStylingIsolationGroupA();
        Group isolationGroupB = Deprecation.makeStylingIsolationGroupB();
        int contentGroupIndex = this.scalingGroup.getChildren().indexOf((Object)this.contentGroup);
        assert (contentGroupIndex != -1);
        this.scalingGroup.getChildren().remove((Object)this.contentGroup);
        this.scalingGroup.getChildren().add(contentGroupIndex, (Object)isolationGroupA);
        isolationGroupA.getChildren().add((Object)isolationGroupB);
        isolationGroupB.getChildren().add((Object)this.contentGroup);
    }

    private void beginShowingOutlines() {
        assert (this.contentGroup.isVisible());
        this.contentGroup.setVisible(false);
        this.updateOutlines();
    }

    private void endShowingOutlines() {
        assert (!this.contentGroup.isVisible());
        ObservableList outlineNodes = this.outlineLayer.getChildren();
        for (NodeOutline o : this.outlines) {
            assert (outlineNodes.contains(o.getRootNode()));
            outlineNodes.remove(o.getRootNode());
        }
        this.outlines.clear();
        this.contentGroup.setVisible(true);
    }

    private void updateOutlines() {
        int i;
        assert (this.isOutlinesVisible());
        List<FXOMObject> allNodes = this.collectNodes();
        int count = allNodes.size();
        for (i = 0; i < count; ++i) {
            assert (allNodes.get(i) instanceof FXOMInstance);
            FXOMInstance nodeInstance = (FXOMInstance)allNodes.get(i);
            if (i < this.outlines.size()) {
                NodeOutline currentOutline = this.outlines.get(i);
                if (currentOutline.getFxomObject() != nodeInstance) {
                    this.replaceOutline(i, nodeInstance);
                    continue;
                }
                switch (currentOutline.getState()) {
                    case CLEAN: {
                        break;
                    }
                    case NEEDS_RECONCILE: {
                        currentOutline.reconcile();
                        break;
                    }
                    case NEEDS_REPLACE: {
                        this.replaceOutline(i, nodeInstance);
                    }
                }
                continue;
            }
            this.addOutline(this.outlines.size(), nodeInstance);
        }
        count = this.outlines.size();
        for (i = allNodes.size(); i < count; ++i) {
            this.removeOutline(allNodes.size());
        }
        assert (this.outlines.size() == allNodes.size());
    }

    private void addOutline(int i, FXOMInstance nodeInstance) {
        assert (this.outlines.size() == this.outlineLayer.getChildren().size());
        NodeOutline newOutline = new NodeOutline(this, nodeInstance);
        this.outlines.add(i, newOutline);
        this.outlineLayer.getChildren().add(i, (Object)newOutline.getRootNode());
        assert (this.outlines.size() == this.outlineLayer.getChildren().size());
        assert (this.outlines.get(i).getRootNode() == this.outlineLayer.getChildren().get(i));
    }

    private void replaceOutline(int i, FXOMInstance nodeInstance) {
        this.removeOutline(i);
        this.addOutline(i, nodeInstance);
    }

    private void removeOutline(int i) {
        assert (this.outlines.size() == this.outlineLayer.getChildren().size());
        assert (this.outlines.get(i).getRootNode() == this.outlineLayer.getChildren().get(i));
        this.outlines.remove(i);
        this.outlineLayer.getChildren().remove(i);
        assert (this.outlines.size() == this.outlineLayer.getChildren().size());
    }

    private List<FXOMObject> collectNodes() {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        ArrayList<FXOMObject> candidates = new ArrayList<FXOMObject>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (fxomDocument != null && fxomDocument.getFxomRoot() != null) {
            candidates.add(fxomDocument.getFxomRoot());
        }
        while (!candidates.isEmpty()) {
            DesignHierarchyMask m;
            Node sgo;
            FXOMObject candidate = (FXOMObject)candidates.get(0);
            candidates.remove(0);
            if (candidate.isNode() && (sgo = (Node)candidate.getSceneGraphObject()).getScene() == this.getPanelRoot().getScene()) {
                result.add(candidate);
            }
            if ((m = new DesignHierarchyMask(candidate)).isAcceptingSubComponent()) {
                int c = m.getSubComponentCount();
                for (int i = 0; i < c; ++i) {
                    FXOMObject subComponent = m.getSubComponentAtIndex(i);
                    candidates.add(subComponent);
                }
            }
            for (DesignHierarchyMask.Accessory a : DesignHierarchyMask.Accessory.values()) {
                FXOMObject accessoryObject;
                if (!m.isAcceptingAccessory(a) || (accessoryObject = m.getAccessory(a)) == null || !accessoryObject.isNode()) continue;
                candidates.add(accessoryObject);
            }
        }
        return result;
    }
}

