/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.net.URL;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

class WorkspaceController {
    private static final double AUTORESIZE_SIZE = 500.0;
    private ScrollPane scrollPane;
    private Group scalingGroup;
    private Group contentGroup;
    private Label backgroundPane;
    private Rectangle extensionRect;
    private boolean autoResize3DContent = true;
    private double scaling = 1.0;
    private RuntimeException layoutException;
    private FXOMDocument fxomDocument;

    WorkspaceController() {
    }

    public void panelControllerDidLoadFxml(ScrollPane scrollPane, Group scalingGroup, Group contentGroup, Label backgroundPane, Rectangle extensionRect) {
        assert (scrollPane != null);
        assert (backgroundPane != null);
        assert (scalingGroup != null);
        assert (contentGroup != null);
        assert (extensionRect != null);
        this.scrollPane = scrollPane;
        this.scalingGroup = scalingGroup;
        this.contentGroup = contentGroup;
        this.backgroundPane = backgroundPane;
        this.extensionRect = extensionRect;
        this.scrollPane.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> ov, Scene t, Scene t1) {
                WorkspaceController.this.sceneDidChange();
            }
        });
        this.scalingGroup.setVisible(false);
        this.contentGroup.getChildren().clear();
        this.updateContentGroup();
        this.updateScalingGroup();
    }

    public void setFxomDocument(FXOMDocument fxomDocument) {
        if (this.fxomDocument != fxomDocument) {
            this.fxomDocument = fxomDocument;
            this.sceneGraphDidChange();
        }
    }

    public void sceneGraphDidChange() {
        if (this.scrollPane != null) {
            this.updateContentGroup();
            this.updateScalingGroup();
        }
    }

    public boolean isAutoResize3DContent() {
        return this.autoResize3DContent;
    }

    public void setAutoResize3DContent(boolean autoResize3DContent) {
        this.autoResize3DContent = autoResize3DContent;
        if (this.scrollPane != null && this.scrollPane.getScene() != null) {
            this.adjustWorkspace();
        }
    }

    public double getScaling() {
        return this.scaling;
    }

    public void setScaling(double scaling) {
        this.scaling = scaling;
        this.updateScalingGroup();
    }

    public List<String> getThemeStyleSheets() {
        ObservableList result = this.contentGroup.getStylesheets().isEmpty() ? null : this.contentGroup.getStylesheets();
        return result;
    }

    public void setThemeStyleSheets(List<URL> themeStyleSheets) {
        assert (this.contentGroup.getParent() instanceof Group);
        Group isolationGroup = (Group)this.contentGroup.getParent();
        assert (isolationGroup.getStyleClass().contains((Object)"root"));
        isolationGroup.getStylesheets().clear();
        for (URL url : themeStyleSheets) {
            isolationGroup.getStylesheets().add((Object)url.toString());
        }
        isolationGroup.applyCss();
    }

    public void setPreviewStyleSheets(List<String> previewStyleSheets) {
        this.contentGroup.getStylesheets().clear();
        this.contentGroup.getStylesheets().addAll(previewStyleSheets);
        this.contentGroup.applyCss();
    }

    public void layoutContent(boolean applyCSS) {
        if (this.scrollPane != null) {
            try {
                if (applyCSS) {
                    this.scrollPane.getContent().applyCss();
                }
                this.scrollPane.layout();
                this.layoutException = null;
            }
            catch (RuntimeException x) {
                this.layoutException = x;
            }
        }
    }

    public RuntimeException getLayoutException() {
        return this.layoutException;
    }

    public void beginInteraction() {
        assert (this.scalingGroup.getParent().isManaged());
        assert (this.scrollPane.getContent() instanceof StackPane);
        this.scalingGroup.getParent().setManaged(false);
        StackPane contentPane = (StackPane)this.scrollPane.getContent();
        assert (contentPane.getMinWidth() == Double.NEGATIVE_INFINITY);
        assert (contentPane.getMinHeight() == Double.NEGATIVE_INFINITY);
        assert (contentPane.getPrefWidth() == -1.0);
        assert (contentPane.getPrefHeight() == -1.0);
        assert (contentPane.getMaxWidth() == Double.MAX_VALUE);
        assert (contentPane.getMaxHeight() == Double.MAX_VALUE);
        contentPane.setPrefWidth(contentPane.getWidth());
        contentPane.setPrefHeight(contentPane.getHeight());
        contentPane.setMaxWidth(Double.NEGATIVE_INFINITY);
        contentPane.setMaxHeight(Double.NEGATIVE_INFINITY);
    }

    public void endInteraction() {
        assert (!this.scalingGroup.getParent().isManaged());
        StackPane contentPane = (StackPane)this.scrollPane.getContent();
        assert (contentPane.getMinWidth() == Double.NEGATIVE_INFINITY);
        assert (contentPane.getMinHeight() == Double.NEGATIVE_INFINITY);
        assert (contentPane.getPrefWidth() != -1.0);
        assert (contentPane.getPrefHeight() != -1.0);
        assert (contentPane.getMaxWidth() == Double.NEGATIVE_INFINITY);
        assert (contentPane.getMaxHeight() == Double.NEGATIVE_INFINITY);
        contentPane.setPrefWidth(-1.0);
        contentPane.setPrefHeight(-1.0);
        contentPane.setMaxWidth(Double.MAX_VALUE);
        contentPane.setMaxHeight(Double.MAX_VALUE);
        this.scalingGroup.getParent().setManaged(true);
    }

    private void sceneDidChange() {
        assert (this.scrollPane != null);
        if (this.scrollPane.getScene() != null) {
            assert (!this.scalingGroup.isVisible());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WorkspaceController.this.layoutContent(true);
                    WorkspaceController.this.adjustWorkspace();
                    WorkspaceController.this.revealScalingGroup();
                }
            });
        } else {
            assert (this.scalingGroup.isVisible());
            this.scalingGroup.setVisible(false);
        }
    }

    private void updateContentGroup() {
        String statusStyleClass;
        String statusMessageText;
        this.contentGroup.getChildren().clear();
        if (this.fxomDocument == null) {
            statusMessageText = "FXOMDocument is null";
            statusStyleClass = "stage-prompt";
        } else if (this.fxomDocument.getFxomRoot() == null) {
            statusMessageText = I18N.getString("content.label.status.invitation");
            statusStyleClass = "stage-prompt";
        } else {
            Object userSceneGraph = this.fxomDocument.getSceneGraphRoot();
            if (userSceneGraph instanceof Node) {
                Node rootNode = (Node)userSceneGraph;
                assert (rootNode.getParent() == null);
                this.contentGroup.getChildren().add((Object)rootNode);
                this.layoutContent(true);
                if (this.layoutException == null) {
                    statusMessageText = "";
                    statusStyleClass = "stage-prompt-default";
                } else {
                    this.contentGroup.getChildren().clear();
                    statusMessageText = I18N.getString("content.label.status.cannot.display");
                    statusStyleClass = "stage-prompt";
                }
            } else {
                statusMessageText = I18N.getString("content.label.status.cannot.display");
                statusStyleClass = "stage-prompt";
            }
        }
        this.backgroundPane.setText(statusMessageText);
        this.backgroundPane.getStyleClass().clear();
        this.backgroundPane.getStyleClass().add((Object)statusStyleClass);
        this.backgroundPane.layout();
        this.adjustWorkspace();
    }

    private void updateScalingGroup() {
        if (this.scalingGroup != null) {
            double actualScaling = this.fxomDocument == null ? 1.0 : (this.fxomDocument.getSceneGraphRoot() == null ? 1.0 : this.scaling);
            this.scalingGroup.setScaleX(actualScaling);
            this.scalingGroup.setScaleY(actualScaling);
            this.scalingGroup.setScaleZ(actualScaling);
        }
    }

    private void adjustWorkspace() {
        BoundingBox extensionBounds;
        BoundingBox backgroundBounds;
        Object userSceneGraph = this.fxomDocument == null ? null : this.fxomDocument.getSceneGraphRoot();
        if (userSceneGraph instanceof Node && this.layoutException == null) {
            Node rootNode = (Node)userSceneGraph;
            Bounds rootBounds = rootNode.getLayoutBounds();
            if (rootBounds.isEmpty() || rootBounds.getWidth() == 0.0 || rootBounds.getHeight() == 0.0) {
                backgroundBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0);
                extensionBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0);
            } else {
                double scale;
                if (rootBounds.getDepth() > 0.0 && this.autoResize3DContent) {
                    double scaleX = 500.0 / rootBounds.getWidth();
                    double scaleY = 500.0 / rootBounds.getHeight();
                    double scaleZ = 500.0 / rootBounds.getDepth();
                    scale = Math.min(scaleX, Math.min(scaleY, scaleZ));
                } else {
                    scale = 1.0;
                }
                this.contentGroup.setScaleX(scale);
                this.contentGroup.setScaleY(scale);
                this.contentGroup.setScaleZ(scale);
                Bounds contentBounds = rootNode.localToParent(rootBounds);
                backgroundBounds = new BoundingBox(0.0, 0.0, contentBounds.getMinX() + contentBounds.getWidth(), contentBounds.getMinY() + contentBounds.getHeight());
                Bounds unclippedRootBounds = WorkspaceController.computeUnclippedBounds(rootNode);
                assert (unclippedRootBounds.getHeight() != 0.0);
                assert (unclippedRootBounds.getWidth() != 0.0);
                assert (rootNode.getParent() == this.contentGroup);
                Bounds unclippedContentBounds = rootNode.localToParent(unclippedRootBounds);
                extensionBounds = WorkspaceController.computeExtensionBounds((Bounds)backgroundBounds, unclippedContentBounds);
            }
        } else {
            backgroundBounds = new BoundingBox(0.0, 0.0, 320.0, 150.0);
            extensionBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        this.backgroundPane.setPrefWidth(backgroundBounds.getWidth());
        this.backgroundPane.setPrefHeight(backgroundBounds.getHeight());
        this.extensionRect.setX(extensionBounds.getMinX());
        this.extensionRect.setY(extensionBounds.getMinY());
        this.extensionRect.setWidth(extensionBounds.getWidth());
        this.extensionRect.setHeight(extensionBounds.getHeight());
    }

    private static Bounds computeUnclippedBounds(Node node) {
        assert (node != null);
        assert (!node.getLayoutBounds().isEmpty());
        Bounds layoutBounds = node.getLayoutBounds();
        double minX = layoutBounds.getMinX();
        double minY = layoutBounds.getMinY();
        double maxX = layoutBounds.getMaxX();
        double maxY = layoutBounds.getMaxY();
        double minZ = layoutBounds.getMinZ();
        double maxZ = layoutBounds.getMaxZ();
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : parent.getChildrenUnmodifiable()) {
                Bounds childBounds = child.getBoundsInParent();
                minX = Math.min(minX, childBounds.getMinX());
                minY = Math.min(minY, childBounds.getMinY());
                maxX = Math.max(maxX, childBounds.getMaxX());
                maxY = Math.max(maxY, childBounds.getMaxY());
                minZ = Math.min(minZ, childBounds.getMinZ());
                maxZ = Math.max(maxZ, childBounds.getMaxZ());
            }
        }
        assert (minX <= maxX);
        assert (minY <= maxY);
        assert (minZ <= maxZ);
        return new BoundingBox(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
    }

    private static Bounds computeExtensionBounds(Bounds backgroundBounds, Bounds unclippedContentBounds) {
        Bounds totalBounds = WorkspaceController.unionOfBounds(backgroundBounds, unclippedContentBounds);
        double backgroundCenterX = (backgroundBounds.getMinX() + backgroundBounds.getMaxX()) / 2.0;
        double backgroundCenterY = (backgroundBounds.getMinY() + backgroundBounds.getMaxY()) / 2.0;
        assert (totalBounds.contains(backgroundCenterX, backgroundCenterY));
        double extensionHalfWidth = Math.max(backgroundCenterX - totalBounds.getMinX(), totalBounds.getMaxX() - backgroundCenterX);
        double extensionHalfHeight = Math.max(backgroundCenterY - totalBounds.getMinY(), totalBounds.getMaxY() - backgroundCenterY);
        return new BoundingBox(backgroundCenterX - (extensionHalfWidth += 20.0), backgroundCenterY - (extensionHalfHeight += 20.0), extensionHalfWidth * 2.0, extensionHalfHeight * 2.0);
    }

    private static Bounds unionOfBounds(Bounds b1, Bounds b2) {
        Bounds result;
        if (b1.isEmpty()) {
            result = b2;
        } else if (b2.isEmpty()) {
            result = b1;
        } else {
            double minX = Math.min(b1.getMinX(), b2.getMinX());
            double minY = Math.min(b1.getMinY(), b2.getMinY());
            double minZ = Math.min(b1.getMinZ(), b2.getMinZ());
            double maxX = Math.max(b1.getMaxX(), b2.getMaxX());
            double maxY = Math.max(b1.getMaxY(), b2.getMaxY());
            double maxZ = Math.max(b1.getMaxZ(), b2.getMaxZ());
            assert (minX <= maxX);
            assert (minY <= maxY);
            assert (minZ <= maxZ);
            result = new BoundingBox(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
        }
        return result;
    }

    private void revealScalingGroup() {
        assert (!this.scalingGroup.isVisible());
        this.scalingGroup.setVisible(true);
        this.scalingGroup.setOpacity(0.0);
        FadeTransition showHost = new FadeTransition(Duration.millis((double)300.0), (Node)this.scalingGroup);
        showHost.setFromValue(0.0);
        showHost.setToValue(1.0);
        showHost.play();
    }
}

