/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AccessoryDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerXYDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerZDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.NodeHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.NodePring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.CanvasResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.ImageViewResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.RegionResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.SubSceneResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.WebViewResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape.ArcResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape.CircleResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape.EllipseResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape.RectangleResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape.TextResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.NodeTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SubScene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;

public abstract class AbstractNodeDriver
extends AbstractDriver {
    public AbstractNodeDriver(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public AbstractHandles<?> makeHandles(FXOMObject fxomObject) {
        assert (fxomObject.getSceneGraphObject() instanceof Node);
        assert (fxomObject instanceof FXOMInstance);
        return new NodeHandles(this.contentPanelController, (FXOMInstance)fxomObject);
    }

    @Override
    public AbstractPring<?> makePring(FXOMObject fxomObject) {
        assert (fxomObject.getSceneGraphObject() instanceof Node);
        assert (fxomObject instanceof FXOMInstance);
        return new NodePring(this.contentPanelController, (FXOMInstance)fxomObject);
    }

    @Override
    public AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        assert (dropTarget != null);
        assert (dropTarget.getTargetObject() instanceof FXOMInstance);
        assert (dropTarget.getTargetObject().getSceneGraphObject() instanceof Node);
        return new NodeTring(this.contentPanelController, (FXOMInstance)dropTarget.getTargetObject());
    }

    @Override
    public AbstractResizer<?> makeResizer(FXOMObject fxomObject) {
        Object sceneGraphObject = fxomObject.getSceneGraphObject();
        AbstractResizer result = sceneGraphObject instanceof ImageView ? new ImageViewResizer((ImageView)sceneGraphObject) : (sceneGraphObject instanceof Region ? new RegionResizer((Region)sceneGraphObject) : (sceneGraphObject instanceof WebView ? new WebViewResizer((WebView)sceneGraphObject) : (sceneGraphObject instanceof Canvas ? new CanvasResizer((Canvas)sceneGraphObject) : (sceneGraphObject instanceof Arc ? new ArcResizer((Arc)sceneGraphObject) : (sceneGraphObject instanceof Circle ? new CircleResizer((Circle)sceneGraphObject) : (sceneGraphObject instanceof Ellipse ? new EllipseResizer((Ellipse)sceneGraphObject) : (sceneGraphObject instanceof Rectangle ? new RectangleResizer((Rectangle)sceneGraphObject) : (sceneGraphObject instanceof Text ? new TextResizer((Text)sceneGraphObject) : (sceneGraphObject instanceof SubScene ? new SubSceneResizer((SubScene)sceneGraphObject) : null)))))))));
        return result;
    }

    @Override
    public FXOMObject refinePick(Node hitNode, double sceneX, double sceneY, FXOMObject fxomObject) {
        return fxomObject;
    }

    @Override
    public AbstractDropTarget makeDropTarget(FXOMObject fxomObject, double sceneX, double sceneY) {
        assert (fxomObject instanceof FXOMInstance);
        assert (fxomObject.getSceneGraphObject() != null);
        FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
        DesignHierarchyMask mask = new DesignHierarchyMask(fxomObject);
        AbstractDropTarget result = mask.isFreeChildPositioning() ? new ContainerXYDropTarget(fxomInstance, sceneX, sceneY) : (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT) ? new AccessoryDropTarget(fxomInstance, DesignHierarchyMask.Accessory.CONTENT) : new ContainerZDropTarget(fxomInstance, null));
        return result;
    }

    @Override
    public Node getInlineEditorBounds(FXOMObject fxomObject) {
        Object sceneGraphObject = fxomObject.getSceneGraphObject();
        Object result = sceneGraphObject instanceof ComboBox ? (ComboBox)sceneGraphObject : (sceneGraphObject instanceof Labeled ? (Labeled)sceneGraphObject : (sceneGraphObject instanceof Text ? (Text)sceneGraphObject : (sceneGraphObject instanceof TextInputControl ? (TextInputControl)sceneGraphObject : (sceneGraphObject instanceof TitledPane ? (TitledPane)sceneGraphObject : null))));
        return result;
    }

    @Override
    public boolean intersectsBounds(FXOMObject fxomObject, Bounds bounds) {
        assert (fxomObject.getSceneGraphObject() instanceof Node);
        Node sceneGraphNode = (Node)fxomObject.getSceneGraphObject();
        Bounds sceneGraphNodeBounds = sceneGraphNode.localToScene(sceneGraphNode.getLayoutBounds());
        return sceneGraphNodeBounds.intersects(bounds);
    }
}

