/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.GridPaneDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractNodeDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPanePring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.RegionResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.BoundsUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;

public class GridPaneDriver
extends AbstractNodeDriver {
    private static final double MATCH_DIST = 4.0;

    public GridPaneDriver(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public AbstractHandles<?> makeHandles(FXOMObject fxomObject) {
        assert (fxomObject instanceof FXOMInstance);
        assert (fxomObject.getSceneGraphObject() instanceof GridPane);
        return new GridPaneHandles(this.contentPanelController, (FXOMInstance)fxomObject);
    }

    @Override
    public AbstractPring<?> makePring(FXOMObject fxomObject) {
        assert (fxomObject instanceof FXOMInstance);
        assert (fxomObject.getSceneGraphObject() instanceof GridPane);
        return new GridPanePring(this.contentPanelController, (FXOMInstance)fxomObject);
    }

    @Override
    public AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        assert (dropTarget != null);
        assert (dropTarget.getTargetObject() instanceof FXOMInstance);
        assert (dropTarget.getTargetObject().getSceneGraphObject() instanceof GridPane);
        return new GridPaneTring(this.contentPanelController, (FXOMInstance)dropTarget.getTargetObject());
    }

    @Override
    public AbstractResizer<?> makeResizer(FXOMObject fxomObject) {
        assert (fxomObject.getSceneGraphObject() instanceof GridPane);
        return new RegionResizer((Region)fxomObject.getSceneGraphObject());
    }

    @Override
    public AbstractDropTarget makeDropTarget(FXOMObject fxomObject, double sceneX, double sceneY) {
        GridPaneDropTarget result;
        assert (fxomObject.getSceneGraphObject() instanceof GridPane);
        assert (fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
        GridPane gridPane = (GridPane)fxomInstance.getSceneGraphObject();
        int columnCount = Deprecation.getGridPaneColumnCount(gridPane);
        int rowCount = Deprecation.getGridPaneRowCount(gridPane);
        if (rowCount == 0 || columnCount == 0) {
            result = new GridPaneDropTarget(fxomInstance, 0, 0, GridPaneDropTarget.ColumnArea.CENTER, GridPaneDropTarget.RowArea.CENTER);
        } else {
            GridPaneDropTarget.RowArea targetRowArea;
            GridPaneDropTarget.ColumnArea targetColumnArea;
            double targetCellY;
            int targetRowIndex;
            double targetCellX;
            int targetColumnIndex;
            Point2D hitPoint = gridPane.sceneToLocal(sceneX, sceneY);
            double hitX = hitPoint.getX();
            double hitY = hitPoint.getY();
            int c = 0;
            Bounds cellBounds = Deprecation.getGridPaneCellBounds(gridPane, c++, 0);
            double columnMaxX = cellBounds.getMaxX();
            while (columnMaxX < hitX && c < columnCount) {
                cellBounds = Deprecation.getGridPaneCellBounds(gridPane, c++, 0);
                columnMaxX = cellBounds.getMaxX();
            }
            if (hitX <= columnMaxX) {
                assert (hitX <= columnMaxX);
                targetColumnIndex = c - 1;
                targetCellX = hitX;
            } else {
                targetColumnIndex = columnCount;
                targetCellX = 0.0;
            }
            int r = 0;
            cellBounds = Deprecation.getGridPaneCellBounds(gridPane, 0, r++);
            double rowMaxY = cellBounds.getMaxY();
            while (rowMaxY < hitY && r < rowCount) {
                cellBounds = Deprecation.getGridPaneCellBounds(gridPane, 0, r++);
                rowMaxY = cellBounds.getMaxY();
            }
            if (hitY <= rowMaxY) {
                assert (hitY <= rowMaxY);
                targetRowIndex = r - 1;
                targetCellY = hitY;
            } else {
                targetRowIndex = rowCount;
                targetCellY = 0.0;
            }
            if (targetColumnIndex < columnCount) {
                Bounds targetCellBounds = Deprecation.getGridPaneCellBounds(gridPane, targetColumnIndex, 0);
                BoundsUtils.EdgeInfo edgeInfo = BoundsUtils.distanceToEdges(targetCellBounds, targetCellX, targetCellY, (Node)gridPane);
                if (targetCellX < targetCellBounds.getMinX()) {
                    targetColumnArea = GridPaneDropTarget.ColumnArea.LEFT;
                } else if (edgeInfo == null) {
                    targetColumnArea = GridPaneDropTarget.ColumnArea.CENTER;
                } else {
                    boolean westMatch;
                    boolean eastMatch = edgeInfo.getEastDistance() < 4.0;
                    boolean bl = westMatch = edgeInfo.getWestDistance() < 4.0;
                    targetColumnArea = westMatch ? GridPaneDropTarget.ColumnArea.LEFT : (eastMatch ? GridPaneDropTarget.ColumnArea.RIGHT : GridPaneDropTarget.ColumnArea.CENTER);
                }
            } else {
                targetColumnArea = GridPaneDropTarget.ColumnArea.LEFT;
            }
            if (targetRowIndex < rowCount) {
                Bounds targetCellBounds = Deprecation.getGridPaneCellBounds(gridPane, 0, targetRowIndex);
                BoundsUtils.EdgeInfo edgeInfo = BoundsUtils.distanceToEdges(targetCellBounds, targetCellX, targetCellY, (Node)gridPane);
                if (targetCellY < targetCellBounds.getMinY()) {
                    targetRowArea = GridPaneDropTarget.RowArea.TOP;
                } else if (edgeInfo == null) {
                    targetRowArea = GridPaneDropTarget.RowArea.CENTER;
                } else {
                    boolean southMatch;
                    boolean northMatch = edgeInfo.getNorthDistance() < 4.0;
                    boolean bl = southMatch = edgeInfo.getSouthDistance() < 4.0;
                    targetRowArea = northMatch ? GridPaneDropTarget.RowArea.TOP : (southMatch ? GridPaneDropTarget.RowArea.BOTTOM : GridPaneDropTarget.RowArea.CENTER);
                }
            } else {
                targetRowArea = GridPaneDropTarget.RowArea.TOP;
            }
            result = new GridPaneDropTarget(fxomInstance, targetColumnIndex, targetRowIndex, targetColumnArea, targetRowArea);
        }
        return result;
    }
}

