/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.control.SplitPane;

public class SplitPaneDesignInfoX {
    public double splitPaneLocalToDividerPosition(SplitPane splitPane, double x, double y, boolean clamp, boolean snap) {
        double result;
        boolean verticalSplit = splitPane.getOrientation() == Orientation.VERTICAL;
        Bounds lb = splitPane.getLayoutBounds();
        if (verticalSplit) {
            assert (lb.getHeight() != 0.0);
            result = (y - lb.getMinY()) / lb.getHeight();
        } else {
            assert (lb.getWidth() != 0.0);
            result = (x - lb.getMinX()) / lb.getWidth();
        }
        if (clamp) {
            result = Math.max(0.0, Math.min(1.0, result));
        }
        if (snap) {
            result = (double)Math.round(result * 100.0) / 100.0;
        }
        return result;
    }

    public double dividerPositionToSplitPaneLocal(SplitPane splitPane, double position) {
        boolean verticalSplit = splitPane.getOrientation() == Orientation.VERTICAL;
        Bounds lb = splitPane.getLayoutBounds();
        double result = verticalSplit ? lb.getMinY() + position * lb.getHeight() : lb.getMinX() + position * lb.getWidth();
        return result;
    }

    public double[] simulateDividerMove(SplitPane splitPane, int dividerIndex, double sceneX, double sceneY) {
        double maxPos;
        double minPos;
        ObservableList dividers = splitPane.getDividers();
        double currentPos = ((SplitPane.Divider)dividers.get(dividerIndex)).getPosition();
        Point2D p = splitPane.sceneToLocal(sceneX, sceneY);
        double claimedPos = this.splitPaneLocalToDividerPosition(splitPane, p.getX(), p.getY(), true, false);
        if (0 <= dividerIndex - 1) {
            minPos = ((SplitPane.Divider)dividers.get(dividerIndex - 1)).getPosition();
            assert (minPos <= currentPos);
        } else {
            minPos = 0.0;
        }
        if (dividerIndex + 1 < dividers.size()) {
            maxPos = ((SplitPane.Divider)dividers.get(dividerIndex + 1)).getPosition();
            assert (currentPos <= maxPos);
        } else {
            maxPos = 1.0;
        }
        double newPos = claimedPos < minPos ? minPos : (maxPos < claimedPos ? maxPos : claimedPos);
        double[] result = new double[dividers.size()];
        for (int i = 0; i < dividers.size(); ++i) {
            result[i] = ((SplitPane.Divider)dividers.get(i)).getPosition();
        }
        result[dividerIndex] = newPos;
        return result;
    }
}

