/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.sun.javafx.scene.control.skin.TableColumnHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;

public class TreeTableViewDesignInfoX {
    public Bounds getColumnBounds(TreeTableColumn<?, ?> treeTableColumn) {
        TreeTableView tv = treeTableColumn.getTreeTableView();
        Bounds tb = tv.getLayoutBounds();
        Bounds hb = this.getColumnHeaderBounds(treeTableColumn);
        double x0 = hb.getMinX();
        double x1 = hb.getMaxX();
        double y0 = hb.getMinY();
        double y1 = tb.getMaxY();
        return new BoundingBox(x0, y0, x1 - x0, y1 - y0);
    }

    public Bounds getColumnHeaderBounds(TreeTableColumn<?, ?> treeTableColumn) {
        TreeTableView tv = treeTableColumn.getTreeTableView();
        Node hn = this.getColumnNode(treeTableColumn);
        return tv.sceneToLocal(hn.localToScene(hn.getLayoutBounds()));
    }

    public Node getColumnNode(TreeTableColumn<?, ?> tableColumn) {
        assert (tableColumn != null);
        assert (tableColumn.getTreeTableView() != null);
        TreeTableView tableView = tableColumn.getTreeTableView();
        Set set = tableView.lookupAll(".column-header");
        Node result = null;
        Iterator it = set.iterator();
        while (result == null && it.hasNext()) {
            Node n = (Node)it.next();
            assert (n instanceof TableColumnHeader);
            TableColumnBase tc = ((TableColumnHeader)n).getTableColumn();
            if (tc != tableColumn) continue;
            result = n;
        }
        return result;
    }

    public <T> TreeTableColumn<T, ?> lookupColumn(TreeTableView<T> tableView, double sceneX, double sceneY) {
        TreeTableColumn result = null;
        Object tableColumns = tableView.getColumns();
        ArrayList columnPath = new ArrayList();
        while (!tableColumns.isEmpty()) {
            TreeTableColumn<T, ?> tc = this.lookupColumn((List<TreeTableColumn<T, ?>>)tableColumns, sceneX);
            if (tc != null) {
                columnPath.add(0, tc);
                tableColumns = tc.getColumns();
                continue;
            }
            tableColumns = Collections.emptyList();
        }
        if (columnPath.isEmpty()) {
            result = null;
        } else {
            for (TreeTableColumn treeTableColumn : columnPath) {
                Point2D p;
                Node headerNode = this.getColumnNode(treeTableColumn);
                Bounds headerBounds = headerNode.getLayoutBounds();
                if (!headerBounds.contains(p = headerNode.sceneToLocal(sceneX, sceneY))) continue;
                result = treeTableColumn;
                break;
            }
            if (result == null) {
                result = (TreeTableColumn)columnPath.get(0);
            }
        }
        return result;
    }

    private <T> TreeTableColumn<T, ?> lookupColumn(List<TreeTableColumn<T, ?>> tableColumns, double sceneX) {
        TreeTableColumn<T, ?> result = null;
        for (TreeTableColumn<T, ?> tc : tableColumns) {
            Node headerNode = this.getColumnNode(tc);
            if (headerNode == null) continue;
            Bounds headerBounds = headerNode.getLayoutBounds();
            Point2D p = headerNode.sceneToLocal(sceneX, 0.0);
            if (!(headerBounds.getMinX() <= p.getX()) || !(p.getX() < headerBounds.getMaxX())) continue;
            result = tc;
            break;
        }
        return result;
    }
}

