/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractResilientHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabPaneDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.BoundsUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.transform.Transform;

public class TabHandles
extends AbstractResilientHandles<Tab> {
    private TabPane tabPane;
    private Node tabNode;

    public TabHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Tab.class);
        ((Tab)this.getSceneGraphObject()).tabPaneProperty().addListener((ChangeListener)new ChangeListener<TabPane>(){

            public void changed(ObservableValue<? extends TabPane> ov, TabPane v1, TabPane v2) {
                TabHandles.this.tabPaneDidChange();
            }
        });
        this.tabPaneDidChange();
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        assert (this.isReady());
        assert (this.tabPane != null);
        if (this.tabNode == null) {
            this.tabNode = this.lookupTabNode();
        }
        Bounds b = this.tabNode.getLayoutBounds();
        Point2D min = this.tabPane.sceneToLocal(this.tabNode.localToScene(b.getMinX(), b.getMinY()));
        Point2D max = this.tabPane.sceneToLocal(this.tabNode.localToScene(b.getMaxX(), b.getMaxY()));
        return BoundsUtils.makeBounds(min, max);
    }

    @Override
    public Transform getSceneGraphToSceneTransform() {
        assert (this.isReady());
        assert (this.tabPane != null);
        return this.tabPane.getLocalToSceneTransform();
    }

    @Override
    public Point2D sceneGraphObjectToScene(double x, double y) {
        assert (this.isReady());
        assert (this.tabPane != null);
        return this.tabPane.localToScene(x, y);
    }

    @Override
    public Point2D sceneToSceneGraphObject(double x, double y) {
        assert (this.isReady());
        assert (this.tabPane != null);
        return this.tabPane.sceneToLocal(x, y);
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.tabPane != null);
        if (this.tabNode == null) {
            this.tabNode = this.lookupTabNode();
        }
        this.startListeningToLayoutBounds((Node)this.tabPane);
        this.startListeningToLocalToSceneTransform((Node)this.tabPane);
        this.startListeningToBoundsInParent(this.tabNode);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.tabPane != null);
        this.stopListeningToLayoutBounds((Node)this.tabPane);
        this.stopListeningToLocalToSceneTransform((Node)this.tabPane);
        this.stopListeningToBoundsInParent(this.tabNode);
    }

    private void tabPaneDidChange() {
        this.tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        this.setReady(this.tabPane != null);
    }

    private Node lookupTabNode() {
        assert (this.tabPane != null);
        TabPaneDesignInfoX di = new TabPaneDesignInfoX();
        return di.getTabNode(this.tabPane, (Tab)this.getSceneGraphObject());
    }
}

