/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractResilientHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TableViewDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.ResizeTableColumnGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.transform.Transform;

public class TableColumnHandles
extends AbstractResilientHandles<Object> {
    private final Group grips = new Group();
    private final TableViewDesignInfoX tableViewDesignInfo = new TableViewDesignInfoX();
    private TableView<?> tableView;
    private Node columnHeaderNode;

    public TableColumnHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Object.class);
        assert (fxomInstance.getSceneGraphObject() instanceof TableColumn);
        this.getRootNode().getChildren().add((Object)this.grips);
        this.getTableColumn().tableViewProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> ov, Object v1, Object v2) {
                TableColumnHandles.this.tableViewOrVisibilityDidChange();
            }
        });
        this.getTableColumn().visibleProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> ov, Object v1, Object v2) {
                TableColumnHandles.this.tableViewOrVisibilityDidChange();
            }
        });
        this.tableViewOrVisibilityDidChange();
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        assert (this.isReady());
        assert (this.tableView != null);
        assert (this.getTableColumn().isVisible());
        return this.tableViewDesignInfo.getColumnBounds(this.getTableColumn());
    }

    @Override
    public Transform getSceneGraphToSceneTransform() {
        assert (this.isReady());
        assert (this.tableView != null);
        return this.tableView.getLocalToSceneTransform();
    }

    @Override
    public Point2D sceneGraphObjectToScene(double x, double y) {
        assert (this.isReady());
        assert (this.tableView != null);
        return this.tableView.localToScene(x, y);
    }

    @Override
    public Point2D sceneToSceneGraphObject(double x, double y) {
        assert (this.isReady());
        assert (this.tableView != null);
        return this.tableView.sceneToLocal(x, y);
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.tableView != null);
        this.startListeningToLayoutBounds((Node)this.tableView);
        this.startListeningToLocalToSceneTransform((Node)this.tableView);
        assert (this.columnHeaderNode == null);
        this.columnHeaderNode = this.tableViewDesignInfo.getColumnNode(this.getTableColumn());
        this.startListeningToBoundsInParent(this.columnHeaderNode);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.tableView != null);
        this.stopListeningToLayoutBounds((Node)this.tableView);
        this.stopListeningToLocalToSceneTransform((Node)this.tableView);
        assert (this.columnHeaderNode != null);
        this.stopListeningToBoundsInParent(this.columnHeaderNode);
        this.columnHeaderNode = null;
    }

    @Override
    protected void layoutDecoration() {
        assert (this.tableView != null);
        super.layoutDecoration();
        this.adjustGripCount();
        int count = this.getTableColumns().size();
        for (int i = 0; i < count; ++i) {
            this.layoutGrip(i);
        }
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        AbstractGesture result;
        int gripIndex = this.grips.getChildren().indexOf((Object)node);
        if (gripIndex != -1) {
            FXOMObject parentObject = this.getFxomInstance().getParentObject();
            DesignHierarchyMask m = new DesignHierarchyMask(parentObject);
            FXOMObject columnObject = m.getSubComponentAtIndex(gripIndex);
            assert (columnObject instanceof FXOMInstance);
            result = new ResizeTableColumnGesture(this.getContentPanelController(), (FXOMInstance)columnObject);
        } else {
            result = super.findGesture(node);
        }
        return result;
    }

    private TableColumn<?, ?> getTableColumn() {
        assert (this.getSceneGraphObject() instanceof TableColumn);
        return (TableColumn)this.getSceneGraphObject();
    }

    private void tableViewOrVisibilityDidChange() {
        this.tableView = this.getTableColumn().getTableView();
        this.setReady(this.tableView != null && this.getTableColumn().isVisible());
    }

    private List<?> getTableColumns() {
        TableColumn<?, ?> tableColumn = this.getTableColumn();
        ObservableList result = tableColumn.getParentColumn() == null ? this.tableView.getColumns() : tableColumn.getParentColumn().getColumns();
        return result;
    }

    private void adjustGripCount() {
        assert (this.tableView != null);
        int columnCount = this.getTableColumns().size();
        ObservableList gripChildren = this.grips.getChildren();
        while (gripChildren.size() < columnCount) {
            gripChildren.add(this.makeGripLine());
        }
        while (gripChildren.size() > columnCount) {
            gripChildren.remove(gripChildren.size() - 1);
        }
    }

    private Line makeGripLine() {
        Line result = new Line();
        result.setStrokeWidth(10.0);
        result.setStroke((Paint)Color.TRANSPARENT);
        result.setCursor(Cursor.H_RESIZE);
        this.attachHandles((Node)result);
        return result;
    }

    private void layoutGrip(int gripIndex) {
        assert (this.grips.getChildren().get(gripIndex) instanceof Line);
        assert (this.getTableColumns().get(gripIndex) instanceof TableColumn);
        List<?> columns = this.getTableColumns();
        TableColumn tc = (TableColumn)columns.get(gripIndex);
        if (tc.isVisible()) {
            TableViewDesignInfoX di = new TableViewDesignInfoX();
            Bounds b = di.getColumnHeaderBounds(tc);
            double startX = b.getMaxX();
            double startY = b.getMinY();
            double endY = b.getMaxY();
            boolean snapToPixel = true;
            Point2D startPoint = this.sceneGraphObjectToDecoration(startX, startY, true);
            Point2D endPoint = this.sceneGraphObjectToDecoration(startX, endY, true);
            Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
            gripLine.setVisible(true);
            gripLine.setManaged(true);
            gripLine.setStartX(startPoint.getX());
            gripLine.setStartY(startPoint.getY());
            gripLine.setEndX(endPoint.getX());
            gripLine.setEndY(endPoint.getY());
        } else {
            Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
            gripLine.setVisible(false);
            gripLine.setManaged(false);
        }
    }

    private void attachHandles(Node node) {
        TableColumnHandles.attachHandles(node, this);
    }
}

