/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractResilientHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TreeTableViewDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.ResizeTreeTableColumnGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.transform.Transform;

public class TreeTableColumnHandles
extends AbstractResilientHandles<Object> {
    private final Group grips = new Group();
    private final TreeTableViewDesignInfoX tableViewDesignInfo = new TreeTableViewDesignInfoX();
    private TreeTableView<?> treeTableView;
    private Node columnHeaderNode;

    public TreeTableColumnHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Object.class);
        assert (fxomInstance.getSceneGraphObject() instanceof TreeTableColumn);
        this.getRootNode().getChildren().add((Object)this.grips);
        this.getTreeTableColumn().treeTableViewProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> ov, Object v1, Object v2) {
                TreeTableColumnHandles.this.treeTableViewOrVisibilityDidChange();
            }
        });
        this.getTreeTableColumn().visibleProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> ov, Object v1, Object v2) {
                TreeTableColumnHandles.this.treeTableViewOrVisibilityDidChange();
            }
        });
        this.treeTableViewOrVisibilityDidChange();
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        assert (this.isReady());
        assert (this.treeTableView != null);
        assert (this.getTreeTableColumn().isVisible());
        return this.tableViewDesignInfo.getColumnBounds(this.getTreeTableColumn());
    }

    @Override
    public Transform getSceneGraphToSceneTransform() {
        assert (this.isReady());
        assert (this.treeTableView != null);
        return this.treeTableView.getLocalToSceneTransform();
    }

    @Override
    public Point2D sceneGraphObjectToScene(double x, double y) {
        assert (this.isReady());
        assert (this.treeTableView != null);
        return this.treeTableView.localToScene(x, y);
    }

    @Override
    public Point2D sceneToSceneGraphObject(double x, double y) {
        assert (this.isReady());
        assert (this.treeTableView != null);
        return this.treeTableView.sceneToLocal(x, y);
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.treeTableView != null);
        this.startListeningToLayoutBounds((Node)this.treeTableView);
        this.startListeningToLocalToSceneTransform((Node)this.treeTableView);
        assert (this.columnHeaderNode == null);
        this.columnHeaderNode = this.tableViewDesignInfo.getColumnNode(this.getTreeTableColumn());
        this.startListeningToBoundsInParent(this.columnHeaderNode);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.treeTableView != null);
        this.stopListeningToLayoutBounds((Node)this.treeTableView);
        this.stopListeningToLocalToSceneTransform((Node)this.treeTableView);
        assert (this.columnHeaderNode != null);
        this.stopListeningToBoundsInParent(this.columnHeaderNode);
        this.columnHeaderNode = null;
    }

    @Override
    protected void layoutDecoration() {
        assert (this.treeTableView != null);
        super.layoutDecoration();
        this.adjustGripCount();
        int count = this.getTreeTableColumns().size();
        for (int i = 0; i < count; ++i) {
            this.layoutGrip(i);
        }
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        AbstractGesture result;
        int gripIndex = this.grips.getChildren().indexOf((Object)node);
        if (gripIndex != -1) {
            FXOMObject parentObject = this.getFxomInstance().getParentObject();
            DesignHierarchyMask m = new DesignHierarchyMask(parentObject);
            FXOMObject columnObject = m.getSubComponentAtIndex(gripIndex);
            assert (columnObject instanceof FXOMInstance);
            result = new ResizeTreeTableColumnGesture(this.getContentPanelController(), (FXOMInstance)columnObject);
        } else {
            result = super.findGesture(node);
        }
        return result;
    }

    private TreeTableColumn<?, ?> getTreeTableColumn() {
        assert (this.getSceneGraphObject() instanceof TreeTableColumn);
        return (TreeTableColumn)this.getSceneGraphObject();
    }

    private void treeTableViewOrVisibilityDidChange() {
        this.treeTableView = this.getTreeTableColumn().getTreeTableView();
        this.setReady(this.treeTableView != null && this.getTreeTableColumn().isVisible());
    }

    private List<?> getTreeTableColumns() {
        TreeTableColumn<?, ?> treeTableColumn = this.getTreeTableColumn();
        ObservableList result = treeTableColumn.getParentColumn() == null ? this.treeTableView.getColumns() : treeTableColumn.getParentColumn().getColumns();
        return result;
    }

    private void adjustGripCount() {
        assert (this.treeTableView != null);
        int columnCount = this.getTreeTableColumns().size();
        ObservableList gripChildren = this.grips.getChildren();
        while (gripChildren.size() < columnCount) {
            gripChildren.add(this.makeGripLine());
        }
        while (gripChildren.size() > columnCount) {
            gripChildren.remove(gripChildren.size() - 1);
        }
    }

    private Line makeGripLine() {
        Line result = new Line();
        result.setStrokeWidth(10.0);
        result.setStroke((Paint)Color.TRANSPARENT);
        result.setCursor(Cursor.H_RESIZE);
        this.attachHandles((Node)result);
        return result;
    }

    private void layoutGrip(int gripIndex) {
        assert (this.grips.getChildren().get(gripIndex) instanceof Line);
        assert (this.getTreeTableColumns().get(gripIndex) instanceof TreeTableColumn);
        List<?> columns = this.getTreeTableColumns();
        TreeTableColumn ttc = (TreeTableColumn)columns.get(gripIndex);
        if (ttc.isVisible()) {
            TreeTableViewDesignInfoX di = new TreeTableViewDesignInfoX();
            Bounds b = di.getColumnHeaderBounds(ttc);
            double startX = b.getMaxX();
            double startY = b.getMinY();
            double endY = b.getMaxY();
            boolean snapToPixel = true;
            Point2D startPoint = this.sceneGraphObjectToDecoration(startX, startY, true);
            Point2D endPoint = this.sceneGraphObjectToDecoration(startX, endY, true);
            Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
            gripLine.setVisible(true);
            gripLine.setManaged(true);
            gripLine.setStartX(startPoint.getX());
            gripLine.setStartY(startPoint.getY());
            gripLine.setEndX(endPoint.getX());
            gripLine.setEndY(endPoint.getY());
        } else {
            Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
            gripLine.setVisible(false);
            gripLine.setManaged(false);
        }
    }

    private void attachHandles(Node node) {
        TreeTableColumnHandles.attachHandles(node, this);
    }
}

