/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TableViewDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractGenericPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.SelectWithPringGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.transform.Transform;

public class TableColumnPring
extends AbstractGenericPring<Object> {
    private final TableViewDesignInfoX tableViewDesignInfo = new TableViewDesignInfoX();

    public TableColumnPring(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Object.class);
        assert (fxomInstance.getSceneGraphObject() instanceof TableColumn);
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        return this.tableViewDesignInfo.getColumnBounds(this.getTableColumn());
    }

    @Override
    public Transform getSceneGraphToSceneTransform() {
        return this.getTableColumn().getTableView().getLocalToSceneTransform();
    }

    @Override
    public Point2D sceneGraphObjectToScene(double x, double y) {
        TableView tv = this.getTableColumn().getTableView();
        return tv.localToScene(x, y);
    }

    @Override
    public Point2D sceneToSceneGraphObject(double x, double y) {
        TableView tv = this.getTableColumn().getTableView();
        return tv.sceneToLocal(x, y);
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        TableView tableView = this.getTableColumn().getTableView();
        this.startListeningToLayoutBounds((Node)tableView);
        this.startListeningToLocalToSceneTransform((Node)tableView);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        TableView tableView = this.getTableColumn().getTableView();
        this.stopListeningToLayoutBounds((Node)tableView);
        this.stopListeningToLocalToSceneTransform((Node)tableView);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        SelectWithPringGesture result = node == this.ringPath ? new SelectWithPringGesture(this.getContentPanelController(), this.getFxomInstance()) : null;
        return result;
    }

    private TableColumn<?, ?> getTableColumn() {
        assert (this.getSceneGraphObject() instanceof TableColumn);
        return (TableColumn)this.getSceneGraphObject();
    }
}

