/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractNodeTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.Line;

public class GenericParentTring
extends AbstractNodeTring<Parent> {
    private static final double CRACK_MIN_WIDTH = 6.0;
    private final int targetIndex;
    private final Line crackLine = new Line();

    public GenericParentTring(ContentPanelController contentPanelController, FXOMInstance fxomInstance, int targetIndex) {
        super(contentPanelController, fxomInstance, Parent.class);
        assert (targetIndex >= -1);
        this.targetIndex = targetIndex;
        this.crackLine.getStyleClass().add((Object)"target-crack");
        this.crackLine.setMouseTransparent(true);
        this.getRootNode().getChildren().add((Object)this.crackLine);
    }

    public static int lookupCrackIndex(FXOMObject fxomObject, double sceneX, double sceneY) {
        int targetIndex;
        assert (fxomObject != null);
        assert (fxomObject.getSceneGraphObject() instanceof Parent);
        DesignHierarchyMask m = new DesignHierarchyMask(fxomObject);
        Parent parent = (Parent)m.getFxomObject().getSceneGraphObject();
        Point2D hitPoint = parent.sceneToLocal(sceneX, sceneY);
        int childCount = m.getSubComponentCount();
        if (childCount == 0) {
            targetIndex = -1;
        } else {
            double midY;
            assert (childCount >= 1);
            double hitX = hitPoint.getX();
            double hitY = hitPoint.getY();
            double minDistance = Double.MAX_VALUE;
            int minIndex = -1;
            int count = childCount;
            for (int i = 0; i < count; ++i) {
                double midY2;
                Bounds cb = GenericParentTring.computeCrackBounds(m, i);
                double midX = (cb.getMinX() + cb.getMaxX()) / 2.0;
                double d = MathUtils.distance(hitX, hitY, midX, midY2 = (cb.getMinY() + cb.getMaxY()) / 2.0);
                if (!(d < minDistance)) continue;
                minIndex = i;
                minDistance = d;
            }
            Bounds cb = GenericParentTring.computeCrackBounds(m, -1);
            double midX = (cb.getMinX() + cb.getMaxX()) / 2.0;
            double d = MathUtils.distance(hitX, hitY, midX, midY = (cb.getMinY() + cb.getMaxY()) / 2.0);
            if (d < minDistance) {
                minIndex = -1;
            }
            targetIndex = minIndex;
        }
        return targetIndex;
    }

    @Override
    protected void layoutDecoration() {
        super.layoutDecoration();
        DesignHierarchyMask m = new DesignHierarchyMask(this.getFxomObject());
        int childCount = m.getSubComponentCount();
        if (childCount == 0) {
            this.crackLine.setVisible(false);
        } else {
            Bounds crackBounds = GenericParentTring.computeCrackBounds(m, this.targetIndex);
            double crackX = (crackBounds.getMinX() + crackBounds.getMaxX()) / 2.0;
            double crackY0 = crackBounds.getMinY();
            double crackY1 = crackBounds.getMaxY();
            double strokeWidth = crackBounds.getWidth();
            boolean snapToPixel = true;
            Point2D p0 = this.sceneGraphObjectToDecoration(crackX, crackY0, true);
            Point2D p1 = this.sceneGraphObjectToDecoration(crackX, crackY1, true);
            this.crackLine.setVisible(true);
            this.crackLine.setStartX(p0.getX());
            this.crackLine.setStartY(p0.getY());
            this.crackLine.setEndX(p1.getX());
            this.crackLine.setEndY(p1.getY());
            this.crackLine.setStrokeWidth(strokeWidth);
        }
    }

    private static Bounds computeCrackBounds(DesignHierarchyMask m, int childIndex) {
        double pCrackY1;
        double pCrackY0;
        double pCrackX;
        double crackWidth;
        double crackY1;
        double crackY0;
        double crackX;
        Bounds cb;
        Parent skinParent;
        assert (m != null);
        assert (m.isAcceptingSubComponent());
        assert (childIndex >= -1);
        assert (childIndex < m.getSubComponentCount());
        int childCount = m.getSubComponentCount();
        if (childIndex == -1) {
            Node child = GenericParentTring.getChildNode(m, childCount - 1);
            skinParent = child.getParent();
            cb = child.localToParent(child.getLayoutBounds());
            crackX = cb.getMaxX();
            crackY0 = cb.getMinY();
            crackY1 = cb.getMaxY();
            crackWidth = 6.0;
        } else if (childIndex == 0) {
            Node child = GenericParentTring.getChildNode(m, 0);
            skinParent = child.getParent();
            cb = child.localToParent(child.getLayoutBounds());
            crackX = cb.getMinX();
            crackY0 = cb.getMinY();
            crackY1 = cb.getMaxY();
            crackWidth = 6.0;
        } else {
            double y3;
            double y2;
            double y1;
            double y0;
            double x1;
            double x0;
            assert (1 <= childIndex && childIndex < childCount);
            Node child = GenericParentTring.getChildNode(m, childIndex);
            Node prevChild = GenericParentTring.getChildNode(m, childIndex - 1);
            if (child.getParent() != null && prevChild.getParent() != null) {
                assert (child.getParent() == prevChild.getParent());
                skinParent = child.getParent();
                Bounds prevBounds = prevChild.getBoundsInParent();
                Bounds bounds = child.getBoundsInParent();
                x0 = prevBounds.getMaxX();
                x1 = bounds.getMinX();
                y0 = bounds.getMinY();
                y1 = prevBounds.getMinY();
                y2 = prevBounds.getMaxY();
                y3 = bounds.getMaxY();
            } else if (child.getParent() != null) {
                skinParent = child.getParent();
                Bounds bounds = child.getBoundsInParent();
                x0 = x1 = bounds.getMinX();
                y0 = y1 = bounds.getMinY();
                y2 = y3 = bounds.getMaxY();
            } else if (prevChild.getParent() != null) {
                skinParent = prevChild.getParent();
                Bounds prevBounds = prevChild.getBoundsInParent();
                x0 = x1 = prevBounds.getMaxX();
                y0 = y1 = prevBounds.getMinY();
                y2 = y3 = prevBounds.getMaxY();
            } else {
                y3 = 0.0;
                y2 = 0.0;
                y1 = 0.0;
                y0 = 0.0;
                x1 = 0.0;
                x0 = 0.0;
                skinParent = null;
            }
            if (x0 <= x1) {
                crackX = (x0 + x1) / 2.0;
                crackY0 = Math.min(y0, y1);
                crackY1 = Math.max(y2, y3);
                crackWidth = Math.max(6.0, x1 - x0);
            } else {
                crackX = x1;
                crackY0 = y0;
                crackY1 = y3;
                crackWidth = 6.0;
            }
        }
        assert (m.getFxomObject().getSceneGraphObject() instanceof Parent);
        Parent parent = (Parent)m.getFxomObject().getSceneGraphObject();
        if (parent != skinParent) {
            if (skinParent != null) {
                Point2D p0 = parent.sceneToLocal(skinParent.localToScene(crackX, crackY0));
                Point2D p1 = parent.sceneToLocal(skinParent.localToScene(crackX, crackY1));
                assert (MathUtils.equals(p0.getX(), p1.getX()));
                pCrackX = p0.getX();
                pCrackY0 = p0.getY();
                pCrackY1 = p1.getY();
            } else {
                pCrackX = 0.0;
                pCrackY0 = 0.0;
                pCrackY1 = 0.0;
            }
        } else {
            pCrackX = crackX;
            pCrackY0 = crackY0;
            pCrackY1 = crackY1;
        }
        return new BoundingBox(pCrackX - crackWidth / 2.0, pCrackY0, crackWidth, pCrackY1 - pCrackY0);
    }

    private static Node getChildNode(DesignHierarchyMask m, int childIndex) {
        assert (m != null);
        assert (m.isAcceptingSubComponent());
        assert (0 <= childIndex);
        assert (childIndex < m.getSubComponentCount());
        FXOMObject childObject = m.getSubComponentAtIndex(childIndex);
        assert (childObject.getSceneGraphObject() instanceof Node);
        return (Node)childObject.getSceneGraphObject();
    }
}

