/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabOutline;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Transform;

public class TabTring
extends AbstractTring<Tab> {
    private final TabOutline tabOutline;

    public TabTring(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Tab.class);
        assert (fxomInstance.getSceneGraphObject() instanceof Tab);
        this.tabOutline = new TabOutline((Tab)this.getSceneGraphObject());
        this.tabOutline.getRingPath().getStyleClass().add((Object)"target-ring");
        this.tabOutline.getRingPath().setMouseTransparent(true);
        this.getRootNode().getChildren().add((Object)this.tabOutline.getRingPath());
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    protected void layoutDecoration() {
        this.tabOutline.layout(this);
    }

    @Override
    public void changeStroke(Paint stroke) {
        this.tabOutline.getRingPath().setStroke(stroke);
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        return ((Tab)this.getSceneGraphObject()).getTabPane().getLayoutBounds();
    }

    @Override
    public Transform getSceneGraphToSceneTransform() {
        return ((Tab)this.getSceneGraphObject()).getTabPane().getLocalToSceneTransform();
    }

    @Override
    public Point2D sceneGraphObjectToScene(double x, double y) {
        TabPane tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        return tabPane.localToScene(x, y);
    }

    @Override
    public Point2D sceneToSceneGraphObject(double x, double y) {
        TabPane tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        return tabPane.sceneToLocal(x, y);
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        TabPane tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        this.startListeningToLayoutBounds((Node)tabPane);
        this.startListeningToLocalToSceneTransform((Node)tabPane);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        TabPane tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        this.stopListeningToLayoutBounds((Node)tabPane);
        this.stopListeningToLocalToSceneTransform((Node)tabPane);
    }
}

