/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;

public abstract class AbstractMouseDragGesture
extends AbstractGesture {
    private AbstractGesture.Observer observer;
    private Node eventTarget;

    public AbstractMouseDragGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    protected abstract void mousePressed(MouseEvent var1);

    protected abstract void mouseDragDetected(MouseEvent var1);

    protected abstract void mouseReleased(MouseEvent var1);

    protected abstract void mouseExited(MouseEvent var1);

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e instanceof MouseEvent);
        assert (e.getEventType() == MouseEvent.MOUSE_PRESSED);
        assert (e.getTarget() instanceof Node);
        assert (observer != null);
        this.observer = observer;
        this.eventTarget = (Node)e.getTarget();
        assert (this.eventTarget.getOnDragDetected() == null);
        assert (this.eventTarget.getOnMouseReleased() == null);
        assert (this.eventTarget.getOnMouseExited() == null);
        this.eventTarget.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                try {
                    AbstractMouseDragGesture.this.mouseDragDetected(e);
                }
                finally {
                    AbstractMouseDragGesture.this.performTermination();
                }
            }
        });
        this.eventTarget.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                try {
                    AbstractMouseDragGesture.this.mouseReleased(e);
                }
                finally {
                    AbstractMouseDragGesture.this.performTermination();
                }
            }
        });
        this.eventTarget.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                try {
                    AbstractMouseDragGesture.this.mouseExited(e);
                }
                finally {
                    AbstractMouseDragGesture.this.performTermination();
                }
            }
        });
        try {
            this.mousePressed((MouseEvent)e);
        }
        catch (RuntimeException x) {
            this.performTermination();
            throw x;
        }
    }

    private void performTermination() {
        this.eventTarget.setOnDragDetected(null);
        this.eventTarget.setOnMouseReleased(null);
        this.eventTarget.setOnMouseExited(null);
        try {
            this.observer.gestureDidTerminate(this);
        }
        finally {
            this.observer = null;
            this.eventTarget = null;
        }
    }
}

