/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;

public abstract class AbstractMouseGesture
extends AbstractGesture {
    private MouseEvent mousePressedEvent;
    private MouseEvent lastMouseEvent;
    private AbstractGesture.Observer observer;
    private boolean mouseDidDrag;

    protected abstract void mousePressed();

    protected abstract void mouseDragStarted();

    protected abstract void mouseDragged();

    protected abstract void mouseDragEnded();

    protected abstract void mouseReleased();

    protected abstract void keyEvent(KeyEvent var1);

    protected abstract void userDidCancel();

    public AbstractMouseGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    protected MouseEvent getMousePressedEvent() {
        return this.mousePressedEvent;
    }

    protected MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    protected boolean isStarted() {
        return this.observer != null;
    }

    protected boolean isMouseDidDrag() {
        return this.mouseDidDrag;
    }

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e instanceof MouseEvent);
        assert (e.getEventType() == MouseEvent.MOUSE_PRESSED);
        assert (observer != null);
        assert (!this.mouseDidDrag);
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnDragDetected() == null);
        assert (glassLayer.getOnMouseDragged() == null);
        assert (glassLayer.getOnMouseReleased() == null);
        assert (glassLayer.getOnKeyPressed() == null);
        assert (glassLayer.getOnKeyReleased() == null);
        glassLayer.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>((Node)glassLayer){
            final /* synthetic */ Node val$glassLayer;
            {
                this.val$glassLayer = node;
            }

            public void handle(MouseEvent e) {
                AbstractMouseGesture.this.lastMouseEvent = e;
                AbstractMouseGesture.this.mouseDidDrag = true;
                AbstractMouseGesture.this.mouseDragStarted();
                this.val$glassLayer.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent e) {
                        AbstractMouseGesture.this.lastMouseEvent = e;
                        AbstractMouseGesture.this.mouseDragged();
                    }
                });
            }
        });
        glassLayer.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>((Node)glassLayer){
            final /* synthetic */ Node val$glassLayer;
            {
                this.val$glassLayer = node;
            }

            public void handle(MouseEvent e) {
                AbstractMouseGesture.this.lastMouseEvent = e;
                try {
                    if (AbstractMouseGesture.this.mouseDidDrag) {
                        try {
                            AbstractMouseGesture.this.mouseDragEnded();
                        }
                        finally {
                            this.val$glassLayer.setOnMouseDragged(null);
                        }
                    }
                    AbstractMouseGesture.this.mouseReleased();
                }
                finally {
                    AbstractMouseGesture.this.performTermination();
                }
            }
        });
        glassLayer.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                AbstractMouseGesture.this.handleKeyPressed(e);
            }
        });
        glassLayer.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                AbstractMouseGesture.this.handleKeyReleased(e);
            }
        });
        this.lastMouseEvent = this.mousePressedEvent = (MouseEvent)e;
        this.observer = observer;
        try {
            this.mousePressed();
        }
        catch (RuntimeException x) {
            this.performTermination();
            throw x;
        }
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.getCode() == KeyCode.ESCAPE) {
            if (this.mouseDidDrag) {
                this.contentPanelController.getGlassLayer().setOnMouseDragged(null);
            }
            this.userDidCancel();
            this.performTermination();
        } else {
            this.keyEvent(e);
        }
    }

    private void handleKeyReleased(KeyEvent e) {
        this.keyEvent(e);
    }

    private void performTermination() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnDragDetected(null);
        glassLayer.setOnMouseReleased(null);
        glassLayer.setOnKeyPressed(null);
        glassLayer.setOnKeyReleased(null);
        try {
            this.observer.gestureDidTerminate(this);
        }
        finally {
            this.observer = null;
            this.mousePressedEvent = null;
            this.lastMouseEvent = null;
            this.mouseDidDrag = false;
        }
    }
}

