/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.HudWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater.AbstractRelocater;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater.AnchorPaneRelocater;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater.PaneRelocater;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.rudder.ResizeRudder;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.ResizingGuideController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.RegionRectangle;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Transform;

public class ResizeGesture
extends AbstractMouseGesture {
    private final FXOMInstance fxomInstance;
    private final CardinalPoint tunable;
    private final ResizeRudder rudder;
    private AbstractResizer<?> resizer;
    private AbstractRelocater<?> relocater;
    private ResizingGuideController resizingGuideController;
    private RegionRectangle shadow;
    private boolean snapEnabled;
    private boolean guidesDisabled;

    public ResizeGesture(ContentPanelController contentPanelController, FXOMInstance fxomInstance, CardinalPoint tunable) {
        super(contentPanelController);
        assert (contentPanelController.lookupDriver(fxomInstance) != null);
        assert (fxomInstance.getSceneGraphObject() instanceof Node);
        this.fxomInstance = fxomInstance;
        this.tunable = tunable;
        this.rudder = new ResizeRudder(contentPanelController, fxomInstance);
    }

    @Override
    protected void mousePressed() {
    }

    @Override
    protected void mouseDragStarted() {
        this.resizer = this.contentPanelController.lookupDriver(this.fxomInstance).makeResizer(this.fxomInstance);
        assert (this.resizer != null);
        assert (this.resizer.getSceneGraphObject() == this.fxomInstance.getSceneGraphObject());
        Object sceneGraphObject = this.resizer.getSceneGraphObject();
        Parent sceneGraphParent = sceneGraphObject.getParent();
        assert (sceneGraphParent != null);
        this.relocater = sceneGraphParent.getClass() == Pane.class ? new PaneRelocater((Node)sceneGraphObject) : (sceneGraphParent.getClass() == AnchorPane.class ? new AnchorPaneRelocater((Node)sceneGraphObject) : null);
        if (this.relocater != null && this.contentPanelController.isGuidesVisible()) {
            this.setupResizingGuideController();
            assert (this.resizingGuideController != null);
        }
        this.snapEnabled = this.getMousePressedEvent().isShiftDown();
        this.setupAndOpenHudWindow();
        this.showShadow();
        this.contentPanelController.getHandleLayer().setVisible(false);
        this.mouseDragged();
    }

    @Override
    protected void mouseDragged() {
        this.setRudderVisible(this.isSnapRequired());
        this.updateSceneGraphObjectSize();
        this.contentPanelController.getHudWindowController().updatePopupLocation();
        this.updateShadow();
    }

    @Override
    protected void mouseDragEnded() {
        EditorController editorController;
        BatchModifyObjectJob j;
        this.updateSceneGraphObjectSize();
        HashMap<PropertyName, Object> changeMap = new HashMap<PropertyName, Object>();
        changeMap.putAll(this.resizer.getChangeMap());
        if (this.relocater != null) {
            changeMap.putAll(this.relocater.getChangeMap());
        }
        this.userDidCancel();
        Metadata metadata = Metadata.getMetadata();
        HashMap<ValuePropertyMetadata, Object> metaValueMap = new HashMap<ValuePropertyMetadata, Object>();
        for (Map.Entry e : changeMap.entrySet()) {
            ValuePropertyMetadata vpm = metadata.queryValueProperty(this.fxomInstance, (PropertyName)e.getKey());
            assert (vpm != null);
            metaValueMap.put(vpm, e.getValue());
        }
        if (!changeMap.isEmpty() && (j = new BatchModifyObjectJob(this.fxomInstance, "Resize", metaValueMap, editorController = this.contentPanelController.getEditorController())).isExecutable()) {
            editorController.getJobManager().push(j);
        }
    }

    @Override
    protected void mouseReleased() {
    }

    @Override
    protected void keyEvent(KeyEvent ke) {
        if (ke.getCode() == KeyCode.SHIFT) {
            EventType eventType = ke.getEventType();
            if (eventType == KeyEvent.KEY_PRESSED) {
                this.snapEnabled = true;
            } else if (eventType == KeyEvent.KEY_RELEASED) {
                this.snapEnabled = false;
            }
            if (this.isMouseDidDrag()) {
                this.mouseDragged();
            }
        } else if (ke.getCode() == KeyCode.ALT) {
            EventType eventType = ke.getEventType();
            if (eventType == KeyEvent.KEY_PRESSED) {
                this.guidesDisabled = true;
            } else if (eventType == KeyEvent.KEY_RELEASED) {
                this.guidesDisabled = false;
            }
            if (this.isMouseDidDrag()) {
                this.mouseDragged();
            }
        }
    }

    @Override
    protected void userDidCancel() {
        this.resizer.revertToOriginalSize();
        if (this.relocater != null) {
            this.relocater.revertToOriginalLocation();
        }
        if (this.resizingGuideController != null) {
            this.dismantleResizingGuideController();
            assert (this.resizingGuideController == null);
        }
        this.setRudderVisible(false);
        this.hideShadow();
        this.contentPanelController.getHudWindowController().closeWindow();
        this.contentPanelController.getHandleLayer().setVisible(true);
        this.resizer.getSceneGraphObject().getParent().layout();
    }

    private void updateSceneGraphObjectSize() {
        Bounds guidedLayoutBounds;
        Bounds candidateBounds;
        double rawDeltaY;
        double rawDeltaX;
        assert (this.resizer != null);
        this.resizer.revertToOriginalSize();
        if (this.relocater != null) {
            this.relocater.revertToOriginalLocation();
        }
        Object sceneGraphObject = this.resizer.getSceneGraphObject();
        sceneGraphObject.getParent().layout();
        double startSceneX = this.getMousePressedEvent().getSceneX();
        double startSceneY = this.getMousePressedEvent().getSceneY();
        double currentSceneX = this.getLastMouseEvent().getSceneX();
        double currentSceneY = this.getLastMouseEvent().getSceneY();
        Point2D start = sceneGraphObject.sceneToLocal(startSceneX, startSceneY);
        Point2D current = sceneGraphObject.sceneToLocal(currentSceneX, currentSceneY);
        if (start != null && current != null) {
            rawDeltaX = current.getX() - start.getX();
            rawDeltaY = current.getY() - start.getY();
        } else {
            rawDeltaX = currentSceneX - startSceneX;
            rawDeltaY = currentSceneY - startSceneY;
        }
        Point2D clampDelta = this.tunable.clampVector(rawDeltaX, rawDeltaY);
        double clampDeltaX = clampDelta.getX();
        double clampDeltaY = clampDelta.getY();
        Bounds layoutBounds = sceneGraphObject.getLayoutBounds();
        Bounds resizedBounds = this.tunable.getResizedBounds(layoutBounds, clampDeltaX, clampDeltaY);
        if (this.isSnapRequired()) {
            double ratio = layoutBounds.getHeight() / layoutBounds.getWidth();
            candidateBounds = this.tunable.snapBounds(resizedBounds, ratio);
        } else {
            candidateBounds = resizedBounds;
        }
        double candidateWidth = candidateBounds.getWidth();
        double candidateHeight = candidateBounds.getHeight();
        Bounds newLayoutBounds = this.resizer.computeBounds(candidateWidth, candidateHeight);
        if (this.resizingGuideController == null) {
            guidedLayoutBounds = newLayoutBounds;
        } else if (this.guidesDisabled) {
            this.resizingGuideController.clear();
            guidedLayoutBounds = newLayoutBounds;
        } else {
            this.resizingGuideController.match(newLayoutBounds);
            double suggestedWidth = this.resizingGuideController.getSuggestedWidth();
            double suggestedHeight = this.resizingGuideController.getSuggestedHeight();
            guidedLayoutBounds = this.resizer.computeBounds(suggestedWidth, suggestedHeight);
        }
        CardinalPoint fix = this.tunable.getOpposite();
        Point2D currentFixPos = fix.getPosition(layoutBounds);
        Point2D newFixPos = fix.getPosition(guidedLayoutBounds);
        Point2D currentParent = sceneGraphObject.localToParent(currentFixPos);
        Point2D newParent = sceneGraphObject.localToParent(newFixPos);
        double layoutDX = currentParent.getX() - newParent.getX();
        double layoutDY = currentParent.getY() - newParent.getY();
        double newLayoutX = sceneGraphObject.getLayoutX() + layoutDX;
        double newLayoutY = sceneGraphObject.getLayoutY() + layoutDY;
        this.resizer.changeWidth(guidedLayoutBounds.getWidth());
        this.resizer.changeHeight(guidedLayoutBounds.getHeight());
        if (this.relocater != null) {
            sceneGraphObject.getParent().layout();
            this.relocater.moveToLayoutX(newLayoutX, guidedLayoutBounds);
            this.relocater.moveToLayoutY(newLayoutY, guidedLayoutBounds);
        }
        sceneGraphObject.getParent().layout();
        this.updateHudWindow();
    }

    private boolean isSnapRequired() {
        return this.snapEnabled || this.resizer.getFeature() == AbstractResizer.Feature.SCALING;
    }

    private void setRudderVisible(boolean visible) {
        boolean alreadyVisible;
        boolean bl = alreadyVisible = this.rudder.getRootNode().getParent() != null;
        if (alreadyVisible != visible) {
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            if (visible) {
                assert (this.rudder.getRootNode().getParent() == null);
                rudderLayer.getChildren().add((Object)this.rudder.getRootNode());
            } else {
                assert (this.rudder.getRootNode().getParent() == rudderLayer);
                rudderLayer.getChildren().remove((Object)this.rudder.getRootNode());
            }
        }
    }

    private void setupAndOpenHudWindow() {
        HudWindowController hudWindowController = this.contentPanelController.getHudWindowController();
        int sizeRowCount = this.resizer.getPropertyNames().size();
        int locationRowCount = this.relocater != null ? this.relocater.getPropertyNames().size() : 0;
        hudWindowController.setRowCount(sizeRowCount + locationRowCount);
        List<PropertyName> sizePropertyNames = this.resizer.getPropertyNames();
        for (int i = 0; i < sizeRowCount; ++i) {
            PropertyName pn = sizePropertyNames.get(i);
            hudWindowController.setNameAtRowIndex(this.makeNameString(pn), i);
        }
        if (this.relocater != null) {
            List<PropertyName> locationPropertyNames = this.relocater.getPropertyNames();
            for (int i = 0; i < locationRowCount; ++i) {
                PropertyName pn = locationPropertyNames.get(i);
                hudWindowController.setNameAtRowIndex(this.makeNameString(pn), sizeRowCount + i);
            }
        }
        this.updateHudWindow();
        hudWindowController.setRelativePosition(this.tunable);
        hudWindowController.openWindow((Node)this.resizer.getSceneGraphObject());
    }

    private String makeNameString(PropertyName pn) {
        return pn.getName() + ":";
    }

    private void updateHudWindow() {
        HudWindowController hudWindowController = this.contentPanelController.getHudWindowController();
        List<PropertyName> sizePropertyNames = this.resizer.getPropertyNames();
        int sizeRowCount = sizePropertyNames.size();
        for (int i = 0; i < sizeRowCount; ++i) {
            PropertyName pn = sizePropertyNames.get(i);
            String value = String.valueOf(this.resizer.getValue(pn));
            hudWindowController.setValueAtRowIndex(value, i);
        }
        if (this.relocater != null) {
            List<PropertyName> locationPropertyNames = this.relocater.getPropertyNames();
            int locationRowCount = locationPropertyNames.size();
            for (int i = 0; i < locationRowCount; ++i) {
                PropertyName pn = locationPropertyNames.get(i);
                String value = String.valueOf(this.relocater.getValue(pn));
                hudWindowController.setValueAtRowIndex(value, sizeRowCount + i);
            }
        }
    }

    private void showShadow() {
        assert (this.shadow == null);
        this.shadow = new RegionRectangle();
        this.shadow.getRegion().getStyleClass().add((Object)"resize-shadow");
        this.shadow.setMouseTransparent(true);
        this.contentPanelController.getRudderLayer().getChildren().add((Object)this.shadow);
        this.updateShadow();
    }

    private void updateShadow() {
        assert (this.shadow != null);
        Object sceneGraphObject = this.resizer.getSceneGraphObject();
        Transform sceneGraphObjectTransform = this.contentPanelController.computeSceneGraphToRudderLayerTransform((Node)sceneGraphObject);
        this.shadow.getTransforms().clear();
        this.shadow.getTransforms().add((Object)sceneGraphObjectTransform);
        this.shadow.setLayoutBounds(sceneGraphObject.getLayoutBounds());
    }

    private void hideShadow() {
        assert (this.shadow != null);
        this.contentPanelController.getRudderLayer().getChildren().remove((Object)this.shadow);
        this.shadow = null;
    }

    private void setupResizingGuideController() {
        boolean matchHeight;
        boolean matchWidth;
        switch (this.tunable) {
            case N: 
            case S: {
                matchWidth = false;
                matchHeight = true;
                break;
            }
            case E: 
            case W: {
                matchWidth = true;
                matchHeight = false;
                break;
            }
            default: {
                matchWidth = true;
                matchHeight = true;
            }
        }
        this.resizingGuideController = new ResizingGuideController(matchWidth, matchHeight, this.contentPanelController.getGuidesColor());
        this.addToResizingGuideController(this.fxomInstance.getFxomDocument().getFxomRoot());
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        Group guideGroup = this.resizingGuideController.getGuideGroup();
        assert (guideGroup.isMouseTransparent());
        rudderLayer.getChildren().add((Object)guideGroup);
    }

    private void addToResizingGuideController(FXOMObject fxomObject) {
        assert (fxomObject != null);
        if (fxomObject != this.fxomInstance) {
            DesignHierarchyMask m;
            if (fxomObject.getSceneGraphObject() instanceof Node) {
                Node sceneGraphNode = (Node)fxomObject.getSceneGraphObject();
                this.resizingGuideController.addSampleBounds(sceneGraphNode);
            }
            if ((m = new DesignHierarchyMask(fxomObject)).isAcceptingSubComponent()) {
                int count = m.getSubComponentCount();
                for (int i = 0; i < count; ++i) {
                    this.addToResizingGuideController(m.getSubComponentAtIndex(i));
                }
            }
        }
    }

    private void dismantleResizingGuideController() {
        assert (this.resizingGuideController != null);
        Group guideGroup = this.resizingGuideController.getGuideGroup();
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        assert (rudderLayer.getChildren().contains((Object)guideGroup));
        rudderLayer.getChildren().remove((Object)guideGroup);
        this.resizingGuideController = null;
    }
}

