/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.GridPaneRowResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.RowConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class ResizeRowGesture
extends AbstractMouseGesture {
    private static final PropertyName rowConstraintsName = new PropertyName("rowConstraints");
    private static final ValuePropertyMetadata rowConstraintsMeta = new RowConstraintsListPropertyMetadata(rowConstraintsName, true, Collections.emptyList(), InspectorPath.UNUSED);
    private final GridPaneHandles gridPaneHandles;
    private final FXOMInstance fxomInstance;
    private final int rowIndex;
    private final GridPane gridPane;
    private GridPaneRowResizer resizer;

    public ResizeRowGesture(GridPaneHandles gridPaneHandles, int rowIndex) {
        super(gridPaneHandles.getContentPanelController());
        assert (rowIndex >= 0);
        this.gridPaneHandles = gridPaneHandles;
        this.fxomInstance = gridPaneHandles.getFxomInstance();
        this.gridPane = (GridPane)this.fxomInstance.getSceneGraphObject();
        this.rowIndex = rowIndex;
        assert (this.rowIndex < Deprecation.getGridPaneRowCount(this.gridPane));
    }

    @Override
    protected void mousePressed() {
    }

    @Override
    protected void mouseDragStarted() {
        assert (this.resizer == null);
        this.resizer = new GridPaneRowResizer(this.gridPane, this.rowIndex);
        this.mouseDragged();
    }

    @Override
    protected void mouseDragged() {
        assert (this.resizer != null);
        double startSceneX = this.getMousePressedEvent().getSceneX();
        double startSceneY = this.getMousePressedEvent().getSceneY();
        double currentSceneX = this.getLastMouseEvent().getSceneX();
        double currentSceneY = this.getLastMouseEvent().getSceneY();
        Point2D start = this.gridPane.sceneToLocal(startSceneX, startSceneY);
        Point2D current = this.gridPane.sceneToLocal(currentSceneX, currentSceneY);
        double dy = current.getY() - start.getY();
        this.resizer.updateHeight(dy);
        this.gridPane.layout();
        this.gridPaneHandles.layoutDecoration();
    }

    @Override
    protected void mouseDragEnded() {
        assert (this.resizer != null);
        List<RowConstraints> newConstraints = this.cloneRowConstraintsList(this.gridPane);
        this.userDidCancel();
        HashMap<ValuePropertyMetadata, Object> metaValueMap = new HashMap<ValuePropertyMetadata, Object>();
        metaValueMap.put(rowConstraintsMeta, newConstraints);
        EditorController editorController = this.contentPanelController.getEditorController();
        BatchModifyObjectJob j = new BatchModifyObjectJob(this.fxomInstance, I18N.getString("label.action.edit.resize.row"), metaValueMap, editorController);
        editorController.getJobManager().push(j);
        this.gridPaneHandles.layoutDecoration();
        this.resizer = null;
    }

    @Override
    protected void mouseReleased() {
    }

    @Override
    protected void keyEvent(KeyEvent e) {
    }

    @Override
    protected void userDidCancel() {
        this.resizer.revertToOriginalSize();
        this.gridPane.layout();
    }

    private List<RowConstraints> cloneRowConstraintsList(GridPane gridPane) {
        ArrayList<RowConstraints> result = new ArrayList<RowConstraints>();
        for (RowConstraints rc : gridPane.getRowConstraints()) {
            result.add(this.cloneRowConstraints(rc));
        }
        return result;
    }

    private RowConstraints cloneRowConstraints(RowConstraints cc) {
        RowConstraints result = new RowConstraints();
        result.setFillHeight(cc.isFillHeight());
        result.setValignment(cc.getValignment());
        result.setVgrow(cc.getVgrow());
        result.setMaxHeight(cc.getMaxHeight());
        result.setMinHeight(cc.getMinHeight());
        result.setPercentHeight(cc.getPercentHeight());
        result.setPrefHeight(cc.getPrefHeight());
        return result;
    }
}

