/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DocumentDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseDragGesture;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public class SelectAndMoveGesture
extends AbstractMouseDragGesture {
    private FXOMObject hitObject;
    private double hitSceneX;
    private double hitSceneY;

    public SelectAndMoveGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    public FXOMObject getHitObject() {
        return this.hitObject;
    }

    public void setHitObject(FXOMObject hitObject) {
        this.hitObject = hitObject;
    }

    public void setHitSceneX(double hitSceneX) {
        this.hitSceneX = hitSceneX;
    }

    public void setHitSceneY(double hitSceneY) {
        this.hitSceneY = hitSceneY;
    }

    @Override
    protected void mousePressed(MouseEvent e) {
        boolean extendKeyDown;
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        boolean bl = extendKeyDown = EditorPlatform.isContinuousSelectKeyDown(e) || EditorPlatform.isNonContinousSelectKeyDown(e);
        if (selection.isSelected(this.hitObject)) {
            if (extendKeyDown) {
                selection.toggleSelection(this.hitObject);
            }
        } else {
            FXOMObject ancestor = selection.lookupSelectedAncestor(this.hitObject);
            if (ancestor == null) {
                if (extendKeyDown) {
                    selection.toggleSelection(this.hitObject);
                } else {
                    selection.select(this.hitObject);
                }
            } else if (extendKeyDown) {
                selection.toggleSelection(ancestor);
            }
        }
    }

    @Override
    protected void mouseDragDetected(MouseEvent e) {
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        FXOMObject selectedHitObject = selection.isSelected(this.hitObject) ? this.hitObject : selection.lookupSelectedAncestor(this.hitObject);
        if (selectedHitObject != null) {
            assert (selection.getGroup() instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            if (osg.hasSingleParent()) {
                EditorController editorController = this.contentPanelController.getEditorController();
                Window ownerWindow = this.contentPanelController.getPanelRoot().getScene().getWindow();
                Point2D hitPoint = this.computeHitPoint(selectedHitObject);
                DocumentDragSource dragSource = new DocumentDragSource(osg.getSortedItems(), selectedHitObject, hitPoint.getX(), hitPoint.getY(), ownerWindow);
                if (dragSource.isAcceptable()) {
                    Pane glassLayer = this.contentPanelController.getGlassLayer();
                    Dragboard db = glassLayer.startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    db.setContent((Map)dragSource.makeClipboardContent());
                    db.setDragView(dragSource.makeDragView());
                    assert (editorController.getDragController().getDragSource() == null);
                    editorController.getDragController().begin(dragSource);
                }
            }
        }
    }

    private Point2D computeHitPoint(FXOMObject fxomObject) {
        FXOMObject nodeObject = fxomObject.getClosestNode();
        assert (nodeObject != null);
        assert (nodeObject.getSceneGraphObject() instanceof Node);
        Node sceneGraphNode = (Node)nodeObject.getSceneGraphObject();
        return sceneGraphNode.sceneToLocal(this.hitSceneX, this.hitSceneY);
    }

    @Override
    protected void mouseReleased(MouseEvent e) {
        boolean extendKeyDown;
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        boolean bl = extendKeyDown = EditorPlatform.isContinuousSelectKeyDown(e) || EditorPlatform.isNonContinousSelectKeyDown(e);
        if (!extendKeyDown) {
            selection.select(this.hitObject);
        }
    }

    @Override
    protected void mouseExited(MouseEvent e) {
    }
}

