/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalLineIndex;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.MovingGuideRenderer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalLineIndex;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalSegment;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Paint;

public class MovingGuideController {
    private final double MATCH_DISTANCE = 6.0;
    private final HorizontalLineIndex horizontalLineIndex = new HorizontalLineIndex();
    private final VerticalLineIndex verticalLineIndex = new VerticalLineIndex();
    private final MovingGuideRenderer renderer;
    private double suggestedDX;
    private double suggestedDY;

    public MovingGuideController(Paint chromeColor, Bounds scopeInScene) {
        this.renderer = new MovingGuideRenderer(chromeColor, scopeInScene);
    }

    public void addSampleBounds(Node node) {
        assert (node != null);
        assert (node.getScene() != null);
        Bounds layoutBounds = node.getLayoutBounds();
        Bounds boundsInScene = node.localToScene(layoutBounds);
        this.addSampleBounds(boundsInScene, true);
    }

    public void addSampleBounds(Bounds boundsInScene, boolean addMiddle) {
        double minX = boundsInScene.getMinX();
        double minY = boundsInScene.getMinY();
        double maxX = boundsInScene.getMaxX();
        double maxY = boundsInScene.getMaxY();
        double midX = (minX + maxX) / 2.0;
        double midY = (minY + maxY) / 2.0;
        this.horizontalLineIndex.addLine(new HorizontalSegment(minX, maxX, minY));
        this.horizontalLineIndex.addLine(new HorizontalSegment(minX, maxX, maxY));
        this.verticalLineIndex.addLine(new VerticalSegment(minX, minY, maxY));
        this.verticalLineIndex.addLine(new VerticalSegment(maxX, minY, maxY));
        if (addMiddle) {
            this.horizontalLineIndex.addLine(new HorizontalSegment(minX, maxX, midY));
            this.verticalLineIndex.addLine(new VerticalSegment(midX, minY, maxY));
        }
    }

    public void clearSampleBounds() {
        this.horizontalLineIndex.clear();
        this.verticalLineIndex.clear();
        this.clear();
    }

    public boolean hasSampleBounds() {
        return !this.horizontalLineIndex.isEmpty() || !this.verticalLineIndex.isEmpty();
    }

    public void clear() {
        this.renderer.setLines(Collections.emptyList(), Collections.emptyList());
    }

    public void match(Bounds targetBounds) {
        List<VerticalSegment> verticalMatchingLines;
        AbstractSegment line;
        boolean matchedHorizontally = false;
        boolean matchedVertically = false;
        List<HorizontalSegment> horizontalMatchingLines = this.horizontalLineIndex.matchCenter(targetBounds, 6.0);
        if (!horizontalMatchingLines.isEmpty()) {
            matchedHorizontally = true;
            line = horizontalMatchingLines.get(0);
            assert (MathUtils.equals(((HorizontalSegment)line).getY1(), ((HorizontalSegment)line).getY2()));
            double targetMinY = targetBounds.getMinY();
            double targetMaxY = targetBounds.getMaxY();
            double targetMidY = (targetMinY + targetMaxY) / 2.0;
            this.suggestedDY = ((HorizontalSegment)line).getY1() - targetMidY;
        }
        if (!matchedHorizontally && !(horizontalMatchingLines = this.horizontalLineIndex.matchNorth(targetBounds, 6.0)).isEmpty()) {
            matchedHorizontally = true;
            line = horizontalMatchingLines.get(0);
            assert (MathUtils.equals(((HorizontalSegment)line).getY1(), ((HorizontalSegment)line).getY2()));
            this.suggestedDY = ((HorizontalSegment)line).getY1() - targetBounds.getMinY();
        }
        if (!matchedHorizontally && !(horizontalMatchingLines = this.horizontalLineIndex.matchSouth(targetBounds, 6.0)).isEmpty()) {
            matchedHorizontally = true;
            line = horizontalMatchingLines.get(0);
            assert (MathUtils.equals(((HorizontalSegment)line).getY1(), ((HorizontalSegment)line).getY2()));
            this.suggestedDY = ((HorizontalSegment)line).getY1() - targetBounds.getMaxY();
        }
        if (!matchedHorizontally) {
            this.suggestedDY = 0.0;
        }
        if (!(verticalMatchingLines = this.verticalLineIndex.matchCenter(targetBounds, 6.0)).isEmpty()) {
            matchedVertically = true;
            line = verticalMatchingLines.get(0);
            assert (MathUtils.equals(((VerticalSegment)line).getX1(), ((VerticalSegment)line).getX2()));
            double targetMinX = targetBounds.getMinX();
            double targetMaxX = targetBounds.getMaxX();
            double targetMidX = (targetMinX + targetMaxX) / 2.0;
            this.suggestedDX = ((VerticalSegment)line).getX1() - targetMidX;
        }
        if (!matchedVertically && !(verticalMatchingLines = this.verticalLineIndex.matchWest(targetBounds, 6.0)).isEmpty()) {
            matchedVertically = true;
            line = verticalMatchingLines.get(0);
            assert (MathUtils.equals(((VerticalSegment)line).getX1(), ((VerticalSegment)line).getX2()));
            this.suggestedDX = ((VerticalSegment)line).getX1() - targetBounds.getMinX();
        }
        if (!matchedVertically && !(verticalMatchingLines = this.verticalLineIndex.matchEast(targetBounds, 6.0)).isEmpty()) {
            matchedVertically = true;
            line = verticalMatchingLines.get(0);
            assert (MathUtils.equals(((VerticalSegment)line).getX1(), ((VerticalSegment)line).getX2()));
            this.suggestedDX = ((VerticalSegment)line).getX1() - targetBounds.getMaxX();
        }
        if (!matchedVertically) {
            this.suggestedDX = 0.0;
        }
        this.renderer.setLines(horizontalMatchingLines, verticalMatchingLines);
    }

    public double getSuggestedDX() {
        return this.suggestedDX;
    }

    public double getSuggestedDY() {
        return this.suggestedDY;
    }

    public Group getGuideGroup() {
        return this.renderer.getGuideGroup();
    }
}

