/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.ResizingGuideRenderer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.SegmentIndex;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Paint;

public class ResizingGuideController {
    private final double MATCH_DISTANCE = 6.0;
    private final double CHROME_SIDE_LENGTH = 4.0;
    private final double DELTA = 6.0;
    private final SegmentIndex widthIndex;
    private final SegmentIndex heightIndex;
    private final ResizingGuideRenderer renderer;
    private double suggestedWidth;
    private double suggestedHeight;

    public ResizingGuideController(boolean matchWidth, boolean matchHeight, Paint guideColor) {
        this.renderer = new ResizingGuideRenderer(guideColor, 4.0);
        this.widthIndex = matchWidth ? new SegmentIndex() : null;
        this.heightIndex = matchHeight ? new SegmentIndex() : null;
    }

    public void addSampleBounds(Node node) {
        assert (node != null);
        assert (node.getScene() != null);
        Bounds layoutBounds = node.getLayoutBounds();
        Bounds boundsInScene = node.localToScene(layoutBounds);
        double minX = boundsInScene.getMinX();
        double minY = boundsInScene.getMinY();
        double maxX = boundsInScene.getMaxX();
        double maxY = boundsInScene.getMaxY();
        if (this.widthIndex != null && minX < maxX) {
            this.widthIndex.addSegment(new HorizontalSegment(minX, maxX, minY - 6.0));
        }
        if (this.heightIndex != null && minY < maxY) {
            this.heightIndex.addSegment(new VerticalSegment(minX - 6.0, minY, maxY));
        }
    }

    public void clear() {
        this.renderer.setSegments(Collections.emptyList());
    }

    public void match(Bounds targetBounds) {
        ArrayList<AbstractSegment> matchingSegments = new ArrayList<AbstractSegment>();
        double targetWidth = targetBounds.getWidth();
        if (this.widthIndex == null) {
            this.suggestedWidth = targetWidth;
        } else {
            List<AbstractSegment> matchingWidthSegments = this.widthIndex.match(targetWidth, 6.0);
            if (matchingWidthSegments.isEmpty()) {
                this.suggestedWidth = targetWidth;
            } else {
                this.suggestedWidth = matchingWidthSegments.get(0).getLength();
                matchingSegments.addAll(matchingWidthSegments);
            }
        }
        double targetHeight = targetBounds.getHeight();
        if (this.heightIndex == null) {
            this.suggestedHeight = targetHeight;
        } else {
            List<AbstractSegment> matchingHeightSegments = this.heightIndex.match(targetHeight, 6.0);
            if (matchingHeightSegments.isEmpty()) {
                this.suggestedHeight = targetHeight;
            } else {
                this.suggestedHeight = matchingHeightSegments.get(0).getLength();
                matchingSegments.addAll(matchingHeightSegments);
            }
        }
        this.renderer.setSegments(matchingSegments);
    }

    public double getSuggestedWidth() {
        return this.suggestedWidth;
    }

    public double getSuggestedHeight() {
        return this.suggestedHeight;
    }

    public Group getGuideGroup() {
        return this.renderer.getGuideGroup();
    }
}

