/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.ResizingGuideChrome;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.paint.Paint;

public class ResizingGuideRenderer {
    private static final String NID_RESIZING_GUIDE = "resizingGuide";
    private final Group guideGroup = new Group();
    private final Map<AbstractSegment, ResizingGuideChrome> chromeMap = new HashMap<AbstractSegment, ResizingGuideChrome>();
    private final Set<ResizingGuideChrome> reusableChromes = new HashSet<ResizingGuideChrome>();
    private final Paint chromeColor;
    private final double chromeSideLength;

    public ResizingGuideRenderer(Paint chromeColor, double chromeSideLength) {
        this.chromeColor = chromeColor;
        this.chromeSideLength = chromeSideLength;
        this.guideGroup.setMouseTransparent(true);
    }

    public void setSegments(List<AbstractSegment> segments) {
        ResizingGuideChrome chrome;
        assert (segments != null);
        assert (this.guideGroup.getScene() != null);
        Set<AbstractSegment> currentSegments = this.chromeMap.keySet();
        HashSet<AbstractSegment> newSegments = new HashSet<AbstractSegment>();
        newSegments.addAll(segments);
        newSegments.removeAll(currentSegments);
        HashSet<AbstractSegment> obsoleteSegments = new HashSet<AbstractSegment>();
        obsoleteSegments.addAll(currentSegments);
        obsoleteSegments.removeAll(segments);
        for (AbstractSegment s : obsoleteSegments) {
            chrome = this.chromeMap.get(s);
            assert (chrome != null);
            this.reusableChromes.add(chrome);
            this.chromeMap.remove(s);
            chrome.setVisible(false);
        }
        for (AbstractSegment s : newSegments) {
            if (this.reusableChromes.isEmpty()) {
                chrome = new ResizingGuideChrome(this.chromeSideLength);
                chrome.setId(NID_RESIZING_GUIDE);
                chrome.setStroke(this.chromeColor);
                this.guideGroup.getChildren().add((Object)chrome);
            } else {
                chrome = this.reusableChromes.iterator().next();
                this.reusableChromes.remove((Object)chrome);
                chrome.setVisible(true);
            }
            Point2D p1 = this.guideGroup.sceneToLocal(s.getX1(), s.getY1());
            Point2D p2 = this.guideGroup.sceneToLocal(s.getX2(), s.getY2());
            chrome.setup(p1.getX(), p1.getY(), p2.getX(), p2.getY());
            this.chromeMap.put(s, chrome);
        }
    }

    public Group getGuideGroup() {
        return this.guideGroup;
    }
}

