/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.RegionRectangle;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.transform.Transform;

public class HitNodeChrome
extends AbstractDecoration<Object> {
    private Node hitNode;
    private final RegionRectangle chrome = new RegionRectangle();
    private Node closestNode;

    public HitNodeChrome(ContentPanelController contentPanelController, FXOMObject fxomObject, Node hitNode) {
        super(contentPanelController, fxomObject, Object.class);
        assert (hitNode != null);
        assert (hitNode.getScene() != null);
        this.hitNode = hitNode;
        this.closestNode = this.findClosestNode();
        assert (this.closestNode != null);
        assert (this.closestNode.getScene() == hitNode.getScene());
        this.chrome.setMouseTransparent(true);
        this.chrome.getRegion().getStyleClass().add((Object)"css-pick-chrome");
        this.getRootNode().getChildren().add((Object)this.chrome);
    }

    public Node getHitNode() {
        return this.hitNode;
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        return this.closestNode.getLayoutBounds();
    }

    @Override
    public Transform getSceneGraphToSceneTransform() {
        return this.closestNode.getLocalToSceneTransform();
    }

    @Override
    public Point2D sceneGraphObjectToScene(double x, double y) {
        return this.closestNode.localToScene(x, y);
    }

    @Override
    public Point2D sceneToSceneGraphObject(double x, double y) {
        return this.closestNode.sceneToLocal(x, y);
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        this.startListeningToLayoutBounds(this.closestNode);
        this.startListeningToLocalToSceneTransform(this.closestNode);
        this.startListeningToBoundsInParent(this.hitNode);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        this.stopListeningToLayoutBounds(this.closestNode);
        this.stopListeningToLocalToSceneTransform(this.closestNode);
        this.stopListeningToBoundsInParent(this.hitNode);
    }

    @Override
    protected void layoutDecoration() {
        assert (this.chrome.getScene() != null);
        if (this.getState() != AbstractDecoration.State.CLEAN) {
            this.chrome.setVisible(false);
        } else {
            assert (this.hitNode.getScene() != null);
            assert (this.hitNode.getScene() == this.closestNode.getScene());
            Transform t = this.getContentPanelController().computeSceneGraphToRudderLayerTransform(this.hitNode);
            this.chrome.getTransforms().clear();
            this.chrome.getTransforms().add((Object)t);
            this.chrome.setLayoutBounds(this.hitNode.getLayoutBounds());
            this.chrome.setVisible(true);
        }
    }

    @Override
    public AbstractDecoration.State getState() {
        Node newClosestNode;
        AbstractDecoration.State result = super.getState();
        if (result == AbstractDecoration.State.CLEAN && this.closestNode != (newClosestNode = this.findClosestNode())) {
            result = AbstractDecoration.State.NEEDS_RECONCILE;
        }
        return result;
    }

    @Override
    public void reconcile() {
        super.reconcile();
        this.hitNode = this.closestNode = this.findClosestNode();
    }

    private Node findClosestNode() {
        FXOMObject nodeObject = this.getFxomObject().getClosestNode();
        assert (nodeObject != null);
        assert (nodeObject.getSceneGraphObject() instanceof Node);
        return (Node)nodeObject.getSceneGraphObject();
    }
}

