/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode.AbstractModeController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode.HitNodeChrome;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;

public class PickModeController
extends AbstractModeController {
    private HitNodeChrome hitNodeChrome;
    private final EventHandler<MouseEvent> mousePressedOnGlassLayerListener = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent e) {
            PickModeController.this.mousePressedOnGlassLayer(e);
        }
    };

    public PickModeController(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public void willResignActive(AbstractModeController nextModeController) {
        this.contentPanelController.getGlassLayer().setCursor(Cursor.DEFAULT);
        this.stopListeningToInputEvents();
        this.removeHitNodeChrome();
    }

    @Override
    public void didBecomeActive(AbstractModeController previousModeController) {
        assert (this.contentPanelController.getGlassLayer() != null);
        this.updateHitNodeChrome();
        this.startListeningToInputEvents();
        this.contentPanelController.getGlassLayer().setCursor(ImageUtils.getCSSCursor());
    }

    @Override
    public void editorSelectionDidChange() {
        this.updateHitNodeChrome();
    }

    @Override
    public void fxomDocumentDidChange(FXOMDocument oldDocument) {
        this.fxomDocumentDidRefreshSceneGraph();
    }

    @Override
    public void fxomDocumentDidRefreshSceneGraph() {
        this.updateHitNodeChrome();
    }

    @Override
    public void dropTargetDidChange() {
        assert (false);
    }

    private void startListeningToInputEvents() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnMousePressed() == null);
        glassLayer.setOnMousePressed(this.mousePressedOnGlassLayerListener);
    }

    private void stopListeningToInputEvents() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnMousePressed(null);
    }

    private void mousePressedOnGlassLayer(MouseEvent e) {
        Node hitNode;
        FXOMObject hitObject;
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.contentPanelController.getEditorController().getFxomDocument();
        if (fxomDocument == null || fxomDocument.getFxomRoot() == null) {
            hitObject = null;
            hitNode = null;
        } else {
            FXOMObject fxomRoot = fxomDocument.getFxomRoot();
            Object sceneGraphRoot = fxomRoot.getSceneGraphObject();
            if (sceneGraphRoot instanceof Node) {
                hitNode = Deprecation.pick((Node)sceneGraphRoot, e.getSceneX(), e.getSceneY());
                FXOMObject fxomObject = null;
                for (Node node = hitNode; fxomObject == null && node != null; node = node.getParent()) {
                    fxomObject = fxomRoot.searchWithSceneGraphObject(node);
                }
                hitObject = fxomObject;
            } else {
                hitObject = null;
                hitNode = null;
            }
        }
        if (hitObject == null) {
            selection.clear();
        } else if (selection.isSelected(hitObject)) {
            assert (selection.getGroup() instanceof ObjectSelectionGroup);
            selection.updateHitObject(hitObject, hitNode);
        } else {
            selection.select(hitObject, hitNode);
        }
    }

    private void updateHitNodeChrome() {
        HitNodeChrome newChrome;
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        if (this.hitNodeChrome == null || this.hitNodeChrome.getFxomObject() != selection.getHitItem() || this.hitNodeChrome.getHitNode() != selection.getCheckedHitNode()) {
            newChrome = selection.getHitItem() != null && selection.getCheckedHitNode() != null ? this.makeHitNodeChrome(selection.getHitItem(), selection.getCheckedHitNode()) : null;
        } else {
            switch (this.hitNodeChrome.getState()) {
                default: {
                    newChrome = this.hitNodeChrome;
                    break;
                }
                case NEEDS_RECONCILE: {
                    newChrome = this.hitNodeChrome;
                    this.hitNodeChrome.reconcile();
                    break;
                }
                case NEEDS_REPLACE: {
                    newChrome = this.makeHitNodeChrome(selection.getHitItem(), selection.getCheckedHitNode());
                    assert (newChrome.getState() == AbstractDecoration.State.CLEAN);
                    break;
                }
            }
        }
        if (newChrome != this.hitNodeChrome) {
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            if (this.hitNodeChrome != null) {
                rudderLayer.getChildren().remove((Object)this.hitNodeChrome.getRootNode());
            }
            this.hitNodeChrome = newChrome;
            if (this.hitNodeChrome != null) {
                rudderLayer.getChildren().add((Object)this.hitNodeChrome.getRootNode());
            }
        } else assert (this.hitNodeChrome == null || this.hitNodeChrome.getState() == AbstractDecoration.State.CLEAN);
    }

    private HitNodeChrome makeHitNodeChrome(FXOMObject hitItem, Node hitNode) {
        HitNodeChrome result;
        assert (hitItem != null);
        AbstractDriver driver = this.contentPanelController.lookupDriver(hitItem);
        if (driver == null) {
            result = null;
        } else {
            FXOMObject closestNodeObject = hitItem.getClosestNode();
            if (closestNodeObject == null) {
                result = null;
            } else {
                assert (closestNodeObject.getSceneGraphObject() instanceof Node);
                Node closestNode = (Node)closestNodeObject.getSceneGraphObject();
                result = closestNode.getScene() == this.contentPanelController.getPanelRoot().getScene() ? new HitNodeChrome(this.contentPanelController, hitItem, hitNode) : null;
            }
        }
        return result;
    }

    private void removeHitNodeChrome() {
        if (this.hitNodeChrome != null) {
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            rudderLayer.getChildren().remove((Object)this.hitNodeChrome.getRootNode());
            this.hitNodeChrome = null;
        }
    }
}

