/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.LineEquation;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class BoundsUtils {
    public static Bounds makeBounds(Point2D p1, Point2D p2) {
        return new BoundingBox(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY()));
    }

    public static boolean equals(Bounds b1, Bounds b2) {
        return MathUtils.equals(b1.getMinX(), b2.getMinX()) && MathUtils.equals(b1.getMinY(), b2.getMinY()) && MathUtils.equals(b1.getMaxX(), b2.getMaxX()) && MathUtils.equals(b1.getMaxY(), b2.getMaxY());
    }

    public static Bounds inset(Bounds bounds, double dx, double dy) {
        double minX = bounds.getMinX() + dx;
        double minY = bounds.getMinY() + dy;
        double maxX = bounds.getMaxX() - dx;
        double maxY = bounds.getMaxY() - dy;
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    public static EdgeInfo distanceToEdges(Bounds b, double x, double y, Node node) {
        assert (b != null);
        assert (node != null);
        assert (node.getScene() != null);
        if (!b.isEmpty()) {
            double minX = b.getMinX();
            double minY = b.getMinY();
            double maxX = b.getMaxX();
            double maxY = b.getMaxY();
            Point2D p1 = node.localToScene(minX, minY);
            Point2D p2 = node.localToScene(maxX, minY);
            Point2D p3 = node.localToScene(maxX, maxY);
            Point2D p4 = node.localToScene(minX, maxY);
            LineEquation nl = new LineEquation(p1, p2);
            LineEquation el = new LineEquation(p2, p3);
            LineEquation sl = new LineEquation(p3, p4);
            LineEquation wl = new LineEquation(p4, p1);
            Point2D p = node.localToScene(x, y);
            double sceneX = p.getX();
            double sceneY = p.getY();
            Point2D nh = nl.pointAtOffset(nl.offsetAtPoint(sceneX, sceneY));
            Point2D eh = el.pointAtOffset(el.offsetAtPoint(sceneX, sceneY));
            Point2D sh = sl.pointAtOffset(sl.offsetAtPoint(sceneX, sceneY));
            Point2D wh = wl.pointAtOffset(wl.offsetAtPoint(sceneX, sceneY));
            double nd = BoundsUtils.distance(nh, p);
            double ed = BoundsUtils.distance(eh, p);
            double sd = BoundsUtils.distance(sh, p);
            double wd = BoundsUtils.distance(wh, p);
            return new EdgeInfo(nd, ed, sd, wd);
        }
        EdgeInfo result = null;
        return result;
    }

    private static double distance(Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static class EdgeInfo {
        private final double northDistance;
        private final double eastDistance;
        private final double southDistance;
        private final double westDistance;

        public EdgeInfo(double northDistance, double eastDistance, double southDistance, double westDistance) {
            this.northDistance = northDistance;
            this.eastDistance = eastDistance;
            this.southDistance = southDistance;
            this.westDistance = westDistance;
        }

        public double getNorthDistance() {
            return this.northDistance;
        }

        public double getEastDistance() {
            return this.eastDistance;
        }

        public double getSouthDistance() {
            return this.southDistance;
        }

        public double getWestDistance() {
            return this.westDistance;
        }

        public String toString() {
            return "EdgeInfo{northDistance=" + this.northDistance + ", eastDistance=" + this.eastDistance + ", southDistance=" + this.southDistance + ", westDistance=" + this.westDistance + '}';
        }
    }
}

