/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;

public class Picker {
    private final Set<Node> excludes = new HashSet<Node>();
    private final List<Node> matches = new ArrayList<Node>();

    public List<Node> pick(Node startNode, double sceneX, double sceneY) {
        assert (startNode != null);
        assert (startNode.getScene() != null);
        assert (!Double.isNaN(sceneX));
        assert (!Double.isNaN(sceneY));
        Point2D localXY = startNode.sceneToLocal(sceneX, sceneY);
        return this.pickInLocal(startNode, localXY.getX(), localXY.getY());
    }

    public List<Node> pickInLocal(Node startNode, double localX, double localY) {
        assert (startNode != null);
        assert (startNode.getScene() != null);
        assert (!Double.isNaN(localX));
        assert (!Double.isNaN(localY));
        this.matches.clear();
        this.performPick(startNode, localX, localY);
        return this.matches.isEmpty() ? null : Collections.unmodifiableList(this.matches);
    }

    public Set<Node> getExcludes() {
        return this.excludes;
    }

    private void performPick(Node startNode, double localX, double localY) {
        if (!this.excludes.contains(startNode) && startNode.isVisible()) {
            if (startNode.getLayoutBounds().contains(localX, localY)) {
                this.matches.add(0, startNode);
            }
            if (startNode instanceof Parent) {
                Parent startParent = (Parent)startNode;
                for (Node child : startParent.getChildrenUnmodifiable()) {
                    Point2D childLocalXY = child.parentToLocal(localX, localY);
                    if (childLocalXY == null) continue;
                    this.performPick(child, childLocalXY.getX(), childLocalXY.getY());
                }
            }
        }
    }
}

