/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.Set;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;

public class CssUtils {
    private CssUtils() {
        assert (false);
    }

    static String getBeanPropertyName(Node node, CssMetaData<?, ?> sp) {
        String property = null;
        try {
            CssMetaData<?, ?> raw = sp;
            StyleableProperty val = raw.getStyleableProperty((Styleable)node);
            property = CssInternal.getBeanPropertyName(val);
        }
        catch (RuntimeException ex) {
            System.out.println("Can't retrieve property " + ex);
        }
        return property;
    }

    public static Node getFirstAncestorWithNonNullScene(Node node) {
        Node ancestor;
        for (ancestor = node; ancestor != null && ancestor.getScene() == null; ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public static Node getNode(Object target) {
        Node node;
        block4: {
            block5: {
                if (target instanceof Node) {
                    return (Node)target;
                }
                Styleable styleable = target instanceof Styleable ? (Styleable)target : null;
                node = null;
                if (styleable == null || (node = Deprecation.getNode(styleable)) != null) break block4;
                if (!(target instanceof MenuItem)) break block5;
                MenuItem mi = (MenuItem)target;
                ContextMenu pc = mi.getParentPopup();
                if (pc == null) break block4;
                node = Deprecation.getNode((Styleable)pc);
                break block4;
            }
            if (target instanceof Tab) {
                Tab tab = (Tab)target;
                TabPane tp = tab.getTabPane();
                Set tabs = tp.lookupAll(".tab");
                for (Node n : tabs) {
                    Tab result = (Tab)n.getProperties().get(Tab.class);
                    assert (result != null);
                    if (result != tab) continue;
                    node = n;
                    break;
                }
            }
        }
        return node;
    }

    static void addToParent(Parent p, Node node) {
        if (p instanceof Group) {
            ((Group)p).getChildren().add((Object)node);
        } else if (p instanceof Pane) {
            ((Pane)p).getChildren().add((Object)node);
        }
    }

    static void removeFromParent(Parent p, Node node) {
        if (p instanceof Group) {
            ((Group)p).getChildren().remove((Object)node);
        } else if (p instanceof Pane) {
            ((Pane)p).getChildren().remove((Object)node);
        }
    }

    public static Object getSceneGraphObject(Object selectedObject) {
        if (selectedObject instanceof FXOMObject) {
            return ((FXOMObject)selectedObject).getSceneGraphObject();
        }
        return selectedObject;
    }

    public static Node getSelectedNode(Object selectedObject) {
        return CssUtils.getNode(CssUtils.getSceneGraphObject(selectedObject));
    }
}

