/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssContentMaker;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssValueConverter;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Skinnable;

public class NodeCssState {
    private static final List<StyleOrigin> ORDERED_ORIGIN = new ArrayList<StyleOrigin>();
    private final Map<StyleableProperty, List<Style>> map;
    private final Node node;
    private final FXOMObject fxomObject;
    private Collection<CssContentMaker.CssPropertyState> author;
    private Collection<CssContentMaker.CssPropertyState> inline;
    private Collection<CssContentMaker.CssPropertyState> userAgent;
    private Map<MatchingRule, List<MatchingDeclaration>> matchingRules;
    private List<MatchingRule> sortedMatchingRules = new ArrayList<MatchingRule>();
    private Collection<CssProperty> props;

    protected NodeCssState(Map<StyleableProperty, List<Style>> map, Node node, FXOMObject fxomObject) {
        this.map = map;
        this.node = node;
        this.fxomObject = fxomObject;
        this.getAuthorStyles();
        this.getInlineStyles();
        this.getUserAgentStyles();
        this.getMatchingRules();
        this.getAllStyleables();
    }

    private CssContentMaker.CssPropertyState retrieveCssStyle(CssMetaData<?, ?> cssMeta, Collection<CssContentMaker.CssPropertyState> styles) {
        for (CssContentMaker.CssPropertyState prop : styles) {
            if (prop.getCssProperty().equals(cssMeta.getProperty())) {
                return prop;
            }
            if (prop.getSubProperties() == null) continue;
            for (CssContentMaker.PropertyState sub : prop.getSubProperties()) {
                if (!sub.getCssProperty().equals(cssMeta.getProperty())) continue;
                return (CssContentMaker.CssPropertyState)sub;
            }
        }
        return null;
    }

    public Node getNode() {
        return this.node;
    }

    public final Collection<CssProperty> getAllStyleables() {
        if (this.props == null) {
            this.props = new TreeSet<CssProperty>();
            List cssMetaList = this.node.getCssMetaData();
            for (CssMetaData cssMeta : cssMetaList) {
                CssProperty mainProp = new CssProperty(this, cssMeta, this.node, this.fxomObject);
                this.props.add(mainProp);
                if (cssMeta.getSubProperties() == null) continue;
                for (CssMetaData sub : cssMeta.getSubProperties()) {
                    CssProperty subProp = new CssProperty(this, mainProp, sub, this.node, this.fxomObject);
                    mainProp.getSubProperties().add(subProp);
                }
            }
            if (this.node instanceof Skinnable) {
                Skinnable skinnable = (Skinnable)this.node;
                Node skinNode = skinnable.getSkin().getNode();
                List skinList = skinNode.getCssMetaData();
                for (CssMetaData skinCssMeta : skinList) {
                    boolean found = false;
                    for (CssMetaData cssMeta : cssMetaList) {
                        if (!skinCssMeta.getProperty().equals(cssMeta.getProperty())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    CssProperty mainProp = new CssProperty(this, skinCssMeta, skinNode, this.fxomObject);
                    this.props.add(mainProp);
                    if (skinCssMeta.getSubProperties() == null) continue;
                    for (CssMetaData sub : skinCssMeta.getSubProperties()) {
                        CssProperty subProp = new CssProperty(this, sub, this.node, this.fxomObject);
                        mainProp.getSubProperties().add(subProp);
                    }
                }
            }
        }
        return this.props;
    }

    public final Collection<CssContentMaker.CssPropertyState> getAuthorStyles() {
        if (this.author == null) {
            this.author = this.getAppliedStyles(StyleOrigin.AUTHOR);
        }
        return this.author;
    }

    public final Collection<CssContentMaker.CssPropertyState> getInlineStyles() {
        if (this.inline == null) {
            this.inline = this.getAppliedStyles(StyleOrigin.INLINE);
        }
        return this.inline;
    }

    public final Collection<CssContentMaker.CssPropertyState> getUserAgentStyles() {
        if (this.userAgent == null) {
            this.userAgent = this.getAppliedStyles(StyleOrigin.USER_AGENT);
        }
        return this.userAgent;
    }

    private static int compareOrigin(StyleOrigin toCompare, StyleOrigin other) {
        int index1 = ORDERED_ORIGIN.indexOf(toCompare);
        int index2 = ORDERED_ORIGIN.indexOf(other);
        return index2 - index1;
    }

    private static int countNotApplied(List<MatchingDeclaration> declarations) {
        int count = 0;
        for (MatchingDeclaration decl : declarations) {
            if (decl.isApplied()) continue;
            ++count;
        }
        return count;
    }

    private static void addSubProperties(Collection<CssContentMaker.CssPropertyState> source, Collection<CssContentMaker.CssPropertyState> target) {
        for (CssContentMaker.CssPropertyState p : source) {
            if (p.getSubProperties().isEmpty()) {
                target.add(p);
                continue;
            }
            for (CssContentMaker.PropertyState sub : p.getSubProperties()) {
                target.add((CssContentMaker.CssPropertyState)sub);
            }
        }
    }

    public final List<MatchingRule> getMatchingRules() {
        if (this.matchingRules == null) {
            TreeSet<CssContentMaker.CssPropertyState> styledProperties = new TreeSet<CssContentMaker.CssPropertyState>();
            NodeCssState.addSubProperties(this.getUserAgentStyles(), styledProperties);
            NodeCssState.addSubProperties(this.getAuthorStyles(), styledProperties);
            NodeCssState.addSubProperties(this.getInlineStyles(), styledProperties);
            this.matchingRules = new HashMap<MatchingRule, List<MatchingDeclaration>>();
            for (CssContentMaker.CssPropertyState cssPropertyState : styledProperties) {
                List<CssContentMaker.PropertyState> l = cssPropertyState.getSubProperties();
                if (l.isEmpty()) {
                    this.addMatchingDeclaration(cssPropertyState);
                    continue;
                }
                for (CssContentMaker.PropertyState pp : l) {
                    CssContentMaker.CssPropertyState cssSubP = (CssContentMaker.CssPropertyState)pp;
                    this.addMatchingDeclaration(cssSubP);
                }
            }
            for (Map.Entry entry : this.matchingRules.entrySet()) {
                MatchingRule rule = (MatchingRule)entry.getKey();
                if (CssInternal.getOrigin(rule.getRule()) == StyleOrigin.INLINE) continue;
                rule.addDeclarations((List)entry.getValue());
                this.sortedMatchingRules.add(rule);
            }
            Collections.sort(this.sortedMatchingRules, new RuleComparator());
        }
        return this.sortedMatchingRules;
    }

    private void addMatchingDeclaration(CssContentMaker.CssPropertyState cssP) {
        this.addMatchingDeclaration(cssP, cssP.getStyle(), true, false);
        for (CssContentMaker.CssPropertyState.CssStyle s : cssP.getNotAppliedStyles()) {
            this.addMatchingDeclaration(cssP, s, false, false);
        }
    }

    private void addMatchingDeclaration(CssContentMaker.CssPropertyState cssP, CssContentMaker.CssPropertyState.CssStyle style, boolean applied, boolean isLookup) {
        MatchingRule mr = new MatchingRule(style.getCssRule(), style.getSelector());
        List<MatchingDeclaration> lst = this.matchingRules.get(mr);
        if (lst == null) {
            lst = new ArrayList<MatchingDeclaration>();
            this.matchingRules.put(mr, lst);
        }
        MatchingDeclaration pmr = new MatchingDeclaration(style, cssP, applied, isLookup);
        boolean found = false;
        for (MatchingDeclaration d : lst) {
            if (!d.style.getCssProperty().equals(style.getCssProperty())) continue;
            found = true;
            break;
        }
        if (!found) {
            lst.add(pmr);
        }
        for (CssContentMaker.CssPropertyState.CssStyle lookup : style.getLookupChain()) {
            this.addMatchingDeclaration(cssP, lookup, applied, true);
        }
    }

    private Set<CssContentMaker.CssPropertyState> getAppliedStyles(StyleOrigin origin) {
        TreeSet<CssContentMaker.CssPropertyState> propertyStates = new TreeSet<CssContentMaker.CssPropertyState>();
        for (Map.Entry<StyleableProperty, List<Style>> entry : this.map.entrySet()) {
            CssContentMaker.CssPropertyState.CssStyle style;
            StyleableProperty value = entry.getKey();
            assert (entry.getValue() != null);
            assert (!entry.getValue().isEmpty());
            Style st = entry.getValue().get(0);
            StyleOrigin o = CssInternal.getOrigin(st);
            CssMetaData cssMetaList = value.getCssMetaData();
            if (o != origin && cssMetaList.getSubProperties() == null) continue;
            String cssValue = CssValueConverter.toCssString(cssMetaList.getProperty(), st.getDeclaration().getRule(), value.getValue());
            CssContentMaker.CssPropertyState pState = new CssContentMaker.CssPropertyState(value, cssMetaList, cssValue);
            if (cssMetaList.getSubProperties() != null) {
                for (CssMetaData sub : cssMetaList.getSubProperties()) {
                    List<CssContentMaker.CssPropertyState.CssStyle> notApplied = CssContentMaker.getNotAppliedStyles(entry.getValue(), this.node, sub);
                    for (Style style2 : entry.getValue()) {
                        StyleOrigin styleOrigin = CssInternal.getOrigin(style2);
                        if (!style2.getDeclaration().getProperty().equals(sub.getProperty()) || styleOrigin != origin) continue;
                        CssContentMaker.CssPropertyState.CssStyle cssStyle = CssContentMaker.retrieveStyle(entry.getValue(), style2);
                        String subCssValue = CssValueConverter.toCssString(sub.getProperty(), style2.getDeclaration().getRule(), value.getValue());
                        CssContentMaker.CssSubPropertyState subCss = new CssContentMaker.CssSubPropertyState(value, sub, subCssValue);
                        subCss.setStyle(cssStyle);
                        subCss.getNotAppliedStyles().addAll(notApplied);
                        pState.getSubProperties().add(subCss);
                    }
                }
                style = CssContentMaker.retrieveStyle(entry.getValue(), st);
                pState.setStyle(style);
                if (!st.getDeclaration().getProperty().equals(cssMetaList.getProperty())) {
                    style.setUnused();
                }
            } else {
                style = CssContentMaker.retrieveStyle(entry.getValue(), st);
                pState.setStyle(style);
            }
            ArrayList<Style> applied = new ArrayList<Style>();
            applied.add(st);
            pState.getNotAppliedStyles().addAll(CssContentMaker.getNotAppliedStyles(applied, this.node, cssMetaList));
            if (o != origin && pState.getSubProperties().isEmpty()) continue;
            propertyStates.add(pState);
        }
        return propertyStates;
    }

    static {
        ORDERED_ORIGIN.add(StyleOrigin.USER_AGENT);
        ORDERED_ORIGIN.add(StyleOrigin.USER);
        ORDERED_ORIGIN.add(StyleOrigin.AUTHOR);
        ORDERED_ORIGIN.add(StyleOrigin.INLINE);
    }

    public static class MatchingDeclaration {
        private final CssContentMaker.CssPropertyState.CssStyle style;
        private final CssContentMaker.CssPropertyState prop;
        private final boolean applied;
        private final boolean lookup;

        MatchingDeclaration(CssContentMaker.CssPropertyState.CssStyle style, CssContentMaker.CssPropertyState prop, boolean applied, boolean lookup) {
            this.style = style;
            this.prop = prop;
            this.applied = applied;
            this.lookup = lookup;
        }

        public CssContentMaker.CssPropertyState.CssStyle getStyle() {
            return this.style;
        }

        public CssContentMaker.CssPropertyState getProp() {
            return this.prop;
        }

        public boolean isApplied() {
            return this.applied;
        }

        public boolean isLookup() {
            return this.lookup;
        }
    }

    public static class MatchingRule {
        private final Rule rule;
        private final String selector;
        private final List<MatchingDeclaration> declarations = new ArrayList<MatchingDeclaration>();

        private MatchingRule(Rule rule, String selector) {
            this.rule = rule;
            this.selector = selector;
        }

        public Rule getRule() {
            return this.rule;
        }

        public String getSelector() {
            return this.selector;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.rule != null ? this.rule.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MatchingRule)) {
                return false;
            }
            MatchingRule mr = (MatchingRule)obj;
            return this.rule.equals(mr.rule);
        }

        private void addDeclarations(List<MatchingDeclaration> values) {
            this.declarations.addAll(values);
        }

        public List<MatchingDeclaration> getDeclarations() {
            return Collections.unmodifiableList(this.declarations);
        }

        public String toString() {
            return this.rule.getSelectors().toString();
        }
    }

    public static class RuleComparator
    implements Comparator<MatchingRule> {
        @Override
        public int compare(MatchingRule t, MatchingRule t1) {
            int originComparaison = NodeCssState.compareOrigin(CssInternal.getOrigin(t.getRule()), CssInternal.getOrigin(t1.rule));
            int tnotApplied = NodeCssState.countNotApplied(t.declarations);
            int t1notApplied = NodeCssState.countNotApplied(t1.declarations);
            int notAppliedComparaisons = tnotApplied - t1notApplied;
            if (originComparaison == 0) {
                return notAppliedComparaisons;
            }
            return originComparaison;
        }
    }

    public static class CssProperty
    implements Comparable<CssProperty> {
        private final CssMetaData cssMeta;
        private final CssProperty mainProperty;
        private final Node target;
        private final List<CssProperty> sub = new ArrayList<CssProperty>();
        private final ObjectProperty<String> name = new SimpleObjectProperty();
        private final ObjectProperty<CssContentMaker.PropertyState> builtin = new SimpleObjectProperty();
        private final ObjectProperty<CssContentMaker.CssPropertyState> fxTheme = new SimpleObjectProperty();
        private final ObjectProperty<CssContentMaker.CssPropertyState> authorCss = new SimpleObjectProperty();
        private final ObjectProperty<CssContentMaker.CssPropertyState> inlineCss = new SimpleObjectProperty();
        private final ObjectProperty<CssContentMaker.PropertyState> fxmlModel = new SimpleObjectProperty();
        private CssContentMaker.PropertyState currentState;

        CssProperty(NodeCssState nodeCssState, CssMetaData cssMeta, Node target, FXOMObject fxomObject) {
            this(nodeCssState, null, cssMeta, target, fxomObject);
        }

        CssProperty(NodeCssState nodeCssState, CssProperty mainProperty, CssMetaData cssMeta, Node target, FXOMObject fxomObject) {
            CssContentMaker.CssPropertyState fxThemeState;
            CssContentMaker.CssPropertyState authorState;
            this.mainProperty = mainProperty;
            this.cssMeta = cssMeta;
            this.target = target;
            this.name.setValue((Object)cssMeta.getProperty());
            CssContentMaker.CssPropertyState inlineState = nodeCssState.retrieveCssStyle(cssMeta, nodeCssState.getInlineStyles());
            if (inlineState != null) {
                this.inlineCss.setValue((Object)inlineState);
            }
            if ((authorState = nodeCssState.retrieveCssStyle(cssMeta, nodeCssState.getAuthorStyles())) != null) {
                this.authorCss.setValue((Object)authorState);
            }
            if ((fxThemeState = nodeCssState.retrieveCssStyle(cssMeta, nodeCssState.getUserAgentStyles())) != null) {
                this.fxTheme.setValue((Object)fxThemeState);
            }
            CssContentMaker.PropertyState builtinState = CssContentMaker.initialValue(target, mainProperty == null ? this : mainProperty, cssMeta);
            assert (builtinState != null);
            this.builtin.setValue((Object)builtinState);
            CssContentMaker.PropertyState modelState = CssContentMaker.modelValue(target, cssMeta, fxomObject);
            if (modelState != null) {
                this.fxmlModel.setValue((Object)modelState);
            }
        }

        public ObjectProperty<CssContentMaker.PropertyState> builtinState() {
            return this.builtin;
        }

        public ObjectProperty<CssContentMaker.PropertyState> modelState() {
            return this.fxmlModel;
        }

        public ObjectProperty<CssContentMaker.CssPropertyState> fxThemeState() {
            return this.fxTheme;
        }

        public ObjectProperty<CssContentMaker.CssPropertyState> authorState() {
            return this.authorCss;
        }

        public ObjectProperty<CssContentMaker.CssPropertyState> inlineState() {
            return this.inlineCss;
        }

        public ObjectProperty<String> propertyName() {
            return this.name;
        }

        public CssMetaData getStyleable() {
            return this.cssMeta;
        }

        public Node getTarget() {
            return this.target;
        }

        public List<CssProperty> getSubProperties() {
            return this.sub;
        }

        public CssProperty getMainProperty() {
            return this.mainProperty;
        }

        @Override
        public int compareTo(CssProperty cssProperty) {
            return this.cssMeta.getProperty().compareTo(cssProperty.cssMeta.getProperty());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CssProperty cssProperty = (CssProperty)obj;
            return this.cssMeta.getProperty().compareTo(cssProperty.cssMeta.getProperty()) == 0;
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + Objects.hashCode(this.cssMeta);
            hash = 31 * hash + Objects.hashCode(this.mainProperty);
            hash = 31 * hash + Objects.hashCode(this.target);
            return hash;
        }

        public boolean isBuiltinSource() {
            return this.inlineState().get() == null && this.authorState().get() == null && this.modelState().get() == null && this.fxThemeState().get() == null;
        }

        public boolean isFxThemeSource() {
            return this.fxThemeState().get() != null && this.inlineState().get() == null && this.authorState().get() == null && this.modelState().get() == null;
        }

        public boolean isModelSource() {
            return this.modelState().get() != null && this.inlineState().get() == null && this.authorState().get() == null;
        }

        public boolean isAuthorSource() {
            return this.authorState().get() != null && this.inlineState().get() == null;
        }

        public boolean isInlineSource() {
            return this.inlineState().get() != null;
        }

        public CssContentMaker.CssPropertyState getWinner() {
            if (this.inlineState().get() != null) {
                return (CssContentMaker.CssPropertyState)this.inlineState().get();
            }
            if (this.authorState().get() != null) {
                return (CssContentMaker.CssPropertyState)this.authorState().get();
            }
            return (CssContentMaker.CssPropertyState)this.fxThemeState().get();
        }

        public CssContentMaker.PropertyState getCurrentStyle() {
            if (this.currentState == null) {
                this.currentState = (CssContentMaker.PropertyState)this.builtinState().get();
                CssContentMaker.PropertyState model = (CssContentMaker.PropertyState)this.modelState().get();
                CssContentMaker.CssPropertyState cssState = this.getWinner();
                if (cssState == null) {
                    if (model != null) {
                        this.currentState = model;
                    }
                } else {
                    this.currentState = model != null && cssState.getStyle() != null && cssState.getStyle().getOrigin() == StyleOrigin.USER_AGENT ? model : cssState;
                }
            }
            return this.currentState;
        }

        public StyleOrigin getCurrentStyleOrigin() {
            CssContentMaker.PropertyState state = this.getCurrentStyle();
            if (state instanceof CssContentMaker.CssPropertyState) {
                CssContentMaker.CssPropertyState cssState = (CssContentMaker.CssPropertyState)state;
                return cssState.getStyle().getOrigin();
            }
            if (state instanceof CssContentMaker.BeanPropertyState) {
                return StyleOrigin.USER;
            }
            return null;
        }

        public boolean isInlineInherited() {
            boolean ret = false;
            CssContentMaker.CssPropertyState css = (CssContentMaker.CssPropertyState)this.inlineCss.get();
            if (css != null) {
                ret = CssContentMaker.isInlineInherited(this.target, css);
            }
            return ret;
        }

        public Node getSourceNodeForInline() {
            Node ret = null;
            CssContentMaker.CssPropertyState css = (CssContentMaker.CssPropertyState)this.inlineCss.get();
            if (css != null) {
                ret = CssContentMaker.getSourceNodeForStyle(this.target, (String)this.propertyName().get());
            }
            return ret;
        }

        public List<CssContentMaker.CssPropertyState.CssStyle> getFxThemeHiddenByModel() {
            boolean hasModel;
            ArrayList<CssContentMaker.CssPropertyState.CssStyle> ret = new ArrayList<CssContentMaker.CssPropertyState.CssStyle>();
            CssContentMaker.CssPropertyState ps = this.getWinner();
            List<Object> notAppliedStyles = ps == null ? Collections.emptyList() : ps.getNotAppliedStyles();
            boolean bl = hasModel = this.modelState().get() != null;
            if (hasModel) {
                List<Style> allStyles = Deprecation.getMatchingStyles(this.getStyleable(), (Styleable)this.target);
                List<Style> matchingStyles = CssContentMaker.removeUserAgentStyles(allStyles);
                for (Style style : matchingStyles) {
                    CssContentMaker.CssPropertyState.CssStyle cssStyle = new CssContentMaker.CssPropertyState.CssStyle(style);
                    if (cssStyle.getOrigin() != StyleOrigin.USER_AGENT || notAppliedStyles.contains(cssStyle) || !this.getStyleable().getProperty().equals(cssStyle.getCssProperty())) continue;
                    cssStyle = CssContentMaker.retrieveStyle(matchingStyles, style);
                    ret.add(cssStyle);
                }
            }
            return ret;
        }
    }
}

