/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AccessoryDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerZDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.GridPaneDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.RootDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItemBorderPane;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItemGraphic;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyTaskScheduler;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.scene.control.TreeItem;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.GridPane;

public class HierarchyDNDController {
    private final AbstractHierarchyPanelController panelController;
    private final HierarchyTaskScheduler scheduler;

    public HierarchyDNDController(AbstractHierarchyPanelController panelController) {
        this.panelController = panelController;
        this.scheduler = new HierarchyTaskScheduler(panelController);
    }

    public HierarchyTaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void handleOnDragDropped(TreeItem<HierarchyItem> treeItem, DragEvent event, DroppingMouseLocation location) {
        this.scheduler.cancelTimer();
    }

    public void handleOnDragEntered(TreeItem<HierarchyItem> treeItem, DragEvent event) {
        this.scheduler.cancelTimer();
        if (treeItem == null) {
            return;
        }
        if (this.panelController.isTimelineRunning()) {
            return;
        }
        if (!treeItem.isExpanded() && !treeItem.isLeaf()) {
            this.scheduler.scheduleExpandTask(treeItem);
        }
    }

    public void handleOnDragExited(TreeItem<HierarchyItem> treeItem, DragEvent event, DroppingMouseLocation location) {
        this.scheduler.cancelTimer();
        if (treeItem != null) {
            HierarchyItem item = (HierarchyItem)treeItem.getValue();
            assert (item != null);
            if (item instanceof HierarchyItemGraphic && item.isEmpty() && location == DroppingMouseLocation.BOTTOM) {
                TreeItem parentTreeItem = treeItem.getParent();
                parentTreeItem.getChildren().remove(treeItem);
            }
        }
    }

    public void handleOnDragOver(TreeItem<HierarchyItem> treeItem, DragEvent event, DroppingMouseLocation location) {
        if (treeItem != null) {
            HierarchyItem item = (HierarchyItem)treeItem.getValue();
            assert (item != null);
            TreeItem<HierarchyItem> graphicTreeItem = this.getEmptyGraphicTreeItemFor(treeItem);
            if (graphicTreeItem != null && location == DroppingMouseLocation.TOP) {
                treeItem.getChildren().remove(graphicTreeItem);
            }
        }
        DragController dragController = this.panelController.getEditorController().getDragController();
        AbstractDropTarget dropTarget = this.makeDropTarget(treeItem, location);
        dragController.setDropTarget(dropTarget);
        event.acceptTransferModes(dragController.getAcceptedTransferModes());
        if (dragController.isDropAccepted() && dropTarget instanceof AccessoryDropTarget && ((AccessoryDropTarget)dropTarget).getAccessory() == DesignHierarchyMask.Accessory.GRAPHIC) {
            assert (treeItem != null);
            if (!((HierarchyItem)treeItem.getValue()).isEmpty() && this.getEmptyGraphicTreeItemFor(treeItem) == null && !this.scheduler.isAddEmptyGraphicTaskScheduled()) {
                this.scheduler.scheduleAddEmptyGraphicTask(treeItem);
            }
        }
    }

    public TreeItem<HierarchyItem> getEmptyGraphicTreeItemFor(TreeItem<HierarchyItem> treeItem) {
        assert (treeItem != null);
        for (TreeItem childTreeItem : treeItem.getChildren()) {
            HierarchyItem child = (HierarchyItem)childTreeItem.getValue();
            if (!(child instanceof HierarchyItemGraphic) || !child.isEmpty()) continue;
            return childTreeItem;
        }
        return null;
    }

    private AbstractDropTarget makeDropTarget(TreeItem<HierarchyItem> treeItem, DroppingMouseLocation location) {
        FXOMObject dropTargetObject;
        int targetIndex;
        DesignHierarchyMask.Accessory accessory;
        block25: {
            HierarchyItem item;
            TreeItem<HierarchyItem> rootTreeItem;
            block26: {
                block27: {
                    block24: {
                        assert (location != null);
                        rootTreeItem = this.panelController.getRoot();
                        accessory = null;
                        targetIndex = -1;
                        FXOMDocument document = this.panelController.getEditorController().getFxomDocument();
                        if (document == null || document.getFxomRoot() == null) {
                            return new RootDropTarget();
                        }
                        if (treeItem != null) break block24;
                        dropTargetObject = ((HierarchyItem)rootTreeItem.getValue()).getFxomObject();
                        break block25;
                    }
                    item = (HierarchyItem)treeItem.getValue();
                    assert (item != null);
                    if (!item.isPlaceHolder()) break block26;
                    assert (treeItem != rootTreeItem);
                    assert (item instanceof HierarchyItemBorderPane || item instanceof HierarchyItemGraphic);
                    if (!item.isEmpty()) break block27;
                    TreeItem parentTreeItem = treeItem.getParent();
                    assert (parentTreeItem != null);
                    dropTargetObject = ((HierarchyItem)parentTreeItem.getValue()).getFxomObject();
                    accessory = item instanceof HierarchyItemBorderPane ? ((HierarchyItemBorderPane)item).getPosition() : DesignHierarchyMask.Accessory.GRAPHIC;
                    break block25;
                }
                dropTargetObject = item.getFxomObject();
                accessory = null;
                switch (location) {
                    case CENTER: 
                    case TOP: {
                        targetIndex = -1;
                        break block25;
                    }
                    case BOTTOM: {
                        targetIndex = treeItem.isLeaf() || !treeItem.isExpanded() ? -1 : 0;
                        break block25;
                    }
                    default: {
                        assert (false);
                        break block25;
                    }
                }
            }
            switch (location) {
                case CENTER: {
                    dropTargetObject = item.getFxomObject();
                    targetIndex = -1;
                    break;
                }
                case TOP: {
                    if (treeItem == rootTreeItem) {
                        dropTargetObject = item.getFxomObject();
                        targetIndex = -1;
                        break;
                    }
                    DragController dragController = this.panelController.getEditorController().getDragController();
                    AbstractDragSource dragSource = dragController.getDragSource();
                    TreeItem parentTreeItem = treeItem.getParent();
                    assert (parentTreeItem != null);
                    FXOMObject parentObject = ((HierarchyItem)parentTreeItem.getValue()).getFxomObject();
                    DesignHierarchyMask parentMask = new DesignHierarchyMask(parentObject);
                    if (parentMask.isAcceptingSubComponent(dragSource.getDraggedObjects())) {
                        dropTargetObject = ((HierarchyItem)parentTreeItem.getValue()).getFxomObject();
                        targetIndex = item.getFxomObject().getIndexInParentProperty();
                        break;
                    }
                    dropTargetObject = item.getFxomObject();
                    break;
                }
                case BOTTOM: {
                    if (treeItem == rootTreeItem) {
                        dropTargetObject = item.getFxomObject();
                        targetIndex = 0;
                        break;
                    }
                    if (treeItem.isLeaf() || !treeItem.isExpanded()) {
                        DragController dragController = this.panelController.getEditorController().getDragController();
                        AbstractDragSource dragSource = dragController.getDragSource();
                        TreeItem parentTreeItem = treeItem.getParent();
                        assert (parentTreeItem != null);
                        FXOMObject parentObject = ((HierarchyItem)parentTreeItem.getValue()).getFxomObject();
                        DesignHierarchyMask parentMask = new DesignHierarchyMask(parentObject);
                        if (parentMask.isAcceptingSubComponent(dragSource.getDraggedObjects())) {
                            dropTargetObject = ((HierarchyItem)parentTreeItem.getValue()).getFxomObject();
                            targetIndex = item.getFxomObject().getIndexInParentProperty() + 1;
                            break;
                        }
                        dropTargetObject = item.getFxomObject();
                        break;
                    }
                    dropTargetObject = item.getFxomObject();
                    targetIndex = 0;
                    break;
                }
                default: {
                    assert (false);
                    dropTargetObject = null;
                }
            }
        }
        AbstractDropTarget result = this.makeDropTarget(dropTargetObject, accessory, targetIndex);
        return result;
    }

    private AbstractDropTarget makeDropTarget(FXOMObject dropTargetObject, DesignHierarchyMask.Accessory accessory, int targetIndex) {
        AbstractDropTarget result = null;
        if (dropTargetObject != null && dropTargetObject instanceof FXOMInstance) {
            DragController dragController = this.panelController.getEditorController().getDragController();
            AbstractDragSource dragSource = dragController.getDragSource();
            assert (dragSource != null);
            FXOMInstance dropTargetInstance = (FXOMInstance)dropTargetObject;
            if (accessory != null) {
                result = new AccessoryDropTarget(dropTargetInstance, accessory);
            } else {
                DesignHierarchyMask dropTargetMask = new DesignHierarchyMask(dropTargetInstance);
                if (dropTargetMask.isAcceptingSubComponent(dragSource.getDraggedObjects())) {
                    if (dropTargetInstance.getSceneGraphObject() instanceof GridPane) {
                        result = new GridPaneDropTarget(dropTargetInstance, targetIndex);
                    } else {
                        FXOMObject beforeChild = targetIndex == -1 ? null : (targetIndex == dropTargetMask.getSubComponentCount() ? null : dropTargetMask.getSubComponentAtIndex(targetIndex));
                        result = new ContainerZDropTarget(dropTargetInstance, beforeChild);
                    }
                } else {
                    DesignHierarchyMask.Accessory[] accessories;
                    for (DesignHierarchyMask.Accessory a : accessories = new DesignHierarchyMask.Accessory[]{DesignHierarchyMask.Accessory.TOP, DesignHierarchyMask.Accessory.LEFT, DesignHierarchyMask.Accessory.CENTER, DesignHierarchyMask.Accessory.RIGHT, DesignHierarchyMask.Accessory.BOTTOM, DesignHierarchyMask.Accessory.CONTENT, DesignHierarchyMask.Accessory.CONTEXT_MENU, DesignHierarchyMask.Accessory.GRAPHIC, DesignHierarchyMask.Accessory.TOOLTIP}) {
                        AccessoryDropTarget dropTarget = new AccessoryDropTarget(dropTargetInstance, a);
                        if (!dropTarget.acceptDragSource(dragSource)) continue;
                        result = dropTarget;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public static enum DroppingMouseLocation {
        BOTTOM,
        CENTER,
        TOP;

    }
}

