/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.control.Cell;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Border;

public class HierarchyTaskScheduler {
    private final AbstractHierarchyPanelController panelController;
    private final long timerDelay = 1000L;
    private Timer timer;
    private TimerTask timerTask;
    private boolean isAddEmptyGraphicTaskScheduled = false;

    public HierarchyTaskScheduler(AbstractHierarchyPanelController c) {
        this.panelController = c;
    }

    public void scheduleExpandTask(TreeItem<HierarchyItem> treeItem) {
        this.timerTask = new HierarchyTimerTask(treeItem);
        assert (this.timerTask != null);
        this.getTimer().schedule(this.timerTask, 1000L);
    }

    public void scheduleAddEmptyGraphicTask(final TreeItem<HierarchyItem> treeItem) {
        HierarchyItem item = (HierarchyItem)treeItem.getValue();
        assert (item != null);
        final DesignHierarchyMask owner = item.getMask();
        assert (owner != null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeItem<HierarchyItem> graphicTreeItem = HierarchyTaskScheduler.this.panelController.makeTreeItemGraphic(owner, null);
                        treeItem.getChildren().add(0, graphicTreeItem);
                        treeItem.setExpanded(true);
                        Cell<?> cell = HierarchyTaskScheduler.this.panelController.getCell(treeItem);
                        assert (cell != null);
                        Border border = HierarchyTaskScheduler.this.panelController.getBorder(AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                        cell.setBorder(border);
                        HierarchyTaskScheduler.this.isAddEmptyGraphicTaskScheduled = false;
                    }
                });
            }
        };
        assert (this.timerTask != null);
        this.getTimer().schedule(this.timerTask, 1000L);
        this.isAddEmptyGraphicTaskScheduled = true;
    }

    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.isAddEmptyGraphicTaskScheduled = false;
            this.timer = null;
        }
    }

    public boolean isAddEmptyGraphicTaskScheduled() {
        return this.isAddEmptyGraphicTaskScheduled;
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        return this.timer;
    }

    private static class HierarchyTimerTask
    extends TimerTask {
        private final TreeItem<HierarchyItem> treeItem;

        HierarchyTimerTask(TreeItem<HierarchyItem> treeItem) {
            this.treeItem = treeItem;
        }

        @Override
        public void run() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    treeItem.setExpanded(true);
                }
            });
        }
    }
}

