/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview.HierarchyTreeCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview.HierarchyTreeViewUtils;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

public class HierarchyTreeViewController
extends AbstractHierarchyPanelController {
    @FXML
    protected TreeView<HierarchyItem> treeView;

    public HierarchyTreeViewController(EditorController editorController) {
        super(HierarchyTreeViewController.class.getResource("HierarchyTreeView.fxml"), editorController);
    }

    @Override
    public Control getPanelControl() {
        return this.treeView;
    }

    @Override
    public ObservableList<TreeItem<HierarchyItem>> getSelectedItems() {
        return this.treeView.getSelectionModel().getSelectedItems();
    }

    @Override
    protected void initializePanel() {
        assert (this.treeView != null);
        super.initializePanel();
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.treeView.setCellFactory((Callback)new Callback<TreeView<HierarchyItem>, TreeCell<HierarchyItem>>(){

            public TreeCell<HierarchyItem> call(TreeView<HierarchyItem> p) {
                return new HierarchyTreeCell(HierarchyTreeViewController.this);
            }
        });
        this.treeView.setEditable(false);
    }

    @Override
    protected void updatePanel() {
        if (this.treeView != null) {
            this.updateTreeItems();
            this.stopListeningToTreeItemSelection();
            this.treeView.setRoot(this.rootTreeItem);
            this.startListeningToTreeItemSelection();
        }
    }

    @Override
    protected void clearSelection() {
        assert (this.treeView != null);
        this.treeView.getSelectionModel().clearSelection();
    }

    @Override
    protected void select(TreeItem<HierarchyItem> treeItem) {
        assert (this.treeView != null);
        boolean isExpanded = treeItem.isExpanded();
        this.treeView.getSelectionModel().select(treeItem);
        treeItem.setExpanded(isExpanded);
    }

    @Override
    public void scrollTo(TreeItem<HierarchyItem> treeItem) {
        assert (this.treeView != null);
        this.treeView.scrollTo(this.treeView.getRow(treeItem));
    }

    @Override
    public Cell<?> getCell(TreeItem<?> treeItem) {
        assert (this.treeView != null);
        TreeCell<?> treeCell = HierarchyTreeViewUtils.getTreeCell(this.treeView, treeItem);
        return treeCell;
    }

    @Override
    public double getContentTopY() {
        Bounds bounds = this.treeView.getLayoutBounds();
        Point2D point = this.treeView.localToParent(bounds.getMinX(), bounds.getMinY());
        return point.getY();
    }

    @Override
    public double getContentBottomY() {
        Bounds bounds = this.treeView.getLayoutBounds();
        Point2D point = this.treeView.localToParent(bounds.getMinX(), bounds.getMinY());
        double topY = point.getY();
        double height = bounds.getHeight();
        ScrollBar horizontalScrollBar = this.getScrollBar(Orientation.HORIZONTAL);
        double bottomY = horizontalScrollBar != null && horizontalScrollBar.isVisible() ? topY + height - horizontalScrollBar.getLayoutBounds().getHeight() : topY + height;
        return bottomY;
    }

    @Override
    protected void startListeningToTreeItemSelection() {
        this.treeView.getSelectionModel().getSelectedItems().addListener(this.treeItemSelectionListener);
    }

    @Override
    protected void stopListeningToTreeItemSelection() {
        this.treeView.getSelectionModel().getSelectedItems().removeListener(this.treeItemSelectionListener);
    }

    @Override
    protected void startEditingDisplayInfo() {
        ObservableList selectedTreeItems = this.treeView.getSelectionModel().getSelectedItems();
        if (selectedTreeItems.size() == 1) {
            TreeItem selectedTreeItem = (TreeItem)selectedTreeItems.get(0);
            HierarchyItem item = (HierarchyItem)selectedTreeItem.getValue();
            AbstractHierarchyPanelController.DisplayOption option = this.getDisplayOption();
            if (item != null && !item.isResourceKey(option) && item.hasDisplayInfo(option)) {
                TreeCell<?> tc = HierarchyTreeViewUtils.getTreeCell(this.treeView, selectedTreeItem);
                assert (tc instanceof HierarchyTreeCell);
                HierarchyTreeCell htc = (HierarchyTreeCell)tc;
                htc.startEditingDisplayInfo();
            }
        }
    }

    @Override
    public void clearBorderColor() {
        assert (this.treeView != null);
        Set<Node> cells = HierarchyTreeViewUtils.getTreeCells(this.treeView);
        assert (cells != null);
        for (Node node : cells) {
            assert (node instanceof Cell);
            this.clearBorderColor((Cell)node);
        }
    }

    @Override
    public void updateParentRing() {
        assert (this.treeView != null);
        if (!this.isParentRingEnabled()) {
            return;
        }
        Set<Node> treeCells = HierarchyTreeViewUtils.getTreeCells(this.treeView);
        ObservableList selectedTreeItems = this.treeView.getSelectionModel().getSelectedItems();
        this.clearBorderColor();
        for (TreeItem selectedTreeItem : selectedTreeItems) {
            if (selectedTreeItem != null) continue;
            return;
        }
        if (!selectedTreeItems.isEmpty()) {
            int treeCellBottomIndex;
            int treeCellTopIndex;
            TreeItem treeItemRoot = this.treeView.getRoot();
            if (selectedTreeItems.size() == 1 && selectedTreeItems.get(0) == treeItemRoot) {
                return;
            }
            TreeItem treeItemTop = HierarchyTreeViewUtils.getCommonParentTreeItem(selectedTreeItems);
            TreeCell<?> treeCellTop = HierarchyTreeViewUtils.getTreeCell(treeCells, treeItemTop);
            if (treeCellTop != null) {
                treeCellTop.setBorder(this.getBorder(AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_LEFT));
                treeCellTopIndex = treeCellTop.getIndex();
            } else {
                treeCellTopIndex = 0;
            }
            int size = treeItemTop.getChildren().size();
            assert (size >= 1);
            TreeItem treeItemBottom = (TreeItem)treeItemTop.getChildren().get(size - 1);
            TreeCell<?> treeCellBottom = HierarchyTreeViewUtils.getTreeCell(treeCells, treeItemBottom);
            if (treeCellBottom != null) {
                treeCellBottom.setBorder(this.getBorder(AbstractHierarchyPanelController.BorderSide.RIGHT_BOTTOM_LEFT));
                treeCellBottomIndex = treeCellBottom.getIndex();
            } else {
                treeCellBottomIndex = treeCells.size() - 1;
            }
            for (Node node : treeCells) {
                assert (node instanceof TreeCell);
                TreeCell treeCell = (TreeCell)node;
                int index = treeCell.getIndex();
                if (index <= treeCellTopIndex || index >= treeCellBottomIndex) continue;
                treeCell.setBorder(this.getBorder(AbstractHierarchyPanelController.BorderSide.RIGHT_LEFT));
            }
        }
    }

    @Override
    public void updatePlaceHolder() {
        assert (this.treeView != null);
        Set<Node> cells = HierarchyTreeViewUtils.getTreeCells(this.treeView);
        assert (cells != null);
        for (Node node : cells) {
            assert (node instanceof HierarchyTreeCell);
            HierarchyTreeCell cell = (HierarchyTreeCell)node;
            cell.updatePlaceHolder();
        }
    }
}

