/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertiesEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class AnchorPaneConstraintsEditor
extends PropertiesEditor {
    private static final String ANCHOR_ENABLED_COLOR = "-sb-line-art-accent";
    private static final String ANCHOR_DISABLED_COLOR = "-sb-line-art";
    @FXML
    private ToggleButton bottomTb;
    @FXML
    private TextField bottomTf;
    @FXML
    private Region innerR;
    @FXML
    private ToggleButton leftTb;
    @FXML
    private TextField leftTf;
    @FXML
    private Region outerR;
    @FXML
    private ToggleButton rightTb;
    @FXML
    private TextField rightTf;
    @FXML
    private ToggleButton topTb;
    @FXML
    private TextField topTf;
    private final Parent root;
    private final ArrayList<ConstraintEditor> contraintEditors = new ArrayList();
    private final ChangeListener<Object> constraintListener;
    private Set<FXOMInstance> selectedInstances;

    public AnchorPaneConstraintsEditor(String name, ValuePropertyMetadata topPropMeta, ValuePropertyMetadata rightPropMeta, ValuePropertyMetadata bottomPropMeta, ValuePropertyMetadata leftPropMeta, Set<FXOMInstance> selectedInstances) {
        super(name);
        this.root = EditorUtils.loadFxml("AnchorPaneConstraintsEditor.fxml", (Object)this);
        this.selectedInstances = selectedInstances;
        this.constraintListener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> ov, Object prevValue, Object newValue) {
                AnchorPaneConstraintsEditor.this.propertyChanged();
                AnchorPaneConstraintsEditor.this.styleRegions();
            }
        };
        this.initialize(topPropMeta, rightPropMeta, bottomPropMeta, leftPropMeta);
        this.propertyChanged();
        this.styleRegions();
    }

    private void initialize(ValuePropertyMetadata topPropMeta, ValuePropertyMetadata rightPropMeta, ValuePropertyMetadata bottomPropMeta, ValuePropertyMetadata leftPropMeta) {
        this.contraintEditors.add(new ConstraintEditor(this.topTf, this.topTb, this.selectedInstances, topPropMeta, this.constraintListener));
        this.contraintEditors.add(new ConstraintEditor(this.rightTf, this.rightTb, this.selectedInstances, rightPropMeta, this.constraintListener));
        this.contraintEditors.add(new ConstraintEditor(this.bottomTf, this.bottomTb, this.selectedInstances, bottomPropMeta, this.constraintListener));
        this.contraintEditors.add(new ConstraintEditor(this.leftTf, this.leftTb, this.selectedInstances, leftPropMeta, this.constraintListener));
    }

    @Override
    public List<PropertyEditor> getPropertyEditors() {
        ArrayList<PropertyEditor> propertyEditors = new ArrayList<PropertyEditor>();
        for (ConstraintEditor constraintEditor : this.contraintEditors) {
            propertyEditors.add(constraintEditor);
        }
        return propertyEditors;
    }

    public void reset(ValuePropertyMetadata topPropMeta, ValuePropertyMetadata rightPropMeta, ValuePropertyMetadata bottomPropMeta, ValuePropertyMetadata leftPropMeta, Set<FXOMInstance> selectedInstances) {
        this.selectedInstances = selectedInstances;
        this.contraintEditors.get(0).reset(selectedInstances, topPropMeta);
        this.contraintEditors.get(1).reset(selectedInstances, rightPropMeta);
        this.contraintEditors.get(2).reset(selectedInstances, bottomPropMeta);
        this.contraintEditors.get(3).reset(selectedInstances, leftPropMeta);
        for (int ii = 0; ii < 4; ++ii) {
            this.contraintEditors.get(ii).addValueListener(this.constraintListener);
        }
        this.styleRegions();
    }

    @Override
    public Node getValueEditor() {
        return this.root;
    }

    private void styleRegions() {
        StringBuilder styleString = new StringBuilder();
        for (int ii = 0; ii < 4; ++ii) {
            if (this.contraintEditors.get(ii).isAnchorEnabled()) {
                styleString.append(ANCHOR_ENABLED_COLOR);
                styleString.append(" ");
                continue;
            }
            styleString.append(ANCHOR_DISABLED_COLOR);
            styleString.append(" ");
        }
        String style = "-fx-border-color: " + styleString;
        this.innerR.setStyle(style);
        this.outerR.setStyle(style);
    }

    private static class ConstraintEditor
    extends PropertyEditor {
        private ToggleButton toggleButton;
        private TextField textField;
        private Set<FXOMInstance> selectedInstances;
        private ValuePropertyMetadata propMeta;
        private boolean updateFromTextField = false;

        public ConstraintEditor(final TextField textField, final ToggleButton toggleButton, Set<FXOMInstance> selectedInstances, ValuePropertyMetadata propMeta, ChangeListener<Object> listener) {
            super(propMeta, null);
            super.addValueListener(listener);
            this.textField = textField;
            this.toggleButton = toggleButton;
            this.selectedInstances = selectedInstances;
            this.propMeta = propMeta;
            textField.setId(EditorUtils.toDisplayName(propMeta.getName().getName()) + " Value");
            EventHandler<ActionEvent> valueListener = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    double valDouble;
                    if (this.isHandlingError()) {
                        return;
                    }
                    String valStr = textField.getText();
                    if (valStr == null || valStr.isEmpty()) {
                        if (toggleButton.isSelected()) {
                            updateFromTextField = true;
                            toggleButton.setSelected(false);
                            updateFromTextField = false;
                        }
                        this.userUpdateValueProperty(null);
                        return;
                    }
                    textField.selectAll();
                    try {
                        valDouble = Double.parseDouble(valStr);
                    }
                    catch (NumberFormatException e) {
                        this.handleInvalidValue(valStr, (Node)textField);
                        return;
                    }
                    if (!((DoublePropertyMetadata)this.getPropertyMeta()).isValidValue(valDouble)) {
                        this.handleInvalidValue(valDouble, (Node)textField);
                        return;
                    }
                    if (!toggleButton.isSelected()) {
                        updateFromTextField = true;
                        toggleButton.setSelected(true);
                        updateFromTextField = false;
                    }
                    this.userUpdateValueProperty(valDouble);
                }
            };
            this.setNumericEditorBehavior(this, (Control)textField, valueListener, false);
            textField.setPromptText("");
            textField.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    toggleButton.setSelected(true);
                }
            });
            assert (propMeta instanceof DoublePropertyMetadata);
            toggleButton.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean prevSel, Boolean newSel) {
                    if (this.isUpdateFromModel() || updateFromTextField) {
                        return;
                    }
                    if (newSel.booleanValue()) {
                        String propName;
                        double anchor = 0.0;
                        switch (propName = propMeta.getName().toString()) {
                            case "AnchorPane.topAnchor": {
                                anchor = EditorUtils.computeTopAnchor(this.getFirstInstance());
                                break;
                            }
                            case "AnchorPane.rightAnchor": {
                                anchor = EditorUtils.computeRightAnchor(this.getFirstInstance());
                                break;
                            }
                            case "AnchorPane.bottomAnchor": {
                                anchor = EditorUtils.computeBottomAnchor(this.getFirstInstance());
                                break;
                            }
                            case "AnchorPane.leftAnchor": {
                                anchor = EditorUtils.computeLeftAnchor(this.getFirstInstance());
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        textField.setText(EditorUtils.valAsStr(anchor));
                        this.userUpdateValueProperty(this.getValue());
                    } else {
                        textField.setText(null);
                        this.userUpdateValueProperty(null);
                    }
                }
            });
        }

        @Override
        public Node getValueEditor() {
            assert (false);
            return null;
        }

        @Override
        public Object getValue() {
            String valStr = this.textField.getText();
            if (valStr == null || valStr.isEmpty()) {
                return null;
            }
            return new Double(valStr);
        }

        @Override
        public void setValue(Object value) {
            this.setValueGeneric(value);
            if (this.isSetValueDone()) {
                return;
            }
            if (value == null) {
                this.toggleButton.setSelected(false);
                this.textField.setText(null);
            } else {
                assert (value instanceof Double);
                this.toggleButton.setSelected(true);
                this.textField.setText(EditorUtils.valAsStr(value));
                if (this.textField.isFocused()) {
                    this.textField.positionCaret(this.textField.getLength());
                }
            }
        }

        public void reset(Set<FXOMInstance> selectedInstances, ValuePropertyMetadata propMeta) {
            super.reset(propMeta, null);
            this.selectedInstances = selectedInstances;
            this.propMeta = propMeta;
            this.textField.setPromptText(null);
        }

        @Override
        protected void valueIsIndeterminate() {
            ConstraintEditor.handleIndeterminate((Node)this.textField);
        }

        public boolean isAnchorEnabled() {
            return this.valueProperty().getValue() != null;
        }

        @Override
        public void requestFocus() {
            EditorUtils.doNextFrame(new Runnable(){

                @Override
                public void run() {
                    textField.requestFocus();
                }
            });
        }

        private FXOMInstance getFirstInstance() {
            return (FXOMInstance)this.selectedInstances.toArray()[0];
        }
    }
}

