/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.layout.StackPane;

public class BoundedDoubleEditor
extends AutoSuggestEditor {
    @FXML
    private Slider slider;
    @FXML
    private StackPane textSp;
    private Parent root = null;
    private Map<String, Object> constants;
    private double min = 0.0;
    private double max = 100.0;
    private boolean minMaxForSliderOnly = false;
    private int roundingFactor = 1;
    private boolean updateFromTextField = false;
    private boolean updateFromSlider = false;

    public BoundedDoubleEditor(String name, String defaultValue, List<String> suggestedList) {
        this(name, defaultValue, suggestedList, null, null, false);
    }

    public BoundedDoubleEditor(String name, String defaultValue, List<String> suggestedList, Double min, Double max, boolean minMaxForSliderOnly) {
        super(name, defaultValue, suggestedList, AutoSuggestEditor.Type.DOUBLE);
        if (min != null) {
            this.min = min;
        }
        if (max != null) {
            this.max = max;
        }
        this.minMaxForSliderOnly = minMaxForSliderOnly;
        this.constants = new TreeMap<String, Object>();
        this.initialize();
    }

    public BoundedDoubleEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Object> constantsMap) {
        super(propMeta, selectedClasses, new ArrayList<String>(constantsMap.keySet()), AutoSuggestEditor.Type.DOUBLE);
        this.constants = constantsMap;
        this.initialize();
    }

    private void initialize() {
        this.root = EditorUtils.loadFxml("BoundedDoubleEditor.fxml", (Object)this);
        EventHandler<ActionEvent> onActionListener = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (BoundedDoubleEditor.this.isHandlingError()) {
                    return;
                }
                if (BoundedDoubleEditor.this.isUpdateFromModel() || BoundedDoubleEditor.this.updateFromSlider) {
                    return;
                }
                Object value = BoundedDoubleEditor.this.getValue();
                if (!(BoundedDoubleEditor.this.getPropertyMeta() == null || value != null && ((DoublePropertyMetadata)BoundedDoubleEditor.this.getPropertyMeta()).isValidValue((Double)value))) {
                    BoundedDoubleEditor.this.handleInvalidValue(BoundedDoubleEditor.this.getTextField().getText());
                }
                assert (value instanceof Double);
                double valDouble = (Double)value;
                boolean isConstant = BoundedDoubleEditor.this.constants.get(BoundedDoubleEditor.this.getTextField().getText().toUpperCase(Locale.ROOT)) != null;
                for (Map.Entry entry : BoundedDoubleEditor.this.constants.entrySet()) {
                    if (!value.equals(entry.getValue())) continue;
                    isConstant = true;
                    break;
                }
                if (!BoundedDoubleEditor.this.minMaxForSliderOnly && !isConstant && (valDouble < BoundedDoubleEditor.this.min || valDouble > BoundedDoubleEditor.this.max)) {
                    if (valDouble < BoundedDoubleEditor.this.min) {
                        valDouble = BoundedDoubleEditor.this.min;
                    } else if (valDouble > BoundedDoubleEditor.this.max) {
                        valDouble = BoundedDoubleEditor.this.max;
                    }
                    BoundedDoubleEditor.this.getTextField().setText(EditorUtils.valAsStr(valDouble));
                }
                BoundedDoubleEditor.this.getTextField().selectAll();
                BoundedDoubleEditor.this.updateFromTextField = true;
                BoundedDoubleEditor.this.slider.setValue(valDouble);
                BoundedDoubleEditor.this.updateFromTextField = false;
                BoundedDoubleEditor.this.userUpdateValueProperty(valDouble);
            }
        };
        this.setNumericEditorBehavior(this, (Control)this.getTextField(), onActionListener, false);
        this.configureSlider(this.getPropertyMeta());
        this.slider.valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                if (BoundedDoubleEditor.this.isUpdateFromModel() || BoundedDoubleEditor.this.updateFromTextField) {
                    return;
                }
                double value = EditorUtils.round(BoundedDoubleEditor.this.slider.getValue(), BoundedDoubleEditor.this.roundingFactor);
                BoundedDoubleEditor.this.updateFromSlider = true;
                BoundedDoubleEditor.this.getTextField().setText(EditorUtils.valAsStr(value));
                BoundedDoubleEditor.this.updateFromSlider = false;
                BoundedDoubleEditor.this.userUpdateTransientValueProperty(value);
            }
        });
        this.slider.pressedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                if (!BoundedDoubleEditor.this.slider.isPressed()) {
                    double value = EditorUtils.round(BoundedDoubleEditor.this.slider.getValue(), BoundedDoubleEditor.this.roundingFactor);
                    BoundedDoubleEditor.this.userUpdateValueProperty(value);
                }
            }
        });
        this.textSp.getChildren().add((Object)super.getRoot());
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        String val = this.getTextField().getText();
        if (val.isEmpty()) {
            val = "0";
            this.getTextField().setText(val);
            return new Double(val);
        }
        Object constantValue = this.constants.get(val.toUpperCase(Locale.ROOT));
        if (constantValue != null) {
            val = EditorUtils.valAsStr(constantValue);
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        assert (value instanceof Double);
        this.slider.setValue(((Double)value).doubleValue());
        for (Map.Entry<String, Object> entry : this.constants.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            value = entry.getKey();
        }
        this.getTextField().setText(EditorUtils.valAsStr(value));
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Object> constants) {
        super.reset(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()));
        this.constants = constants;
        this.configureSlider(propMeta);
    }

    @Override
    protected void valueIsIndeterminate() {
        BoundedDoubleEditor.handleIndeterminate((Node)this.getTextField());
    }

    private void configureSlider(ValuePropertyMetadata propMeta) {
        if (propMeta != null) {
            assert (propMeta instanceof DoublePropertyMetadata);
            DoublePropertyMetadata doublePropMeta = (DoublePropertyMetadata)propMeta;
            DoublePropertyMetadata.DoubleKind kind = doublePropMeta.getKind();
            if (kind == DoublePropertyMetadata.DoubleKind.OPACITY || kind == DoublePropertyMetadata.DoubleKind.PROGRESS) {
                this.min = 0.0;
                this.max = 1.0;
                this.roundingFactor = 100;
            }
        }
        this.slider.setMin(this.min);
        this.slider.setMax(this.max);
        this.slider.setBlockIncrement((this.max - this.min) / 20.0);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(new Runnable(){

            @Override
            public void run() {
                BoundedDoubleEditor.this.getTextField().requestFocus();
            }
        });
    }
}

