/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

public class ControllerClassEditor
extends AutoSuggestEditor {
    private static final String PROPERTY_NAME = "Controller class";
    private static final String DEFAULT_VALUE = null;

    public ControllerClassEditor(List<String> suggestedClasses) {
        super(PROPERTY_NAME, DEFAULT_VALUE, suggestedClasses);
        EventHandler<ActionEvent> onActionListener = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ControllerClassEditor.this.isHandlingError()) {
                    return;
                }
                String value = ControllerClassEditor.this.textField.getText();
                if (value != null && !value.isEmpty() && !JavaLanguage.isClassName(value)) {
                    ControllerClassEditor.this.handleInvalidValue(value);
                    return;
                }
                ControllerClassEditor.this.userUpdateValueProperty(value == null || value.isEmpty() ? null : value);
                ControllerClassEditor.this.textField.selectAll();
            }
        };
        this.setTextEditorBehavior(this, (Control)this.textField, onActionListener);
    }

    public void reset(List<String> suggestedClasses) {
        super.reset(PROPERTY_NAME, DEFAULT_VALUE, suggestedClasses);
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (value == null) {
            this.getTextField().setText(null);
        } else {
            assert (value instanceof String);
            this.getTextField().setText((String)value);
        }
    }
}

