/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.CursorPropertyMetadata;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;

public class CursorEditor
extends PropertyEditor {
    private final Parent root;
    @FXML
    private MenuButton cursorMb;
    @FXML
    private CheckMenuItem inheritedMi;
    @FXML
    private Label inheritedLb;
    private Cursor cursor = Cursor.DEFAULT;
    private String inheritedText;
    private String inheritedParentText;

    public CursorEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.root = EditorUtils.loadFxml("CursorEditor.fxml", (Object)this);
        this.initialize();
    }

    private void initialize() {
        Cursor[] cursorList;
        int index = 0;
        Map<Cursor, String> predefinedCursors = CursorPropertyMetadata.getCursorMap();
        for (Cursor cursorObj : cursorList = new Cursor[]{Cursor.DEFAULT, Cursor.CLOSED_HAND, Cursor.OPEN_HAND, Cursor.HAND, Cursor.MOVE, Cursor.WAIT, Cursor.TEXT, Cursor.V_RESIZE, Cursor.H_RESIZE, Cursor.N_RESIZE, Cursor.NE_RESIZE, Cursor.E_RESIZE, Cursor.SE_RESIZE, Cursor.S_RESIZE, Cursor.SW_RESIZE, Cursor.W_RESIZE, Cursor.NW_RESIZE, Cursor.CROSSHAIR, Cursor.NONE, Cursor.DISAPPEAR}) {
            final String cursorStr = predefinedCursors.get(cursorObj);
            Label cursorLabel = new Label(cursorStr);
            cursorLabel.setCursor(cursorObj);
            CheckMenuItem menuItem = new CheckMenuItem();
            menuItem.setGraphic((Node)cursorLabel);
            this.cursorMb.getItems().add(index++, (Object)menuItem);
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    CursorEditor.this.selectCursor(cursorStr);
                    CursorEditor.this.userUpdateValueProperty(CursorEditor.this.getValue());
                }
            });
        }
        this.inheritedText = I18N.getString("inspector.cursor.inherited");
        this.inheritedParentText = I18N.getString("inspector.cursor.inheritedparent");
        this.inheritedLb.setText(this.inheritedParentText);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        return this.cursor;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.cursor = null;
            this.selectCursor(this.inheritedParentText);
        } else {
            assert (value instanceof Cursor);
            if (value instanceof ImageCursor) {
                this.selectCursor("");
                this.cursorMb.setText(I18N.getString("inspector.cursor.custom"));
            } else {
                this.selectCursor(((Cursor)value).toString());
            }
        }
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
    }

    @Override
    protected void valueIsIndeterminate() {
        CursorEditor.handleIndeterminate((Node)this.cursorMb);
    }

    @FXML
    void inherited(ActionEvent event) {
        this.cursor = null;
        this.selectCursor(this.inheritedParentText);
        this.userUpdateValueProperty(this.getValue());
    }

    private void selectCursor(String cursorStr) {
        for (MenuItem menuItem : this.cursorMb.getItems()) {
            if (!(menuItem instanceof CheckMenuItem)) continue;
            CheckMenuItem checkMenuItem = (CheckMenuItem)menuItem;
            assert (checkMenuItem.getGraphic() instanceof Label);
            if (cursorStr.equals(((Label)checkMenuItem.getGraphic()).getText())) {
                checkMenuItem.setSelected(true);
                if (cursorStr.equals(this.inheritedParentText)) {
                    this.cursorMb.setText(this.inheritedText);
                } else {
                    this.cursorMb.setText(cursorStr);
                }
                this.cursor = checkMenuItem.getGraphic().getCursor();
                continue;
            }
            checkMenuItem.setSelected(false);
        }
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(new Runnable(){

            @Override
            public void run() {
                CursorEditor.this.cursorMb.requestFocus();
            }
        });
    }
}

