/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

public class DoubleEditor
extends AutoSuggestEditor {
    private Map<String, Object> constants;

    public DoubleEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Object> constants) {
        super(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()), AutoSuggestEditor.Type.DOUBLE);
        this.constants = constants;
        EventHandler<ActionEvent> onActionListener = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (DoubleEditor.this.isHandlingError()) {
                    return;
                }
                Object value = DoubleEditor.this.getValue();
                if (value != null && ((DoublePropertyMetadata)DoubleEditor.this.getPropertyMeta()).isValidValue((Double)value)) {
                    DoubleEditor.this.userUpdateValueProperty(value);
                    DoubleEditor.this.getTextField().selectAll();
                } else {
                    DoubleEditor.this.handleInvalidValue(DoubleEditor.this.getTextField().getText());
                }
            }
        };
        this.setNumericEditorBehavior(this, (Control)this.getTextField(), onActionListener);
    }

    @Override
    public Object getValue() {
        String val = this.getTextField().getText();
        if (val.isEmpty()) {
            val = "0";
            this.getTextField().setText(val);
            return new Double(val);
        }
        Object constantValue = this.constants.get(val.toUpperCase(Locale.ROOT));
        if (constantValue != null) {
            val = EditorUtils.valAsStr(constantValue);
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        assert (value instanceof Double);
        for (Map.Entry<String, Object> entry : this.constants.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            value = entry.getKey();
        }
        this.getTextField().setText(EditorUtils.valAsStr(value));
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(new Runnable(){

            @Override
            public void run() {
                DoubleEditor.this.getTextField().requestFocus();
            }
        });
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Object> constants) {
        super.reset(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()));
        this.constants = constants;
    }
}

