/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class I18nStringEditor
extends PropertyEditor {
    private static final String PERCENT_STR = "%";
    private TextInputControl textNode = new TextField();
    private HBox i18nHBox = null;
    final EventHandler<ActionEvent> valueListener;
    private final MenuItem i18nMenuItem = new MenuItem();
    private final String I18N_ON = I18N.getString("inspector.i18n.on");
    private final String I18N_OFF = I18N.getString("inspector.i18n.off");
    private final MenuItem multilineMenuItem = new MenuItem();
    private final String MULTI_LINE = I18N.getString("inspector.i18n.multiline");
    private final String SINGLE_LINE = I18N.getString("inspector.i18n.singleline");
    private boolean i18nMode = false;
    private boolean multiLineMode = false;

    public I18nStringEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.valueListener = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                I18nStringEditor.this.userUpdateValueProperty(I18nStringEditor.this.getValue());
                I18nStringEditor.this.textNode.selectAll();
            }
        };
        this.setTextEditorBehavior(this, (Control)this.textNode, this.valueListener);
        this.getMenu().getItems().add((Object)this.i18nMenuItem);
        this.getMenu().getItems().add((Object)this.multilineMenuItem);
        this.i18nMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (!I18nStringEditor.this.i18nMode) {
                    I18nStringEditor.this.setValue(new PrefixedValue(PrefixedValue.Type.RESOURCE_KEY, I18N.getString("inspector.i18n.dummykey")).toString());
                } else {
                    I18nStringEditor.this.setValue("");
                }
                I18nStringEditor.this.getCommitListener().handle(null);
                I18nStringEditor.this.updateMenuItems();
            }
        });
        this.multilineMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (!I18nStringEditor.this.multiLineMode) {
                    I18nStringEditor.this.switchToTextArea();
                } else {
                    I18nStringEditor.this.switchToTextField();
                }
                I18nStringEditor.this.multiLineMode = !I18nStringEditor.this.multiLineMode;
                I18nStringEditor.this.updateMenuItems();
            }
        });
    }

    @Override
    public Object getValue() {
        String val = this.textNode.getText();
        val = this.i18nMode ? new PrefixedValue(PrefixedValue.Type.RESOURCE_KEY, val).toString() : EditorUtils.getPlainString(val);
        return val;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.textNode.setText(null);
            return;
        }
        assert (value instanceof String);
        String val = (String)value;
        PrefixedValue prefixedValue = new PrefixedValue(val);
        String suffix = prefixedValue.getSuffix();
        if (prefixedValue.isResourceKey()) {
            if (!this.i18nMode) {
                this.wrapInHBox();
                this.i18nMode = true;
            }
        } else if (this.i18nMode) {
            this.unwrapHBox();
            this.i18nMode = false;
        }
        if (I18nStringEditor.containsLineFeed(prefixedValue.toString())) {
            if (this.i18nMode) {
                this.multiLineMode = false;
                this.switchToTextField();
            } else if (!this.multiLineMode) {
                this.multiLineMode = true;
                this.switchToTextArea();
            }
        } else if (this.multiLineMode) {
            this.multiLineMode = false;
            this.switchToTextField();
        }
        if (this.i18nMode) {
            this.textNode.setText(suffix);
        } else {
            this.textNode.setText(prefixedValue.toString());
        }
        this.updateMenuItems();
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.textNode.setPromptText(null);
    }

    @Override
    public Node getValueEditor() {
        Object valueEditor = this.i18nMode ? this.i18nHBox : this.textNode;
        return super.handleGenericModes((Node)valueEditor);
    }

    @Override
    protected void valueIsIndeterminate() {
        I18nStringEditor.handleIndeterminate((Node)this.textNode);
    }

    protected void switchToTextArea() {
        if (this.textNode instanceof TextArea) {
            return;
        }
        TextArea textArea = new TextArea(this.textNode.getText());
        this.setTextEditorBehavior(this, (Control)textArea, this.valueListener);
        textArea.setPrefRowCount(5);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_TOP);
        if (this.textNode.getParent() != null) {
            EditorUtils.replaceNode((Node)this.textNode, (Node)textArea, this.getLayoutFormat());
        }
        this.textNode = textArea;
    }

    protected void switchToTextField() {
        if (this.textNode instanceof TextField) {
            return;
        }
        String val = this.textNode.getText().replace("\n", "");
        TextField textField = new TextField(val);
        this.setTextEditorBehavior(this, (Control)textField, this.valueListener);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_CENTERED);
        if (this.textNode.getParent() != null) {
            EditorUtils.replaceNode((Node)this.textNode, (Node)textField, this.getLayoutFormat());
        }
        this.textNode = textField;
    }

    private void wrapInHBox() {
        this.i18nHBox = new HBox();
        this.i18nHBox.setAlignment(Pos.CENTER);
        EditorUtils.replaceNode((Node)this.textNode, (Node)this.i18nHBox, null);
        Label percentLabel = new Label(PERCENT_STR);
        percentLabel.getStyleClass().add((Object)"symbol-prefix");
        this.i18nHBox.getChildren().addAll((Object[])new Node[]{percentLabel, this.textNode});
        HBox.setHgrow((Node)percentLabel, (Priority)Priority.NEVER);
        this.textNode.setPrefWidth(30.0);
        HBox.setHgrow((Node)this.textNode, (Priority)Priority.ALWAYS);
    }

    private void unwrapHBox() {
        this.i18nHBox.getChildren().remove((Object)this.textNode);
        EditorUtils.replaceNode((Node)this.i18nHBox, (Node)this.textNode, null);
    }

    private static boolean containsLineFeed(String str) {
        return str.contains("\n");
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(new Runnable(){

            @Override
            public void run() {
                I18nStringEditor.this.textNode.requestFocus();
            }
        });
    }

    private void updateMenuItems() {
        if (this.i18nMode) {
            this.i18nMenuItem.setText(this.I18N_OFF);
            this.multilineMenuItem.setDisable(true);
        } else {
            this.i18nMenuItem.setText(this.I18N_ON);
            this.multilineMenuItem.setDisable(false);
        }
        if (this.multiLineMode) {
            this.multilineMenuItem.setText(this.SINGLE_LINE);
            this.i18nMenuItem.setDisable(true);
        } else {
            this.multilineMenuItem.setText(this.MULTI_LINE);
            this.i18nMenuItem.setDisable(false);
        }
    }
}

