/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.Editor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.animation.FadeTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public abstract class PropertyEditor
extends Editor {
    public static final LayoutFormat DEFAULT_LAYOUT_FORMAT = LayoutFormat.SIMPLE_LINE_CENTERED;
    private static final Image cssIcon = new Image(InspectorPanelController.class.getResource("images/css-icon.png").toExternalForm());
    private Hyperlink propName;
    private HBox propNameNode;
    private MenuButton menu;
    private ValuePropertyMetadata propMeta = null;
    private Set<Class<?>> selectedClasses;
    private Object defaultValue;
    private final Set<ChangeListener<Object>> valueListeners = new HashSet<ChangeListener<Object>>();
    private final Set<ChangeListener<Object>> transientValueListeners = new HashSet<ChangeListener<Object>>();
    private final Set<ChangeListener<Boolean>> editingListeners = new HashSet<ChangeListener<Boolean>>();
    private ChangeListener<String> navigateRequestListener = null;
    private EventHandler<?> commitListener;
    private final BooleanProperty disableProperty = new SimpleBooleanProperty(false);
    private boolean binding = false;
    private final BooleanProperty indeterminateProperty = new SimpleBooleanProperty(false);
    private boolean ruledByCss = false;
    private CssInternal.CssPropAuthorInfo cssInfo;
    private MenuItem showCssMenuItem = null;
    private boolean updateFromModel = true;
    private final ObjectProperty<Object> valueProperty = new SimpleObjectProperty();
    private final ObjectProperty<Object> transientValueProperty = new SimpleObjectProperty();
    private final BooleanProperty editingProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty invalidValueProperty = new SimpleBooleanProperty(false);
    private final StringProperty navigateRequestProperty = new SimpleStringProperty();
    private boolean handlingError = false;
    private LayoutFormat layoutFormat = DEFAULT_LAYOUT_FORMAT;
    private final MenuItem resetvalueMenuItem = new MenuItem(I18N.getString("inspector.editors.resetvalue"));
    private FadeTransition fadeTransition = null;
    private boolean genericModesHandled = false;

    public PropertyEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        this.propMeta = propMeta;
        this.initialize();
        this.setSelectedClasses(selectedClasses);
        this.setPropNamePrettyText();
        this.defaultValue = propMeta.getDefaultValueObject();
    }

    public PropertyEditor(String name, String defaultValue) {
        this.initialize();
        this.propName.setText(name);
        this.defaultValue = defaultValue;
    }

    private void initialize() {
        this.propName = new Hyperlink();
        this.propName.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (PropertyEditor.this.propMeta != null && PropertyEditor.this.selectedClasses != null) {
                        if (PropertyEditor.this.selectedClasses.size() <= 1) {
                            EditorUtils.openUrl(PropertyEditor.this.selectedClasses, PropertyEditor.this.propMeta);
                        }
                    } else {
                        EditorPlatform.open("http://docs.oracle.com/javase/8/javafx/api/javafx/2/api/javafx/fxml/doc-files/introduction_to_fxml.html");
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        });
        this.propName.getStyleClass().add((Object)"property-link");
        this.propName.setFocusTraversable(false);
        this.propNameNode = new HBox();
        this.propNameNode.getChildren().add((Object)this.propName);
        this.propNameNode.setAlignment(Pos.CENTER_RIGHT);
        EditorUtils.makeWidthStretchable((Node)this.propNameNode);
    }

    public HBox getPropNameNode() {
        return this.propNameNode;
    }

    public PropertyName getPropertyName() {
        if (this.propMeta == null) {
            return null;
        }
        return this.propMeta.getName();
    }

    public String getPropertyNameText() {
        return this.propName.getText();
    }

    public void setPropertyText(String text) {
        this.propName.setText(text);
    }

    @Override
    public final MenuButton getMenu() {
        if (this.menu == null) {
            this.menu = new MenuButton();
            Region region = new Region();
            this.menu.setGraphic((Node)region);
            region.getStyleClass().add((Object)"cog-shape");
            this.menu.disableProperty().bind((ObservableValue)this.disableProperty);
            this.menu.getStyleClass().add((Object)"cog-menubutton");
            this.menu.setOpacity(0.0);
            if (this.fadeTransition == null) {
                this.fadeTransition = new FadeTransition(Duration.millis((double)500.0), (Node)this.menu);
            }
            EditorUtils.handleFading(this.fadeTransition, (Node)this.menu, this.disableProperty);
            EditorUtils.handleFading(this.fadeTransition, (Node)this.propNameNode, this.disableProperty);
            this.menu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        EditorUtils.fadeTo(PropertyEditor.this.fadeTransition, 1.0);
                    } else {
                        EditorUtils.fadeTo(PropertyEditor.this.fadeTransition, 0.0);
                    }
                }
            });
            this.menu.getItems().add((Object)this.resetvalueMenuItem);
            this.resetvalueMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    PropertyEditor.this.setValue(PropertyEditor.this.defaultValue);
                    PropertyEditor.this.userUpdateValueProperty(PropertyEditor.this.defaultValue);
                }
            });
        }
        return this.menu;
    }

    public void replaceMenuItem(MenuItem item, MenuItem newItem) {
        MenuButton cogMenu = this.getMenu();
        int index = cogMenu.getItems().indexOf((Object)item);
        cogMenu.getItems().set(index, (Object)newItem);
    }

    public void setPropertyMetadata(ValuePropertyMetadata propMeta) {
        this.propMeta = propMeta;
    }

    public void addValueListener(ChangeListener<Object> listener) {
        if (!this.valueListeners.contains(listener)) {
            this.valueProperty().addListener(listener);
            this.valueListeners.add(listener);
        }
    }

    public void removeValueListener(ChangeListener<Object> listener) {
        this.valueProperty().removeListener(listener);
        this.valueListeners.remove(listener);
    }

    public void addTransientValueListener(ChangeListener<Object> listener) {
        if (!this.transientValueListeners.contains(listener)) {
            this.transientValueProperty().addListener(listener);
            this.transientValueListeners.add(listener);
        }
    }

    public void removeTransientValueListener(ChangeListener<Object> listener) {
        this.transientValueProperty().removeListener(listener);
        this.transientValueListeners.remove(listener);
    }

    public void addEditingListener(ChangeListener<Boolean> listener) {
        if (!this.editingListeners.contains(listener)) {
            this.editingProperty().addListener(listener);
            this.editingListeners.add(listener);
        }
    }

    public void removeEditingListener(ChangeListener<Boolean> listener) {
        this.editingProperty().removeListener(listener);
        this.editingListeners.remove(listener);
    }

    public void addNavigateListener(ChangeListener<String> listener) {
        if (this.navigateRequestListener == null) {
            this.navigateRequestProperty.addListener(listener);
            this.navigateRequestListener = listener;
        }
    }

    public void removeNavigateListener(ChangeListener<String> listener) {
        this.navigateRequestProperty.removeListener(listener);
        this.navigateRequestListener = null;
    }

    @Override
    public void removeAllListeners() {
        HashSet<ChangeListener<Object>> valListeners = new HashSet<ChangeListener<Object>>(this.valueListeners);
        for (ChangeListener changeListener : valListeners) {
            this.removeValueListener((ChangeListener<Object>)changeListener);
        }
        HashSet<ChangeListener<Object>> transientValListeners = new HashSet<ChangeListener<Object>>(this.transientValueListeners);
        for (ChangeListener changeListener : transientValListeners) {
            this.removeTransientValueListener((ChangeListener<Object>)changeListener);
        }
        HashSet<ChangeListener<Boolean>> hashSet = new HashSet<ChangeListener<Boolean>>(this.editingListeners);
        for (ChangeListener changeListener : hashSet) {
            this.removeEditingListener((ChangeListener<Boolean>)changeListener);
        }
        this.removeNavigateListener(this.navigateRequestListener);
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    protected abstract void valueIsIndeterminate();

    public abstract void requestFocus();

    public void setValueGeneric(Object value) {
        if (!this.isUpdateFromModel()) {
            return;
        }
        this.invalidValueProperty.setValue(Boolean.valueOf(false));
        this.valueProperty.setValue(value);
        this.resetMenuUpdate(value);
        if (this.isRuledByCss()) {
            this.addCssVisual();
        } else {
            this.removeCssVisual();
        }
        if (!(value instanceof String)) {
            return;
        }
        String val = (String)value;
        if (PropertyEditor.isBindingExpression(val)) {
            this.binding = true;
        }
    }

    private void resetMenuUpdate(Object value) {
        if (value == null) {
            if (this.defaultValue == null) {
                this.resetvalueMenuItem.setDisable(true);
            }
        } else if (value.equals(this.defaultValue)) {
            this.resetvalueMenuItem.setDisable(true);
        } else {
            this.resetvalueMenuItem.setDisable(false);
        }
    }

    private void cssMenuUpdate() {
        if (!this.isRuledByCss()) {
            this.getMenu().getItems().remove((Object)this.showCssMenuItem);
            this.showCssMenuItem = null;
        }
    }

    protected boolean isSetValueDone() {
        boolean done = !this.isHandlingError() && (this.isBinding() || this.isEditing());
        return done;
    }

    public boolean isDisabled() {
        return this.disableProperty.getValue();
    }

    public void setDisable(boolean disabled) {
        this.disableProperty.setValue(Boolean.valueOf(disabled));
    }

    public ObservableBooleanValue disableProperty() {
        return this.disableProperty;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public boolean isIndeterminate() {
        return this.indeterminateProperty.getValue();
    }

    public void setIndeterminate(boolean indeterminate) {
        if (!this.indeterminateProperty.getValue().booleanValue() && indeterminate) {
            this.valueIsIndeterminate();
        }
        this.indeterminateProperty.setValue(Boolean.valueOf(indeterminate));
    }

    public boolean isRuledByCss() {
        return this.ruledByCss;
    }

    public void setRuledByCss(boolean ruledByCss) {
        this.ruledByCss = ruledByCss;
    }

    public void setCssInfo(CssInternal.CssPropAuthorInfo cssInfo) {
        this.cssInfo = cssInfo;
    }

    public boolean isUpdateFromModel() {
        return this.updateFromModel;
    }

    public void setUpdateFromModel(boolean updateFromModel) {
        this.updateFromModel = updateFromModel;
    }

    public boolean isEditing() {
        return this.editingProperty.getValue();
    }

    public boolean isInvalidValue() {
        return this.invalidValueProperty.getValue();
    }

    public boolean isHandlingError() {
        return this.handlingError;
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selClasses) {
        this.resetStates();
        this.propMeta = propMeta;
        this.setSelectedClasses(selClasses);
        this.setPropNamePrettyText();
        this.defaultValue = propMeta.getDefaultValueObject();
    }

    public void reset(String name, String defaultValue) {
        this.resetStates();
        this.propName.setText(name);
        this.defaultValue = defaultValue;
    }

    public ObjectProperty<Object> valueProperty() {
        return this.valueProperty;
    }

    public ObjectProperty<Object> transientValueProperty() {
        return this.transientValueProperty;
    }

    public LayoutFormat getLayoutFormat() {
        return this.layoutFormat;
    }

    public void setLayoutFormat(LayoutFormat layoutFormat) {
        this.layoutFormat = layoutFormat;
    }

    public void userUpdateValueProperty(Object value) {
        this.userUpdateValueProperty(value, false);
    }

    public void userUpdateTransientValueProperty(Object value) {
        this.userUpdateValueProperty(value, true);
    }

    private void userUpdateValueProperty(Object value, boolean transientValue) {
        if (!transientValue && !this.isValueChanged(value)) {
            return;
        }
        this.invalidValueProperty.setValue(Boolean.valueOf(false));
        this.indeterminateProperty.setValue(Boolean.valueOf(false));
        if (transientValue) {
            this.transientValueProperty.setValue(value);
        } else {
            this.valueProperty.setValue(value);
        }
        this.resetMenuUpdate(value);
    }

    boolean isValueChanged(Object value) {
        if (value == null || this.valueProperty.getValue() == null) {
            return value != this.valueProperty.getValue();
        }
        if (value instanceof List) {
            List valueList = (List)value;
            List valuePropertyList = (List)this.valueProperty.getValue();
            return this.isIndeterminate() || !Objects.equals(valueList, valuePropertyList);
        }
        return this.isIndeterminate() || !Objects.equals(value, this.valueProperty.getValue());
    }

    public BooleanProperty editingProperty() {
        return this.editingProperty;
    }

    public BooleanProperty indeterminateProperty() {
        return this.indeterminateProperty;
    }

    public BooleanProperty invalidValueProperty() {
        return this.invalidValueProperty;
    }

    public StringProperty navigateRequestProperty() {
        return this.navigateRequestProperty;
    }

    protected static Node getBindingValueEditor(Node valueEditor, String bindingExp) {
        TextField bindingTf = new TextField();
        bindingTf.setText(bindingExp);
        bindingTf.setEditable(false);
        HBox hbox = new HBox(5.0);
        EditorUtils.replaceNode(valueEditor, (Node)hbox, null);
        hbox.getChildren().addAll((Object[])new Node[]{new Label("${"), bindingTf, new Label("}")});
        return hbox;
    }

    protected static boolean isBindingExpression(String str) {
        return str.startsWith("${") && str.endsWith("}");
    }

    private void addCssVisual() {
        if (!this.propNameNode.getStyleClass().contains((Object)"css-override")) {
            ImageView iv = new ImageView(cssIcon);
            this.propName.setGraphic((Node)iv);
            this.propNameNode.getStyleClass().add((Object)"css-override");
            if (this.showCssMenuItem == null) {
                this.showCssMenuItem = new MenuItem(I18N.getString("inspector.css.showcss"));
                this.showCssMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        assert (PropertyEditor.this.cssInfo != null);
                        if (PropertyEditor.this.cssInfo.isInline()) {
                            PropertyEditor.this.navigateRequestProperty.setValue("style");
                            PropertyEditor.this.navigateRequestProperty.setValue(null);
                        } else if (PropertyEditor.this.cssInfo.getMainUrl() != null) {
                            try {
                                EditorPlatform.open(PropertyEditor.this.cssInfo.getMainUrl().toString());
                            }
                            catch (IOException ex) {
                                System.out.println(ex.getMessage() + ex);
                            }
                        }
                    }
                });
            }
            this.getMenu().getItems().add((Object)this.showCssMenuItem);
        }
    }

    private void removeCssVisual() {
        if (this.propNameNode.getStyleClass().contains((Object)"css-override")) {
            this.propName.setGraphic(null);
            this.propNameNode.getStyleClass().remove((Object)"css-override");
        }
        this.cssMenuUpdate();
    }

    protected Node handleGenericModes(Node valueEditor) {
        if (!this.genericModesHandled) {
            if (this.isBinding()) {
                assert (this.getValue() instanceof String);
                return PropertyEditor.getBindingValueEditor(valueEditor, (String)this.getValue());
            }
            if (this.isRuledByCss()) {
                this.addCssVisual();
            } else {
                this.removeCssVisual();
            }
            if (this.fadeTransition == null) {
                this.fadeTransition = new FadeTransition(Duration.millis((double)500.0), (Node)this.getMenu());
            }
            EditorUtils.handleFading(this.fadeTransition, valueEditor, this.disableProperty);
            this.genericModesHandled = true;
        }
        return valueEditor;
    }

    public ValuePropertyMetadata getPropertyMeta() {
        return this.propMeta;
    }

    protected void handleInvalidValue(Object value) {
        this.handleInvalidValue(value, null);
    }

    protected void handleInvalidValue(Object value, Node source) {
        if (this.isHandlingError()) {
            return;
        }
        this.invalidValueProperty.setValue(Boolean.valueOf(true));
        this.handlingError = true;
        if (source == null) {
            source = this.propName;
        }
        AlertDialog alertDialog = new AlertDialog(source.getScene().getWindow());
        alertDialog.setTitle(I18N.getString("inspector.error.title"));
        alertDialog.setMessage(I18N.getString("inspector.error.message"));
        alertDialog.setDetails(I18N.getString("inspector.error.details", value, this.getPropertyNameText()));
        alertDialog.setOKButtonVisible(true);
        alertDialog.setOKButtonTitle(I18N.getString("inspector.error.previousvalue"));
        alertDialog.setDefaultButtonID(AbstractModalDialog.ButtonID.CANCEL);
        alertDialog.setShowDefaultButton(true);
        alertDialog.setCancelButtonTitle(I18N.getString("inspector.error.cancel"));
        AbstractModalDialog.ButtonID buttonClicked = alertDialog.showAndWait();
        if (buttonClicked == AbstractModalDialog.ButtonID.OK) {
            this.setValue(this.valueProperty().getValue());
            this.invalidValueProperty.setValue(Boolean.valueOf(false));
        }
        alertDialog.getStage().close();
        this.requestFocus();
        this.handlingError = false;
    }

    private void resetStates() {
        this.disableProperty.setValue(Boolean.valueOf(false));
        this.binding = false;
        this.indeterminateProperty.setValue(Boolean.valueOf(false));
        this.ruledByCss = false;
        this.updateFromModel = true;
        this.editingProperty.setValue(Boolean.valueOf(false));
        this.invalidValueProperty.setValue(Boolean.valueOf(false));
        this.genericModesHandled = false;
        this.layoutFormat = DEFAULT_LAYOUT_FORMAT;
        this.cssInfo = null;
        this.removeCssVisual();
    }

    private void setSelectedClasses(Set<Class<?>> selClasses) {
        this.selectedClasses = selClasses;
        if (selClasses == null) {
            return;
        }
        if (selClasses.size() > 1) {
            this.propName.setMouseTransparent(true);
        } else {
            this.propName.setMouseTransparent(false);
        }
    }

    private void setPropNamePrettyText() {
        this.propName.setText(EditorUtils.toDisplayName(this.getPropertyName().getName()));
    }

    protected static void handleIndeterminate(Node node) {
        if (node instanceof TextField) {
            ((TextField)node).setText("");
            ((TextField)node).setPromptText("-");
        } else if (node instanceof ComboBox) {
            ((ComboBox)node).getEditor().setText("");
            ((ComboBox)node).setPromptText("-");
        } else if (node instanceof ChoiceBox) {
            ((ChoiceBox)node).getSelectionModel().clearSelection();
        } else if (node instanceof CheckBox) {
            ((CheckBox)node).setIndeterminate(true);
        } else if (node instanceof MenuButton) {
            ((MenuButton)node).setText("-");
        }
    }

    protected void setTextEditorBehavior(PropertyEditor editor, Control control, EventHandler<ActionEvent> onActionListener) {
        this.setTextEditorBehavior(editor, control, onActionListener, true);
    }

    protected void setTextEditorBehavior(Control control, EventHandler<ActionEvent> onActionListener) {
        this.setTextEditorBehavior(null, control, onActionListener, true, true);
    }

    protected void setTextEditorBehavior(PropertyEditor editor, Control control, EventHandler<ActionEvent> onActionListener, boolean stretchable) {
        this.setTextEditorBehavior(editor, control, onActionListener, stretchable, true);
    }

    protected void setTextEditorBehavior(Control control, EventHandler<ActionEvent> onActionListener, boolean addFocusListener) {
        this.setTextEditorBehavior(null, control, onActionListener, true, addFocusListener);
    }

    protected void setTextEditorBehavior(PropertyEditor editor, Control control, EventHandler<ActionEvent> onActionListener, boolean stretchable, boolean addFocusListener) {
        this.setCommitListener(onActionListener);
        if (stretchable) {
            EditorUtils.makeWidthStretchable((Node)control);
        }
        if (editor != null) {
            control.disableProperty().bind((ObservableValue)editor.disableProperty());
        }
        if (control instanceof TextField) {
            ((TextField)control).setOnAction(onActionListener);
        } else if (control instanceof ComboBoxBase) {
            ((ComboBoxBase)control).setOnAction(onActionListener);
        }
        if (addFocusListener && control instanceof TextInputControl) {
            this.addFocusListener((TextInputControl)control, onActionListener);
        }
    }

    public EventHandler<?> getCommitListener() {
        return this.commitListener;
    }

    protected void setCommitListener(EventHandler<?> listener) {
        this.commitListener = listener;
    }

    protected void setNumericEditorBehavior(PropertyEditor editor, Control control, EventHandler<ActionEvent> onActionListener) {
        this.setNumericEditorBehavior(editor, control, onActionListener, true);
    }

    protected void setNumericEditorBehavior(PropertyEditor editor, final Control control, EventHandler<ActionEvent> onActionListener, boolean stretchable) {
        this.setTextEditorBehavior(editor, control, onActionListener, stretchable);
        control.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                Double val;
                if (event.getCode() != KeyCode.UP && event.getCode() != KeyCode.DOWN) {
                    return;
                }
                if (!(control instanceof TextField)) {
                    return;
                }
                TextField textField = (TextField)control;
                int incDecVal = 1;
                boolean shiftDown = event.isShiftDown();
                if (shiftDown) {
                    incDecVal = 10;
                }
                String valStr = textField.getText();
                try {
                    val = Double.parseDouble(valStr);
                }
                catch (NumberFormatException ex) {
                    return;
                }
                assert (val != null);
                Double newVal = null;
                if (event.getCode() == KeyCode.UP) {
                    newVal = val + (double)incDecVal;
                } else if (event.getCode() == KeyCode.DOWN) {
                    newVal = val - (double)incDecVal;
                }
                textField.setText(EditorUtils.valAsStr(newVal));
                PropertyEditor.this.getCommitListener().handle(null);
                event.consume();
            }
        });
    }

    private void addFocusListener(final TextInputControl tic, EventHandler<ActionEvent> onActionListener) {
        tic.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && tic.isEditable()) {
                    PropertyEditor.this.editingProperty().setValue(Boolean.valueOf(false));
                } else if (newValue.booleanValue() && tic.isEditable()) {
                    PropertyEditor.this.editingProperty().setValue(Boolean.valueOf(true));
                }
            }
        });
    }

    public static enum LayoutFormat {
        SIMPLE_LINE_CENTERED,
        SIMPLE_LINE_BOTTOM,
        SIMPLE_LINE_TOP,
        SIMPLE_LINE_NO_NAME,
        DOUBLE_LINE;

    }
}

