/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItemDelegate;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InlineListEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.parser.CSSParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;

public class StyleEditor
extends InlineListEditor {
    private List<String> cssProperties;
    private Set<Class<?>> selectedClasses;
    private EditorController editorController;

    public StyleEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.selectedClasses = selectedClasses;
        this.editorController = editorController;
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        this.addItem(this.getNewStyleItem());
    }

    private StyleItem getNewStyleItem() {
        if (this.cssProperties == null) {
            this.cssProperties = CssInternal.getCssProperties(this.selectedClasses);
        }
        return new StyleItem(this, this.cssProperties);
    }

    @Override
    public void commit(EditorItem source) {
        try {
            this.userUpdateValueProperty(this.getValue());
        }
        catch (Exception ex) {
            this.editorController.getMessageLog().logWarningMessage("inspector.style.valuetypeerror", ex.getMessage());
        }
    }

    @Override
    public Object getValue() {
        String value = null;
        for (EditorItem styleItem : this.getEditorItems()) {
            String itemValue = styleItem.getValue();
            if (itemValue.isEmpty()) continue;
            if (value == null) {
                value = "";
            }
            assert (styleItem instanceof StyleItem);
            if (((StyleItem)styleItem).hasParsingError()) {
                this.editorController.getMessageLog().logWarningMessage("inspector.style.parsingerror", itemValue);
            }
            value = value + itemValue + " ";
        }
        if (value != null) {
            value = value.trim();
        }
        if (value == null) {
            return super.getPropertyMeta().getDefaultValueObject();
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.reset();
            return;
        }
        assert (value instanceof String);
        String[] itemArray = ((String)value).split(";");
        Iterator<EditorItem> itemsIter = new ArrayList<EditorItem>(this.getEditorItems()).iterator();
        for (String item : itemArray) {
            if ((item = item.trim()).isEmpty()) continue;
            EditorItem editorItem = itemsIter.hasNext() ? itemsIter.next() : this.addItem(this.getNewStyleItem());
            editorItem.setValue(item);
        }
        while (itemsIter.hasNext()) {
            EditorItem editorItem = itemsIter.next();
            this.removeItem(editorItem);
        }
    }

    @Override
    boolean isValueChanged(Object value) {
        if (value == null && this.valueProperty().getValue() != null || value != null && this.valueProperty().getValue() == null) {
            return true;
        }
        if (value != null) {
            String newNoSpace;
            assert (value instanceof String);
            assert (this.valueProperty().getValue() instanceof String);
            String oldNoSpace = ((String)this.valueProperty().getValue()).replaceAll("\\s", "");
            if (!oldNoSpace.equals(newNoSpace = ((String)value).replaceAll("\\s", ""))) {
                return true;
            }
        }
        return false;
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super.reset(propMeta, selectedClasses);
        this.selectedClasses = selectedClasses;
        this.editorController = editorController;
        this.cssProperties = null;
        this.addItem(this.getNewStyleItem());
    }

    @Override
    public void requestFocus() {
        EditorItem firstItem = this.getEditorItems().get(0);
        assert (firstItem instanceof StyleItem);
        ((StyleItem)firstItem).requestFocus();
    }

    private static class StyleableStub
    implements Styleable {
        private final String style;

        private StyleableStub(String style) {
            this.style = style;
        }

        public String getTypeSelector() {
            return null;
        }

        public String getId() {
            return null;
        }

        public ObservableList<String> getStyleClass() {
            return FXCollections.emptyObservableList();
        }

        public String getStyle() {
            return this.style;
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return Collections.emptyList();
        }

        public Styleable getStyleableParent() {
            return null;
        }

        public ObservableSet<PseudoClass> getPseudoClassStates() {
            return FXCollections.emptyObservableSet();
        }
    }

    private class StyleItem
    extends AutoSuggestEditor
    implements EditorItem {
        @FXML
        private Button plusBt;
        @FXML
        private MenuItem removeMi;
        @FXML
        private MenuItem moveUpMi;
        @FXML
        private MenuItem moveDownMi;
        @FXML
        private TextField valueTf;
        @FXML
        private StackPane propertySp;
        private final Parent root;
        private TextField propertyTf;
        private String currentValue;
        private final EditorItemDelegate editor;
        private boolean parsingError;
        private ListChangeListener<CssError> errorListener;

        public StyleItem(EditorItemDelegate editor, List<String> suggestedList) {
            super("", "", suggestedList, false);
            this.parsingError = false;
            this.editor = editor;
            this.root = EditorUtils.loadFxml("StyleEditorItem.fxml", (Object)this);
            this.initialize();
        }

        private void initialize() {
            this.propertySp.getChildren().add((Object)super.getRoot());
            this.propertyTf = super.getTextField();
            EventHandler<ActionEvent> onActionListener = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (StyleItem.this.getValue().equals(StyleItem.this.currentValue)) {
                        return;
                    }
                    if (!StyleItem.this.propertyTf.getText().isEmpty() && !StyleItem.this.valueTf.getText().isEmpty()) {
                        StyleItem.this.editor.commit(StyleItem.this);
                        if (event != null && event.getSource() instanceof TextField) {
                            ((TextField)event.getSource()).selectAll();
                        }
                    }
                    if (StyleItem.this.propertyTf.getText().isEmpty() && StyleItem.this.valueTf.getText().isEmpty()) {
                        StyleItem.this.remove(null);
                    }
                    StyleItem.this.updateButtons();
                    StyleItem.this.currentValue = StyleItem.this.getValue();
                }
            };
            ChangeListener<String> textPropertyChange = new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String prevText, String newText) {
                    if (prevText.isEmpty() || newText.isEmpty()) {
                        StyleItem.this.updateButtons();
                    }
                }
            };
            this.propertyTf.textProperty().addListener((ChangeListener)textPropertyChange);
            this.valueTf.textProperty().addListener((ChangeListener)textPropertyChange);
            this.updateButtons();
            this.setTextEditorBehavior((Control)this.propertyTf, onActionListener, false);
            this.setTextEditorBehavior((Control)this.valueTf, onActionListener, false);
            ChangeListener<Boolean> focusListener = new ChangeListener<Boolean>((EventHandler)onActionListener){
                final /* synthetic */ EventHandler val$onActionListener;
                {
                    this.val$onActionListener = eventHandler;
                }

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (!newValue.booleanValue()) {
                        StyleItem.this.editor.editing(false, this.val$onActionListener);
                    } else {
                        StyleItem.this.editor.editing(true, this.val$onActionListener);
                    }
                }
            };
            this.propertyTf.focusedProperty().addListener((ChangeListener)focusListener);
            this.valueTf.focusedProperty().addListener((ChangeListener)focusListener);
            this.removeMi.setText(I18N.getString("inspector.list.remove"));
            this.moveUpMi.setText(I18N.getString("inspector.list.moveup"));
            this.moveDownMi.setText(I18N.getString("inspector.list.movedown"));
            this.errorListener = new ListChangeListener<CssError>(){

                public void onChanged(ListChangeListener.Change<? extends CssError> change) {
                    block0: while (change.next()) {
                        if (!change.wasAdded()) continue;
                        for (CssError error : change.getAddedSubList()) {
                            if (!(error instanceof CssError.InlineStyleParsingError)) continue;
                            StyleItem.this.parsingError = true;
                            continue block0;
                        }
                    }
                }
            };
        }

        @Override
        public final Node getNode() {
            return this.root;
        }

        @Override
        public String getValue() {
            if (this.propertyTf.getText().isEmpty() && this.valueTf.getText().isEmpty()) {
                return "";
            }
            String propertyVal = EditorUtils.getPlainString(this.propertyTf.getText()).trim();
            String valueVal = EditorUtils.getPlainString(this.valueTf.getText()).trim();
            String value = propertyVal + ": " + valueVal + ";";
            this.parsingError = false;
            StyleManager.errorsProperty().addListener(this.errorListener);
            CSSParser.getInstance().parseInlineStyle((Styleable)new StyleableStub(value));
            StyleManager.errorsProperty().removeListener(this.errorListener);
            return value;
        }

        public boolean hasParsingError() {
            return this.parsingError;
        }

        @Override
        public void setValue(String style) {
            String propertyStr;
            if (style.endsWith(";")) {
                style = style.substring(0, style.length() - 1);
            }
            int dotIndex = style.indexOf(":");
            String valueStr = "";
            if (dotIndex != -1) {
                propertyStr = style.substring(0, dotIndex);
                valueStr = style.substring(dotIndex + 1);
            } else {
                propertyStr = style;
            }
            this.propertyTf.setText(propertyStr);
            this.valueTf.setText(valueStr);
            this.updateButtons();
            this.currentValue = this.getValue();
        }

        @Override
        public void reset() {
            this.propertyTf.setText("");
            this.valueTf.setText("");
            this.propertyTf.setPromptText(null);
            this.valueTf.setPromptText(null);
        }

        @Override
        public void requestFocus() {
            super.requestFocus();
        }

        @Override
        public void setValueAsIndeterminate() {
            StyleItem.handleIndeterminate((Node)this.propertyTf);
            StyleItem.handleIndeterminate((Node)this.valueTf);
        }

        @Override
        public MenuItem getMoveUpMenuItem() {
            return this.moveUpMi;
        }

        @Override
        public MenuItem getMoveDownMenuItem() {
            return this.moveDownMi;
        }

        @Override
        public MenuItem getRemoveMenuItem() {
            return this.removeMi;
        }

        @Override
        public Button getPlusButton() {
            return this.plusBt;
        }

        @FXML
        void add(ActionEvent event) {
            StyleItem styleItem = StyleEditor.this.getNewStyleItem();
            this.editor.add(this, styleItem);
            styleItem.requestFocus();
        }

        @FXML
        void remove(ActionEvent event) {
            this.editor.remove(this);
        }

        @FXML
        void up(ActionEvent event) {
            this.editor.up(this);
        }

        @FXML
        void down(ActionEvent event) {
            this.editor.down(this);
        }

        @FXML
        void plusBtTyped(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                StyleItem styleItem = StyleEditor.this.getNewStyleItem();
                this.editor.add(this, styleItem);
                styleItem.requestFocus();
            }
        }

        private void updateButtons() {
            if (this.propertyTf.getText().isEmpty() && this.valueTf.getText().isEmpty()) {
                this.plusBt.setDisable(true);
                this.removeMi.setDisable(false);
            } else if (!this.propertyTf.getText().isEmpty() && !this.valueTf.getText().isEmpty()) {
                this.plusBt.setDisable(false);
                this.removeMi.setDisable(false);
            } else if (!this.propertyTf.getText().isEmpty() || !this.valueTf.getText().isEmpty()) {
                this.plusBt.setDisable(true);
                this.removeMi.setDisable(false);
            }
        }

        protected void disablePlusButton(boolean disable) {
            this.plusBt.setDisable(disable);
        }

        protected void disableRemove(boolean disable) {
            this.removeMi.setDisable(disable);
        }
    }
}

