/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItemDelegate;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InlineListEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;

public class StylesheetEditor
extends InlineListEditor {
    private final StackPane root = new StackPane();
    private final Parent rootInitialBt;
    private final MenuItem documentRelativeMenuItem = new MenuItem(I18N.getString("inspector.resource.documentrelative"));
    private final MenuItem classPathRelativeMenuItem = new MenuItem(I18N.getString("inspector.resource.classpathrelative"));
    private final MenuItem absoluteMenuItem = new MenuItem(I18N.getString("inspector.resource.absolute"));
    private PrefixedValue.Type type;
    private URL fxmlFileLocation;

    public StylesheetEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, URL fxmlFileLocation) {
        super(propMeta, selectedClasses);
        this.fxmlFileLocation = fxmlFileLocation;
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        this.rootInitialBt = EditorUtils.loadFxml("StylesheetEditorInitialBt.fxml", (Object)this);
        this.root.getChildren().add((Object)this.rootInitialBt);
        this.valueProperty().setValue((Object)FXCollections.observableArrayList());
        this.documentRelativeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                StylesheetEditor.this.switchType(PrefixedValue.Type.DOCUMENT_RELATIVE_PATH);
            }
        });
        this.classPathRelativeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                StylesheetEditor.this.switchType(PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH);
            }
        });
        this.absoluteMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                StylesheetEditor.this.switchType(PrefixedValue.Type.PLAIN_STRING);
            }
        });
        this.getMenu().getItems().addAll((Object[])new MenuItem[]{this.documentRelativeMenuItem, this.classPathRelativeMenuItem, this.absoluteMenuItem});
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        ObservableList value = FXCollections.observableArrayList();
        for (EditorItem stylesheetItem : this.getEditorItems()) {
            String itemValue = stylesheetItem.getValue();
            if (itemValue.isEmpty()) continue;
            value.add(itemValue);
        }
        if (value.isEmpty()) {
            return super.getPropertyMeta().getDefaultValueObject();
        }
        this.type = this.getType((List<String>)value);
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (value == null) {
            this.reset();
            return;
        }
        assert (value instanceof List);
        if (((List)value).isEmpty()) {
            this.reset();
            return;
        }
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        this.type = this.getType((List)value);
        this.updateMenuItems();
        Iterator<EditorItem> itemsIter = new ArrayList<EditorItem>(this.getEditorItems()).iterator();
        for (String item : (List)value) {
            if ((item = item.trim()).isEmpty()) continue;
            EditorItem editorItem = itemsIter.hasNext() ? itemsIter.next() : this.addItem(new StylesheetItem(this, item));
            editorItem.setValue(item);
        }
        while (itemsIter.hasNext()) {
            EditorItem editorItem = itemsIter.next();
            this.removeItem(editorItem);
        }
        this.switchToItemList();
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, URL fxmlFileLocation) {
        super.reset(propMeta, selectedClasses, true);
        this.fxmlFileLocation = fxmlFileLocation;
        this.switchToInitialButton();
    }

    @Override
    protected void reset() {
        super.reset(true);
        this.switchToInitialButton();
    }

    @Override
    public void requestFocus() {
        EditorItem firstItem = this.getEditorItems().get(0);
        assert (firstItem instanceof StylesheetItem);
        ((StylesheetItem)firstItem).requestFocus();
    }

    @Override
    public void remove(EditorItem source) {
        super.remove(source, true);
        if (super.getEditorItems().isEmpty()) {
            this.switchToInitialButton();
        }
    }

    private void open(EditorItem source) {
        String urlStr = this.getUrl(source);
        if (urlStr == null) {
            return;
        }
        try {
            EditorPlatform.open(urlStr);
        }
        catch (IOException ex) {
            System.err.println(I18N.getString("inspector.stylesheet.cannotopen", urlStr + " : " + ex));
        }
    }

    private void reveal(EditorItem source) {
        String urlStr = this.getUrl(source);
        if (urlStr == null) {
            return;
        }
        try {
            File file = URLUtils.getFile(urlStr);
            if (file == null) {
                return;
            }
            EditorPlatform.revealInFileBrowser(file);
        }
        catch (IOException | URISyntaxException ex) {
            System.err.println(I18N.getString("inspector.stylesheet.cannotreveal", urlStr + " : " + ex));
        }
    }

    private String getUrl(EditorItem source) {
        URL url = EditorUtils.getUrl(source.getValue(), this.fxmlFileLocation);
        if (url == null) {
            return null;
        }
        String urlStr = url.toExternalForm();
        return urlStr;
    }

    @FXML
    void chooseStylesheet(ActionEvent event) {
        String urlStr;
        URL url;
        String[] extensions = new String[]{"*.css"};
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18N.getString("inspector.select.css.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("inspector.select.css.filter"), Arrays.asList(extensions)));
        File file = fileChooser.showOpenDialog(this.root.getScene().getWindow());
        if (file == null) {
            return;
        }
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Invalid URL", ex);
        }
        this.switchToItemList();
        if (this.fxmlFileLocation != null) {
            urlStr = PrefixedValue.makePrefixedValue(url, this.fxmlFileLocation).toString();
            this.switchType(PrefixedValue.Type.DOCUMENT_RELATIVE_PATH);
        } else {
            urlStr = url.toExternalForm();
            this.switchType(PrefixedValue.Type.PLAIN_STRING);
        }
        if (this.alreadyUsed(url.toExternalForm())) {
            System.err.println(I18N.getString("inspector.stylesheet.alreadyexist", url));
            return;
        }
        this.addItem(new StylesheetItem(this, urlStr));
        Deprecation.reapplyCSS(this.root.getScene());
        this.userUpdateValueProperty(this.getValue());
    }

    @FXML
    void buttonTyped(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.chooseStylesheet(null);
        }
    }

    private void switchToItemList() {
        if (this.root.getChildren().contains((Object)this.rootInitialBt)) {
            this.root.getChildren().remove((Object)this.rootInitialBt);
            this.root.getChildren().add((Object)super.getValueEditor());
        }
    }

    private void switchToInitialButton() {
        this.root.getChildren().clear();
        this.root.getChildren().add((Object)this.rootInitialBt);
    }

    private boolean alreadyUsed(String url) {
        for (EditorItem item : super.getEditorItems()) {
            if (!item.getValue().equals(url)) continue;
            return true;
        }
        return false;
    }

    private void switchType(PrefixedValue.Type type) {
        this.type = type;
        this.updateMenuItems();
        for (EditorItem editorItem : this.getEditorItems()) {
            assert (editorItem instanceof StylesheetItem);
            StylesheetItem stylesheetItem = (StylesheetItem)editorItem;
            URL url = EditorUtils.getUrl(stylesheetItem.getValue(), this.fxmlFileLocation);
            String value = null;
            if (url == null || type == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
                value = new PrefixedValue(type, "").toString();
            } else if (type == PrefixedValue.Type.PLAIN_STRING) {
                value = url.toExternalForm();
            } else if (type == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
                value = PrefixedValue.makePrefixedValue(url, this.fxmlFileLocation).toString();
            }
            stylesheetItem.setValue(value);
            this.commit(stylesheetItem);
        }
    }

    private PrefixedValue.Type getType(List<String> styleSheets) {
        PrefixedValue.Type commonType = null;
        for (String styleSheet : styleSheets) {
            if (commonType == null) {
                commonType = StylesheetEditor.getType(styleSheet);
                continue;
            }
            if (commonType == StylesheetEditor.getType(styleSheet)) continue;
            commonType = PrefixedValue.Type.DOCUMENT_RELATIVE_PATH;
            break;
        }
        return commonType;
    }

    private static PrefixedValue.Type getType(String styleSheet) {
        return new PrefixedValue(styleSheet).getType();
    }

    private void updateMenuItems() {
        this.documentRelativeMenuItem.setDisable(false);
        this.classPathRelativeMenuItem.setDisable(false);
        this.absoluteMenuItem.setDisable(false);
        if (this.fxmlFileLocation == null) {
            this.documentRelativeMenuItem.setDisable(true);
        }
        if (this.type == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
            this.documentRelativeMenuItem.setDisable(true);
        } else if (this.type == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
            this.classPathRelativeMenuItem.setDisable(true);
        } else if (this.type == PrefixedValue.Type.PLAIN_STRING) {
            this.absoluteMenuItem.setDisable(true);
        }
    }

    private class StylesheetItem
    implements EditorItem {
        @FXML
        private Button plusBt;
        @FXML
        private MenuItem removeMi;
        @FXML
        private MenuItem moveUpMi;
        @FXML
        private MenuItem moveDownMi;
        @FXML
        private MenuItem openMi;
        @FXML
        private MenuItem revealMi;
        @FXML
        private Label prefixLb;
        @FXML
        private TextField stylesheetTf;
        private final Pane root;
        private String currentValue;
        private final EditorItemDelegate editor;
        private PrefixedValue.Type itemType = PrefixedValue.Type.PLAIN_STRING;

        public StylesheetItem(EditorItemDelegate editor, String url) {
            this.editor = editor;
            Parent parentRoot = EditorUtils.loadFxml("StylesheetEditorItem.fxml", (Object)this);
            assert (parentRoot instanceof Pane);
            this.root = (Pane)parentRoot;
            this.initialize(url);
        }

        private void initialize(String url) {
            this.setValue(url);
            EventHandler<ActionEvent> onActionListener = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (StylesheetItem.this.getValue().equals(StylesheetItem.this.currentValue)) {
                        return;
                    }
                    if (StylesheetItem.this.stylesheetTf.getText().isEmpty()) {
                        StylesheetItem.this.remove(null);
                    }
                    StylesheetItem.this.editor.commit(StylesheetItem.this);
                    if (event != null && event.getSource() instanceof TextField) {
                        ((TextField)event.getSource()).selectAll();
                    }
                    StylesheetItem.this.updateButtons();
                    StylesheetItem.this.updateOpenRevealMenuItems();
                    StylesheetItem.this.currentValue = StylesheetItem.this.getValue();
                }
            };
            ChangeListener<String> textPropertyChange = new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String prevText, String newText) {
                    if (prevText.isEmpty() || newText.isEmpty()) {
                        StylesheetItem.this.updateButtons();
                        StylesheetItem.this.updateOpenRevealMenuItems();
                    }
                }
            };
            this.stylesheetTf.textProperty().addListener((ChangeListener)textPropertyChange);
            this.updateButtons();
            StylesheetEditor.this.setTextEditorBehavior((Control)this.stylesheetTf, onActionListener);
            this.removeMi.setText(I18N.getString("inspector.list.remove"));
            this.moveUpMi.setText(I18N.getString("inspector.list.moveup"));
            this.moveDownMi.setText(I18N.getString("inspector.list.movedown"));
        }

        @Override
        public final Node getNode() {
            return this.root;
        }

        @Override
        public String getValue() {
            if (this.stylesheetTf.getText().isEmpty()) {
                return "";
            }
            String suffix = this.stylesheetTf.getText().trim();
            return new PrefixedValue(this.itemType, suffix).toString();
        }

        @Override
        public void setValue(String styleSheet) {
            PrefixedValue prefixedValue = new PrefixedValue(styleSheet);
            this.itemType = prefixedValue.getType();
            this.handlePrefix(this.itemType);
            if (prefixedValue.getSuffix() != null) {
                this.stylesheetTf.setText(prefixedValue.getSuffix().trim());
            } else {
                this.stylesheetTf.setText("");
            }
            this.updateButtons();
            this.updateOpenRevealMenuItems();
            this.currentValue = this.getValue();
        }

        @Override
        public void reset() {
            this.stylesheetTf.setText("");
            this.stylesheetTf.setPromptText(null);
        }

        @Override
        public void setValueAsIndeterminate() {
            PropertyEditor.handleIndeterminate((Node)this.stylesheetTf);
        }

        protected void requestFocus() {
            EditorUtils.doNextFrame(new Runnable(){

                @Override
                public void run() {
                    StylesheetItem.this.stylesheetTf.requestFocus();
                }
            });
        }

        @Override
        public MenuItem getMoveUpMenuItem() {
            return this.moveUpMi;
        }

        @Override
        public MenuItem getMoveDownMenuItem() {
            return this.moveDownMi;
        }

        @Override
        public MenuItem getRemoveMenuItem() {
            return this.removeMi;
        }

        @Override
        public Button getPlusButton() {
            return this.plusBt;
        }

        @FXML
        void chooseStylesheet(ActionEvent event) {
            ((StylesheetEditor)this.editor).chooseStylesheet(event);
        }

        @FXML
        void remove(ActionEvent event) {
            this.editor.remove(this);
        }

        @FXML
        void up(ActionEvent event) {
            this.editor.up(this);
        }

        @FXML
        void down(ActionEvent event) {
            this.editor.down(this);
        }

        @FXML
        void open(ActionEvent event) {
            ((StylesheetEditor)this.editor).open(this);
        }

        @FXML
        void reveal(ActionEvent event) {
            ((StylesheetEditor)this.editor).reveal(this);
        }

        @FXML
        void plusBtTyped(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                this.chooseStylesheet(null);
            }
        }

        private void updateOpenRevealMenuItems() {
            String suffix = new PrefixedValue(this.getValue()).getSuffix();
            String fileName = null;
            if (!suffix.isEmpty()) {
                fileName = EditorUtils.getSimpleFileName(suffix);
            }
            if (fileName != null) {
                this.openMi.setVisible(true);
                this.revealMi.setVisible(true);
                this.openMi.setText(I18N.getString("inspector.list.open", fileName));
                if (EditorPlatform.IS_MAC) {
                    this.revealMi.setText(I18N.getString("inspector.list.reveal.finder", fileName));
                } else {
                    this.revealMi.setText(I18N.getString("inspector.list.reveal.explorer", fileName));
                }
            } else {
                this.openMi.setVisible(false);
                this.revealMi.setVisible(false);
            }
        }

        private void updateButtons() {
            if (this.stylesheetTf.getText().isEmpty()) {
                this.plusBt.setDisable(true);
                this.removeMi.setDisable(false);
            } else {
                this.plusBt.setDisable(false);
                this.removeMi.setDisable(false);
            }
        }

        protected void disablePlusButton(boolean disable) {
            this.plusBt.setDisable(disable);
        }

        protected void disableRemove(boolean disable) {
            this.removeMi.setDisable(disable);
        }

        protected void handlePrefix(PrefixedValue.Type type) {
            this.itemType = type;
            if (type == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
                this.setPrefix("@");
            } else if (type == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
                this.setPrefix("@/");
            } else {
                this.removeLabel();
            }
        }

        private void setPrefix(String str) {
            if (!this.prefixLb.isVisible()) {
                this.prefixLb.setVisible(true);
                this.prefixLb.setManaged(true);
            }
            this.prefixLb.setText(str);
        }

        private void removeLabel() {
            this.prefixLb.setVisible(false);
            this.prefixLb.setManaged(false);
        }
    }
}

