/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.TextAlignment;

public class TextAlignmentEditor
extends PropertyEditor {
    private final Parent root;
    @FXML
    private ToggleButton leftTb;
    @FXML
    private ToggleButton centerTb;
    @FXML
    private ToggleButton rightTb;
    @FXML
    private ToggleButton justifyTb;
    private final ToggleButton[] toggleButtons = new ToggleButton[4];

    public TextAlignmentEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.root = EditorUtils.loadFxml("TextAlignmentEditor.fxml", (Object)this);
        this.initialize();
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM);
    }

    private void initialize() {
        this.toggleButtons[0] = this.leftTb;
        this.toggleButtons[1] = this.centerTb;
        this.toggleButtons[2] = this.rightTb;
        this.toggleButtons[3] = this.justifyTb;
        for (ToggleButton tb : this.toggleButtons) {
            tb.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    TextAlignmentEditor.this.userUpdateValueProperty(TextAlignmentEditor.this.getValue());
                }
            });
            tb.disableProperty().bind((ObservableValue)this.disableProperty());
        }
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        for (ToggleButton tb : this.toggleButtons) {
            if (!tb.isSelected()) continue;
            if (tb.equals(this.leftTb)) {
                return TextAlignment.LEFT.toString();
            }
            if (tb.equals(this.centerTb)) {
                return TextAlignment.CENTER.toString();
            }
            if (tb.equals(this.rightTb)) {
                return TextAlignment.RIGHT.toString();
            }
            if (!tb.equals(this.justifyTb)) continue;
            return TextAlignment.JUSTIFY.toString();
        }
        return this.getPropertyMeta().getDefaultValueObject();
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            value = this.getPropertyMeta().getDefaultValueObject();
        }
        assert (value instanceof String);
        if (value.equals(TextAlignment.LEFT.toString())) {
            this.leftTb.setSelected(true);
        } else if (value.equals(TextAlignment.CENTER.toString())) {
            this.centerTb.setSelected(true);
        } else if (value.equals(TextAlignment.RIGHT.toString())) {
            this.rightTb.setSelected(true);
        } else if (value.equals(TextAlignment.JUSTIFY.toString())) {
            this.justifyTb.setSelected(true);
        }
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM);
    }

    @Override
    protected void valueIsIndeterminate() {
        for (ToggleButton tb : this.toggleButtons) {
            tb.setSelected(false);
        }
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(new Runnable(){

            @Override
            public void run() {
                TextAlignmentEditor.this.leftTb.requestFocus();
            }
        });
    }
}

