/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.transform.Transform;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public abstract class AbstractPopupController {
    private Parent root;
    private Popup popup;
    private Node anchor;
    private Window anchorWindow;
    private final EventHandler<WindowEvent> onHiddenHandler = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent e) {
            assert (AbstractPopupController.this.anchor != null);
            AbstractPopupController.this.onHidden(e);
            AbstractPopupController.this.anchor.layoutBoundsProperty().removeListener(AbstractPopupController.this.layoutBoundsListener);
            AbstractPopupController.this.anchor.localToSceneTransformProperty().removeListener(AbstractPopupController.this.localToSceneTransformListener);
            AbstractPopupController.this.anchorWindow.xProperty().removeListener(AbstractPopupController.this.xyListener);
            AbstractPopupController.this.anchor = null;
            AbstractPopupController.this.anchorWindow = null;
        }
    };
    private final ChangeListener<Bounds> layoutBoundsListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> ov, Bounds t, Bounds t1) {
            AbstractPopupController.this.anchorBoundsDidChange();
        }
    };
    private final ChangeListener<Transform> localToSceneTransformListener = new ChangeListener<Transform>(){

        public void changed(ObservableValue<? extends Transform> ov, Transform t, Transform t1) {
            AbstractPopupController.this.anchorTransformDidChange();
        }
    };
    private final ChangeListener<Number> xyListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            AbstractPopupController.this.anchorXYDidChange();
        }
    };

    public Parent getRoot() {
        if (this.root == null) {
            this.makeRoot();
            assert (this.root != null);
        }
        return this.root;
    }

    public Popup getPopup() {
        assert (Platform.isFxApplicationThread());
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.getContent().add((Object)this.getRoot());
            this.popup.setOnHidden(this.onHiddenHandler);
            this.controllerDidCreatePopup();
        }
        return this.popup;
    }

    public void openWindow(Node anchor) {
        assert (Platform.isFxApplicationThread());
        assert (anchor != null);
        assert (anchor.getScene() != null);
        assert (anchor.getScene().getWindow() != null);
        this.anchor = anchor;
        this.anchorWindow = anchor.getScene().getWindow();
        this.anchor.layoutBoundsProperty().addListener(this.layoutBoundsListener);
        this.anchor.localToSceneTransformProperty().addListener(this.localToSceneTransformListener);
        this.anchorWindow.xProperty().addListener(this.xyListener);
        this.getPopup().show(this.anchor.getScene().getWindow());
        this.anchorBoundsDidChange();
        this.updatePopupLocation();
    }

    public void closeWindow() {
        assert (Platform.isFxApplicationThread());
        this.getPopup().hide();
    }

    public boolean isWindowOpened() {
        return this.popup == null ? false : this.popup.isShowing();
    }

    public Node getAnchor() {
        return this.anchor;
    }

    protected abstract void makeRoot();

    protected abstract void onHidden(WindowEvent var1);

    protected abstract void anchorBoundsDidChange();

    protected abstract void anchorTransformDidChange();

    protected abstract void anchorXYDidChange();

    protected void controllerDidCreatePopup() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
    }

    protected abstract void updatePopupLocation();

    protected final void setRoot(Parent panelRoot) {
        assert (panelRoot != null);
        this.root = panelRoot;
    }
}

