/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public abstract class AbstractModalDialog
extends AbstractFxmlWindowController {
    private final Window owner;
    private final URL contentFxmlURL;
    private final ResourceBundle contentResources;
    private Parent contentRoot;
    private ButtonID clickedButtonID;
    private boolean showDefaultButton;
    private ButtonID defaultButtonID = ButtonID.OK;
    private boolean focusTraversableButtons;
    @FXML
    protected StackPane contentPane;
    @FXML
    protected Button okButton;
    @FXML
    protected Button cancelButton;
    @FXML
    protected Button actionButton;
    @FXML
    protected Pane okParent;
    @FXML
    protected Pane actionParent;
    @FXML
    protected ImageView imageView;
    @FXML
    protected Pane imageViewParent;

    public AbstractModalDialog(URL contentFxmlURL, ResourceBundle contentResources, Window owner) {
        super(AbstractModalDialog.getContainerFxmlURL(), I18N.getBundle());
        this.owner = owner;
        this.contentFxmlURL = contentFxmlURL;
        this.contentResources = contentResources;
        assert (contentFxmlURL != null);
    }

    public Parent getContentRoot() {
        if (this.contentRoot == null) {
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setLocation(this.contentFxmlURL);
            loader.setResources(this.contentResources);
            try {
                this.contentRoot = (Parent)loader.load();
                this.controllerDidLoadContentFxml();
            }
            catch (IOException x) {
                this.contentRoot = null;
                throw new RuntimeException("Failed to load " + this.contentFxmlURL.getFile(), x);
            }
        }
        return this.contentRoot;
    }

    public final ButtonID showAndWait() {
        this.clickedButtonID = ButtonID.CANCEL;
        this.getStage().showAndWait();
        return this.clickedButtonID;
    }

    public String getTitle() {
        return this.getStage().getTitle();
    }

    public void setTitle(String title) {
        this.getStage().setTitle(title);
    }

    public String getOKButtonTitle() {
        return this.getOKButton().getText();
    }

    public void setOKButtonTitle(String title) {
        this.getOKButton().setText(title);
    }

    public String getCancelButtonTitle() {
        return this.getCancelButton().getText();
    }

    public void setCancelButtonTitle(String title) {
        this.getCancelButton().setText(title);
    }

    public String getActionButtonTitle() {
        return this.getActionButton().getText();
    }

    public void setActionButtonTitle(String title) {
        this.getActionButton().setText(title);
    }

    public boolean isOKButtonVisible() {
        return this.getOKButton().getParent() != null;
    }

    public void setOKButtonVisible(boolean visible) {
        if (visible != this.isOKButtonVisible()) {
            if (visible) {
                assert (this.getOKButton().getParent() == null);
                this.getOKParent().getChildren().add((Object)this.getOKButton());
            } else {
                assert (this.getOKButton().getParent() == this.getOKParent());
                this.getOKParent().getChildren().remove((Object)this.getOKButton());
            }
        }
    }

    public boolean isActionButtonVisible() {
        return this.getActionButton().getParent() != null;
    }

    public void setActionButtonVisible(boolean visible) {
        if (visible != this.isActionButtonVisible()) {
            if (visible) {
                assert (this.getActionButton().getParent() == null);
                this.getActionParent().getChildren().add((Object)this.getActionButton());
            } else {
                assert (this.getActionButton().getParent() == this.getActionParent());
                this.getActionParent().getChildren().remove((Object)this.getActionButton());
            }
        }
    }

    public void setOKButtonDisable(boolean disable) {
        this.getOKButton().setDisable(disable);
    }

    public void setActionButtonDisable(boolean disable) {
        this.getActionButton().setDisable(disable);
    }

    public void setShowDefaultButton(boolean show) {
        this.showDefaultButton = show;
        this.updateButtonState();
    }

    public void setDefaultButtonID(ButtonID buttonID) {
        this.defaultButtonID = buttonID;
        this.updateButtonState();
    }

    public boolean isImageViewVisible() {
        return this.getImageView().getParent() != null;
    }

    public void setImageViewVisible(boolean visible) {
        if (visible != this.isImageViewVisible()) {
            if (visible) {
                assert (this.getImageView().getParent() == null);
                this.imageViewParent.getChildren().add((Object)this.getImageView());
            } else {
                assert (this.getImageView().getParent() == this.imageViewParent);
                this.imageViewParent.getChildren().remove((Object)this.getImageView());
            }
        }
    }

    public Image getImageViewImage() {
        return this.getImageView().getImage();
    }

    public void setImageViewImage(Image image) {
        this.getImageView().setImage(image);
    }

    public void setButtonsFocusTraversable() {
        if (EditorPlatform.IS_MAC) {
            this.getOKButton().setFocusTraversable(true);
            this.getCancelButton().setFocusTraversable(true);
            this.getActionButton().setFocusTraversable(true);
            this.focusTraversableButtons = true;
        }
    }

    protected abstract void controllerDidLoadContentFxml();

    @FXML
    protected abstract void okButtonPressed(ActionEvent var1);

    @FXML
    protected abstract void cancelButtonPressed(ActionEvent var1);

    @FXML
    protected abstract void actionButtonPressed(ActionEvent var1);

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner(this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.contentPane != null);
        assert (this.okButton != null);
        assert (this.cancelButton != null);
        assert (this.actionButton != null);
        assert (this.imageView != null);
        assert (this.okParent != null);
        assert (this.actionParent != null);
        assert (this.imageViewParent != null);
        assert (this.okButton.getParent() == this.okParent);
        assert (this.actionButton.getParent() == this.actionParent);
        assert (this.imageView.getParent() == this.imageViewParent);
        EventHandler<ActionEvent> callUpdateButtonID = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                AbstractModalDialog.this.updateButtonID(e);
            }
        };
        this.okButton.addEventHandler(ActionEvent.ACTION, (EventHandler)callUpdateButtonID);
        this.cancelButton.addEventHandler(ActionEvent.ACTION, (EventHandler)callUpdateButtonID);
        this.actionButton.addEventHandler(ActionEvent.ACTION, (EventHandler)callUpdateButtonID);
        this.contentPane.getChildren().add((Object)this.getContentRoot());
        this.setActionButtonVisible(false);
        this.setImageViewVisible(false);
        this.updateButtonState();
        this.getStage().sizeToScene();
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.cancelButtonPressed(null);
    }

    private static URL getContainerFxmlURL() {
        String fxmlName = EditorPlatform.IS_WINDOWS ? "AbstractModalDialogW.fxml" : "AbstractModalDialogM.fxml";
        return AbstractModalDialog.class.getResource(fxmlName);
    }

    private Button getOKButton() {
        this.getRoot();
        return this.okButton;
    }

    private Button getCancelButton() {
        this.getRoot();
        return this.cancelButton;
    }

    private Button getActionButton() {
        this.getRoot();
        return this.actionButton;
    }

    private Pane getOKParent() {
        this.getRoot();
        return this.okParent;
    }

    private Pane getActionParent() {
        this.getRoot();
        return this.actionParent;
    }

    private ImageView getImageView() {
        this.getRoot();
        return this.imageView;
    }

    private void updateButtonID(ActionEvent t) {
        assert (t != null);
        Object source = t.getSource();
        if (source == this.getCancelButton()) {
            this.clickedButtonID = ButtonID.CANCEL;
        } else if (source == this.getOKButton()) {
            this.clickedButtonID = ButtonID.OK;
        } else if (source == this.getActionButton()) {
            this.clickedButtonID = ButtonID.ACTION;
        } else {
            throw new IllegalArgumentException("Bug");
        }
    }

    private void updateButtonState() {
        this.getOKButton().setDefaultButton(false);
        this.getCancelButton().setDefaultButton(false);
        this.getActionButton().setDefaultButton(false);
        if (this.showDefaultButton) {
            switch (this.defaultButtonID) {
                case OK: {
                    if (EditorPlatform.IS_MAC && !this.focusTraversableButtons) {
                        this.getOKButton().setDefaultButton(true);
                        break;
                    }
                    this.getOKButton().requestFocus();
                    break;
                }
                case CANCEL: {
                    if (EditorPlatform.IS_MAC && !this.focusTraversableButtons) {
                        this.getCancelButton().setDefaultButton(true);
                        break;
                    }
                    this.getCancelButton().requestFocus();
                    break;
                }
                case ACTION: {
                    if (EditorPlatform.IS_MAC && !this.focusTraversableButtons) {
                        this.getActionButton().setDefaultButton(true);
                        break;
                    }
                    this.getActionButton().requestFocus();
                }
            }
        }
    }

    public static enum ButtonID {
        OK,
        CANCEL,
        ACTION;

    }
}

