/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.report;

import com.sun.javafx.css.CssError;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.parser.CSSParser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CSSParsingReport {
    private final Path stylesheetPath;
    private IOException ioException;
    private final List<CssError> cssErrors = new ArrayList<CssError>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSParsingReport(Path stylesheetPath) {
        assert (stylesheetPath != null);
        this.stylesheetPath = stylesheetPath;
        HashSet previousErrors = new HashSet(StyleManager.errorsProperty());
        try {
            CSSParser.getInstance().parse(stylesheetPath.toUri().toURL());
            this.cssErrors.addAll((Collection<CssError>)StyleManager.errorsProperty());
            this.cssErrors.removeAll(previousErrors);
        }
        catch (IOException x) {
            this.ioException = x;
        }
        finally {
            StyleManager.errorsProperty().removeAll(this.cssErrors);
        }
    }

    public Path getStylesheetPath() {
        return this.stylesheetPath;
    }

    public boolean isEmpty() {
        return this.ioException == null && this.cssErrors.isEmpty();
    }

    public IOException getIOException() {
        return this.ioException;
    }

    public List<CssError> getCssErrors() {
        return Collections.unmodifiableList(this.cssErrors);
    }
}

