/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.search;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlController;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class SearchController
extends AbstractFxmlController {
    @FXML
    private TextField searchField;
    @FXML
    private StackPane searchIcon;

    public SearchController(EditorController c) {
        super(SearchController.class.getResource("Search.fxml"), c);
    }

    public final StringProperty textProperty() {
        return this.searchField.textProperty();
    }

    public void requestFocus() {
        this.searchField.requestFocus();
    }

    @Override
    protected void controllerDidLoadFxml() {
        if (this.searchField.getLength() == 0) {
            this.searchIcon.getStyleClass().add((Object)"search-magnifying-glass");
        }
        this.searchField.setId("Search Text");
        this.searchField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldStr, String newStr) {
                if (newStr.isEmpty()) {
                    SearchController.this.searchIcon.getStyleClass().clear();
                    SearchController.this.searchIcon.getStyleClass().add((Object)"search-magnifying-glass");
                } else {
                    SearchController.this.searchIcon.getStyleClass().clear();
                    SearchController.this.searchIcon.getStyleClass().add((Object)"search-clear");
                }
            }
        });
        this.searchField.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    SearchController.this.searchField.clear();
                }
            }
        });
        this.searchIcon.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                SearchController.this.searchField.clear();
            }
        });
    }
}

