/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.GridPane;
import javafx.stage.WindowEvent;

public class ContextMenuController {
    private final EditorController editorController;
    private ContextMenu contextMenu;
    private MenuItem cutMenuItem;
    private MenuItem copyMenuItem;
    private MenuItem pasteMenuItem;
    private MenuItem pasteIntoMenuItem;
    private MenuItem duplicateMenuItem;
    private MenuItem deleteMenuItem;
    private MenuItem selectParentMenuItem;
    private MenuItem fitToParentMenuItem;
    private MenuItem useComputedSizesMenuItem;
    private MenuItem editIncludedFileMenuItem;
    private MenuItem revealIncludedFileMenuItem;
    private MenuItem bringToFrontMenuItem;
    private MenuItem sendToBackMenuItem;
    private MenuItem bringForwardMenuItem;
    private MenuItem sendBackwardMenuItem;
    private Menu wrapInMenu;
    private MenuItem wrapInAnchorPaneMenuItem;
    private MenuItem wrapInGridPaneMenuItem;
    private MenuItem wrapInGroupMenuItem;
    private MenuItem wrapInHBoxMenuItem;
    private MenuItem wrapInPaneMenuItem;
    private MenuItem wrapInScrollPaneMenuItem;
    private MenuItem wrapInSplitPaneMenuItem;
    private MenuItem wrapInStackPaneMenuItem;
    private MenuItem wrapInTabPaneMenuItem;
    private MenuItem wrapInTitledPaneMenuItem;
    private MenuItem wrapInToolBarMenuItem;
    private MenuItem wrapInVBoxMenuItem;
    private MenuItem unwrapMenuItem;
    private Menu gridPaneMenu;
    private MenuItem moveRowAboveMenuItem;
    private MenuItem moveRowBelowMenuItem;
    private MenuItem moveColumnBeforeMenuItem;
    private MenuItem moveColumnAfterMenuItem;
    private MenuItem addRowAboveMenuItem;
    private MenuItem addRowBelowMenuItem;
    private MenuItem addColumnBeforeMenuItem;
    private MenuItem addColumnAfterMenuItem;
    private MenuItem increaseRowSpan;
    private MenuItem decreaseRowSpan;
    private MenuItem increaseColumnSpan;
    private MenuItem decreaseColumnSpan;
    private final EventHandler<Event> onShowingMenuEventHandler = new EventHandler<Event>(){

        public void handle(Event t) {
            assert (t.getSource() instanceof Menu);
            Menu menu = (Menu)t.getSource();
            ContextMenuController.this.handleOnShowing((ObservableList<MenuItem>)menu.getItems());
        }
    };
    private final EventHandler<WindowEvent> onShowingContextMenuEventHandler = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent t) {
            assert (t.getSource() instanceof ContextMenu);
            ContextMenu contextMenu = (ContextMenu)t.getSource();
            ContextMenuController.this.handleOnShowing((ObservableList<MenuItem>)contextMenu.getItems());
        }
    };
    private final EventHandler<ActionEvent> onActionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent t) {
            assert (t.getSource() instanceof MenuItem);
            ContextMenuController.this.handleOnActionMenu((MenuItem)t.getSource());
        }
    };
    private final ChangeListener<Number> jobManagerRevisionListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            ContextMenuController.this.jobManagerRevisionDidChange();
        }
    };

    public ContextMenuController(EditorController editorController) {
        this.editorController = editorController;
        this.editorController.getJobManager().revisionProperty().addListener(this.jobManagerRevisionListener);
    }

    public ContextMenu getContextMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu();
            this.contextMenu.setConsumeAutoHidingEvents(false);
            this.contextMenu.setOnShowing(this.onShowingContextMenuEventHandler);
        }
        return this.contextMenu;
    }

    public void updateContextMenuItems() {
        if (this.copyMenuItem == null) {
            this.initializeMenuItems();
        }
        this.getContextMenu().getItems().clear();
        Selection selection = this.editorController.getSelection();
        if (!selection.isEmpty()) {
            AbstractSelectionGroup asg = selection.getGroup();
            if (asg instanceof ObjectSelectionGroup) {
                this.getContextMenu().getItems().addAll((Object[])new MenuItem[]{this.cutMenuItem, this.copyMenuItem, this.pasteMenuItem, this.pasteIntoMenuItem, this.duplicateMenuItem, this.deleteMenuItem, new SeparatorMenuItem(), this.selectParentMenuItem, new SeparatorMenuItem(), this.fitToParentMenuItem, this.useComputedSizesMenuItem});
                if (this.canPerformGridPaneActions() || this.canPerformGridPaneChildActions()) {
                    this.updateGridPaneMenuItems();
                    this.getContextMenu().getItems().add((Object)this.gridPaneMenu);
                }
                this.getContextMenu().getItems().addAll((Object[])new MenuItem[]{this.editIncludedFileMenuItem, this.revealIncludedFileMenuItem, new SeparatorMenuItem(), this.bringToFrontMenuItem, this.sendToBackMenuItem, this.bringForwardMenuItem, this.sendBackwardMenuItem, new SeparatorMenuItem(), this.wrapInMenu, this.unwrapMenuItem});
            } else {
                assert (asg instanceof GridSelectionGroup);
                this.getContextMenu().getItems().addAll((Object[])new MenuItem[]{this.deleteMenuItem, new SeparatorMenuItem(), this.moveRowAboveMenuItem, this.moveRowBelowMenuItem, this.moveColumnBeforeMenuItem, this.moveColumnAfterMenuItem, new SeparatorMenuItem(), this.addRowAboveMenuItem, this.addRowBelowMenuItem, this.addColumnBeforeMenuItem, this.addColumnAfterMenuItem});
            }
        }
    }

    private void handleOnShowing(ObservableList<MenuItem> menuItems) {
        for (MenuItem menuItem : menuItems) {
            boolean selected;
            String title;
            boolean disable;
            if (menuItem.getUserData() instanceof MenuItemController) {
                MenuItemController c = (MenuItemController)menuItem.getUserData();
                disable = !c.canPerform();
                title = c.getTitle();
                selected = c.isSelected();
            } else if (menuItem instanceof Menu) {
                disable = false;
                selected = false;
                title = null;
            } else {
                disable = true;
                selected = false;
                title = null;
            }
            menuItem.setDisable(disable);
            if (title != null) {
                menuItem.setText(title);
            }
            if (!(menuItem instanceof RadioMenuItem)) continue;
            RadioMenuItem ri = (RadioMenuItem)menuItem;
            ri.setSelected(selected);
        }
    }

    private void handleOnActionMenu(MenuItem i) {
        assert (i.getUserData() instanceof MenuItemController);
        MenuItemController c = (MenuItemController)i.getUserData();
        c.perform();
    }

    private void jobManagerRevisionDidChange() {
        if (this.contextMenu != null && this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    private boolean canPerformGridPaneActions() {
        boolean result = false;
        Selection selection = this.editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            result = true;
            for (FXOMObject obj : osg.getItems()) {
                if (obj.getSceneGraphObject() instanceof GridPane) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean canPerformGridPaneChildActions() {
        boolean result = false;
        Selection selection = this.editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            result = true;
            for (FXOMObject obj : osg.getItems()) {
                FXOMObject parent = obj.getParentObject();
                if (parent != null && parent.getSceneGraphObject() instanceof GridPane) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private void updateGridPaneMenuItems() {
        assert (this.canPerformGridPaneActions() || this.canPerformGridPaneChildActions());
        this.gridPaneMenu.getItems().clear();
        if (this.canPerformGridPaneActions()) {
            this.gridPaneMenu.getItems().addAll((Object[])new MenuItem[]{this.moveRowAboveMenuItem, this.moveRowBelowMenuItem, this.moveColumnBeforeMenuItem, this.moveColumnAfterMenuItem, new SeparatorMenuItem(), this.addRowAboveMenuItem, this.addRowBelowMenuItem, this.addColumnBeforeMenuItem, this.addColumnAfterMenuItem});
        }
        if (this.canPerformGridPaneChildActions()) {
            if (!this.gridPaneMenu.getItems().isEmpty()) {
                this.gridPaneMenu.getItems().add((Object)new SeparatorMenuItem());
            }
            this.gridPaneMenu.getItems().addAll((Object[])new MenuItem[]{this.increaseRowSpan, this.decreaseRowSpan, this.increaseColumnSpan, this.decreaseColumnSpan});
        }
    }

    private void initializeMenuItems() {
        this.copyMenuItem = new MenuItem(I18N.getString("menu.title.copy"));
        this.copyMenuItem.setOnAction(this.onActionEventHandler);
        this.copyMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.COPY));
        this.selectParentMenuItem = new MenuItem(I18N.getString("menu.title.select.parent"));
        this.selectParentMenuItem.setOnAction(this.onActionEventHandler);
        this.selectParentMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_PARENT));
        this.editIncludedFileMenuItem = new MenuItem(I18N.getString("menu.title.edit.included.default"));
        this.editIncludedFileMenuItem.setOnAction(this.onActionEventHandler);
        this.editIncludedFileMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.EDIT_INCLUDED_FILE));
        this.revealIncludedFileMenuItem = new MenuItem(I18N.getString("menu.title.reveal.included.default"));
        this.revealIncludedFileMenuItem.setOnAction(this.onActionEventHandler);
        this.revealIncludedFileMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.REVEAL_INCLUDED_FILE));
        this.cutMenuItem = new MenuItem(I18N.getString("menu.title.cut"));
        this.cutMenuItem.setOnAction(this.onActionEventHandler);
        this.cutMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.CUT));
        this.pasteMenuItem = new MenuItem(I18N.getString("menu.title.paste"));
        this.pasteMenuItem.setOnAction(this.onActionEventHandler);
        this.pasteMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.PASTE));
        this.pasteIntoMenuItem = new MenuItem(I18N.getString("menu.title.paste.into"));
        this.pasteIntoMenuItem.setOnAction(this.onActionEventHandler);
        this.pasteIntoMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.PASTE_INTO));
        this.duplicateMenuItem = new MenuItem(I18N.getString("menu.title.duplicate"));
        this.duplicateMenuItem.setOnAction(this.onActionEventHandler);
        this.duplicateMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DUPLICATE));
        this.deleteMenuItem = new MenuItem(I18N.getString("menu.title.delete"));
        this.deleteMenuItem.setOnAction(this.onActionEventHandler);
        this.deleteMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DELETE));
        this.fitToParentMenuItem = new MenuItem(I18N.getString("menu.title.fit"));
        this.fitToParentMenuItem.setOnAction(this.onActionEventHandler);
        this.fitToParentMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.FIT_TO_PARENT));
        this.useComputedSizesMenuItem = new MenuItem(I18N.getString("menu.title.use.computed.sizes"));
        this.useComputedSizesMenuItem.setOnAction(this.onActionEventHandler);
        this.useComputedSizesMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.USE_COMPUTED_SIZES));
        this.bringToFrontMenuItem = new MenuItem(I18N.getString("menu.title.front"));
        this.bringToFrontMenuItem.setOnAction(this.onActionEventHandler);
        this.bringToFrontMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.BRING_TO_FRONT));
        this.sendToBackMenuItem = new MenuItem(I18N.getString("menu.title.back"));
        this.sendToBackMenuItem.setOnAction(this.onActionEventHandler);
        this.sendToBackMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SEND_TO_BACK));
        this.bringForwardMenuItem = new MenuItem(I18N.getString("menu.title.forward"));
        this.bringForwardMenuItem.setOnAction(this.onActionEventHandler);
        this.bringForwardMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.BRING_FORWARD));
        this.sendBackwardMenuItem = new MenuItem(I18N.getString("menu.title.backward"));
        this.sendBackwardMenuItem.setOnAction(this.onActionEventHandler);
        this.sendBackwardMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SEND_BACKWARD));
        this.wrapInMenu = new Menu(I18N.getString("menu.title.wrap"));
        this.wrapInAnchorPaneMenuItem = new MenuItem("AnchorPane");
        this.wrapInAnchorPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInAnchorPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_ANCHOR_PANE));
        this.wrapInGridPaneMenuItem = new MenuItem("GridPane");
        this.wrapInGridPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInGridPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GRID_PANE));
        this.wrapInHBoxMenuItem = new MenuItem("HBox");
        this.wrapInHBoxMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInHBoxMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_HBOX));
        this.wrapInPaneMenuItem = new MenuItem("Pane");
        this.wrapInPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_PANE));
        this.wrapInScrollPaneMenuItem = new MenuItem("ScrollPane");
        this.wrapInScrollPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInScrollPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SCROLL_PANE));
        this.wrapInSplitPaneMenuItem = new MenuItem("SplitPane");
        this.wrapInSplitPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInSplitPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SPLIT_PANE));
        this.wrapInStackPaneMenuItem = new MenuItem("StackPane");
        this.wrapInStackPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInStackPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_STACK_PANE));
        this.wrapInTabPaneMenuItem = new MenuItem("TabPane");
        this.wrapInTabPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInTabPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TAB_PANE));
        this.wrapInTitledPaneMenuItem = new MenuItem("TitledPane");
        this.wrapInTitledPaneMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInTitledPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TITLED_PANE));
        this.wrapInToolBarMenuItem = new MenuItem("ToolBar");
        this.wrapInToolBarMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInToolBarMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TOOL_BAR));
        this.wrapInVBoxMenuItem = new MenuItem("VBox");
        this.wrapInVBoxMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInVBoxMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_VBOX));
        this.wrapInGroupMenuItem = new MenuItem("Group");
        this.wrapInGroupMenuItem.setOnAction(this.onActionEventHandler);
        this.wrapInGroupMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GROUP));
        this.wrapInMenu.getItems().setAll((Object[])new MenuItem[]{this.wrapInAnchorPaneMenuItem, this.wrapInGridPaneMenuItem, this.wrapInGroupMenuItem, this.wrapInHBoxMenuItem, this.wrapInPaneMenuItem, this.wrapInScrollPaneMenuItem, this.wrapInSplitPaneMenuItem, this.wrapInStackPaneMenuItem, this.wrapInTabPaneMenuItem, this.wrapInTitledPaneMenuItem, this.wrapInToolBarMenuItem, this.wrapInVBoxMenuItem});
        this.unwrapMenuItem = new MenuItem(I18N.getString("menu.title.unwrap"));
        this.unwrapMenuItem.setOnAction(this.onActionEventHandler);
        this.unwrapMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.UNWRAP));
        this.gridPaneMenu = new Menu(I18N.getString("menu.title.grid"));
        this.moveRowAboveMenuItem = new MenuItem(I18N.getString("menu.title.grid.move.row.above"));
        this.moveRowAboveMenuItem.setOnAction(this.onActionEventHandler);
        this.moveRowAboveMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_ROW_ABOVE));
        this.moveRowBelowMenuItem = new MenuItem(I18N.getString("menu.title.grid.move.row.below"));
        this.moveRowBelowMenuItem.setOnAction(this.onActionEventHandler);
        this.moveRowBelowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_ROW_BELOW));
        this.moveColumnBeforeMenuItem = new MenuItem(I18N.getString("menu.title.grid.move.column.before"));
        this.moveColumnBeforeMenuItem.setOnAction(this.onActionEventHandler);
        this.moveColumnBeforeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_COLUMN_BEFORE));
        this.moveColumnAfterMenuItem = new MenuItem(I18N.getString("menu.title.grid.move.column.after"));
        this.moveColumnAfterMenuItem.setOnAction(this.onActionEventHandler);
        this.moveColumnAfterMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_COLUMN_AFTER));
        this.addRowAboveMenuItem = new MenuItem(I18N.getString("menu.title.grid.add.row.above"));
        this.addRowAboveMenuItem.setOnAction(this.onActionEventHandler);
        this.addRowAboveMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_ROW_ABOVE));
        this.addRowBelowMenuItem = new MenuItem(I18N.getString("menu.title.grid.add.row.below"));
        this.addRowBelowMenuItem.setOnAction(this.onActionEventHandler);
        this.addRowBelowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_ROW_BELOW));
        this.addColumnBeforeMenuItem = new MenuItem(I18N.getString("menu.title.grid.add.column.before"));
        this.addColumnBeforeMenuItem.setOnAction(this.onActionEventHandler);
        this.addColumnBeforeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_COLUMN_BEFORE));
        this.addColumnAfterMenuItem = new MenuItem(I18N.getString("menu.title.grid.add.column.after"));
        this.addColumnAfterMenuItem.setOnAction(this.onActionEventHandler);
        this.addColumnAfterMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_COLUMN_AFTER));
        this.increaseRowSpan = new MenuItem(I18N.getString("menu.title.grid.increase.row.span"));
        this.increaseRowSpan.setOnAction(this.onActionEventHandler);
        this.increaseRowSpan.setUserData((Object)new EditActionController(EditorController.EditAction.INCREASE_ROW_SPAN));
        this.decreaseRowSpan = new MenuItem(I18N.getString("menu.title.grid.decrease.row.span"));
        this.decreaseRowSpan.setOnAction(this.onActionEventHandler);
        this.decreaseRowSpan.setUserData((Object)new EditActionController(EditorController.EditAction.DECREASE_ROW_SPAN));
        this.increaseColumnSpan = new MenuItem(I18N.getString("menu.title.grid.increase.column.span"));
        this.increaseColumnSpan.setOnAction(this.onActionEventHandler);
        this.increaseColumnSpan.setUserData((Object)new EditActionController(EditorController.EditAction.INCREASE_COLUMN_SPAN));
        this.decreaseColumnSpan = new MenuItem(I18N.getString("menu.title.grid.decrease.column.span"));
        this.decreaseColumnSpan.setOnAction(this.onActionEventHandler);
        this.decreaseColumnSpan.setUserData((Object)new EditActionController(EditorController.EditAction.DECREASE_COLUMN_SPAN));
        this.wrapInMenu.setOnShowing(this.onShowingMenuEventHandler);
        this.gridPaneMenu.setOnShowing(this.onShowingMenuEventHandler);
    }

    abstract class MenuItemController {
        MenuItemController() {
        }

        public abstract boolean canPerform();

        public abstract void perform();

        public String getTitle() {
            return null;
        }

        public boolean isSelected() {
            return false;
        }
    }

    class ControlActionController
    extends MenuItemController {
        private final EditorController.ControlAction controlAction;

        public ControlActionController(EditorController.ControlAction controlAction) {
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = ContextMenuController.this.editorController.getFxomDocument() == null ? false : ContextMenuController.this.editorController.canPerformControlAction(this.controlAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "controlAction=" + (Object)((Object)this.controlAction);
            ContextMenuController.this.editorController.performControlAction(this.controlAction);
        }
    }

    class EditActionController
    extends MenuItemController {
        private final EditorController.EditAction editAction;

        public EditActionController(EditorController.EditAction editAction) {
            this.editAction = editAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = ContextMenuController.this.editorController.getFxomDocument() == null ? false : ContextMenuController.this.editorController.canPerformEditAction(this.editAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "editAction=" + (Object)((Object)this.editAction);
            ContextMenuController.this.editorController.performEditAction(this.editAction);
        }
    }
}

