/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMLoader;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNormalizer;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMRefresher;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMSaver;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.sampledata.SampleDataGenerator;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;

public class FXOMDocument {
    private final GlueDocument glue;
    private URL location;
    private ClassLoader classLoader;
    private ResourceBundle resources;
    private SampleDataGenerator sampleDataGenerator;
    private FXOMObject fxomRoot;
    private Object sceneGraphRoot;
    private final SimpleIntegerProperty sceneGraphRevision = new SimpleIntegerProperty();
    private final SimpleIntegerProperty cssRevision = new SimpleIntegerProperty();
    private SceneGraphHolder sceneGraphHolder;
    private int updateDepth;

    public FXOMDocument(String fxmlText, URL location, ClassLoader classLoader, ResourceBundle resources, boolean normalize) throws IOException {
        this.glue = new GlueDocument(fxmlText);
        this.location = location;
        this.classLoader = classLoader;
        this.resources = resources;
        if (this.glue.getRootElement() != null) {
            FXOMLoader loader = new FXOMLoader(this);
            loader.load(fxmlText);
            if (normalize) {
                FXOMNormalizer normalizer = new FXOMNormalizer(this);
                normalizer.normalize();
            }
        } else assert (GlueDocument.isEmptyXmlText(fxmlText));
    }

    public FXOMDocument(String fxmlText, URL location, ClassLoader classLoader, ResourceBundle resources) throws IOException {
        this(fxmlText, location, classLoader, resources, true);
    }

    public FXOMDocument() {
        this.glue = new GlueDocument();
    }

    public GlueDocument getGlue() {
        return this.glue;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL location) {
        if (!URLUtils.equals(this.location, location)) {
            this.beginUpdate();
            if (this.fxomRoot != null) {
                this.fxomRoot.documentLocationWillChange(location);
            }
            this.location = location;
            this.endUpdate();
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.beginUpdate();
        this.classLoader = classLoader;
        this.endUpdate();
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public void setResources(ResourceBundle resources) {
        this.beginUpdate();
        this.resources = resources;
        this.endUpdate();
    }

    public boolean isSampleDataEnabled() {
        return this.sampleDataGenerator != null;
    }

    public void setSampleDataEnabled(boolean sampleDataEnabled) {
        assert (!this.isUpdateOnGoing());
        SampleDataGenerator newSampleDataGenerator = sampleDataEnabled ? (this.sampleDataGenerator != null ? this.sampleDataGenerator : new SampleDataGenerator()) : null;
        if (newSampleDataGenerator != this.sampleDataGenerator) {
            if (this.sampleDataGenerator != null) {
                this.sampleDataGenerator.removeSampleData(this.fxomRoot);
            }
            this.sampleDataGenerator = newSampleDataGenerator;
            if (this.sampleDataGenerator != null) {
                this.sampleDataGenerator.assignSampleData(this.fxomRoot);
            }
        }
    }

    public FXOMObject getFxomRoot() {
        return this.fxomRoot;
    }

    public void setFxomRoot(FXOMObject fxomRoot) {
        this.beginUpdate();
        this.updateRoots(fxomRoot, null);
        this.endUpdate();
    }

    void updateRoots(FXOMObject fxomRoot, Object sceneGraphRoot) {
        assert (fxomRoot == null || fxomRoot.getFxomDocument() == this);
        this.fxomRoot = fxomRoot;
        if (this.fxomRoot == null) {
            this.glue.setRootElement(null);
        } else {
            this.glue.setRootElement(this.fxomRoot.getGlueElement());
        }
        this.sceneGraphRoot = sceneGraphRoot;
    }

    public Object getSceneGraphRoot() {
        return this.sceneGraphRoot;
    }

    void setSceneGraphRoot(Object sceneGraphRoot) {
        this.sceneGraphRoot = sceneGraphRoot;
    }

    public String getFxmlText() {
        String result;
        if (this.fxomRoot == null) {
            assert (this.glue.getRootElement() == null);
            assert (this.sceneGraphRoot == null);
            result = "";
        } else {
            assert (this.glue.getRootElement() != null);
            this.glue.updateIndent();
            FXOMSaver saver = new FXOMSaver();
            result = saver.save(this);
        }
        return result;
    }

    public FXOMObject searchWithSceneGraphObject(Object sceneGraphObject) {
        FXOMObject result = this.fxomRoot == null ? null : this.fxomRoot.searchWithSceneGraphObject(sceneGraphObject);
        return result;
    }

    public FXOMObject searchWithFxId(String fxId) {
        FXOMObject result = this.fxomRoot == null ? null : this.fxomRoot.searchWithFxId(fxId);
        return result;
    }

    public Map<String, FXOMObject> collectFxIds() {
        Map<String, FXOMObject> result = this.fxomRoot == null ? Collections.emptyMap() : this.fxomRoot.collectFxIds();
        return result;
    }

    public void beginUpdate() {
        ++this.updateDepth;
    }

    public void endUpdate() {
        assert (this.updateDepth >= 1);
        --this.updateDepth;
        if (this.updateDepth == 0) {
            this.refreshSceneGraph();
        }
    }

    public boolean isUpdateOnGoing() {
        return this.updateDepth >= 1;
    }

    public void refreshSceneGraph() {
        if (this.sceneGraphHolder != null) {
            this.sceneGraphHolder.fxomDocumentWillRefreshSceneGraph(this);
        }
        FXOMRefresher fxomRefresher = new FXOMRefresher();
        fxomRefresher.refresh(this);
        if (this.sampleDataGenerator != null && this.fxomRoot != null) {
            this.sampleDataGenerator.assignSampleData(this.fxomRoot);
        }
        if (this.sceneGraphHolder != null) {
            this.sceneGraphHolder.fxomDocumentDidRefreshSceneGraph(this);
        }
        this.sceneGraphRevision.set(this.sceneGraphRevision.get() + 1);
    }

    public ReadOnlyIntegerProperty sceneGraphRevisionProperty() {
        return this.sceneGraphRevision;
    }

    public void reapplyCSS(Path stylesheetPath) {
        Node rootNode;
        if (this.sceneGraphRoot instanceof Node && (rootNode = (Node)this.sceneGraphRoot).getScene() != null) {
            Deprecation.reapplyCSS(rootNode.getScene());
            this.cssRevision.set(this.cssRevision.get() + 1);
        }
    }

    public ReadOnlyIntegerProperty cssRevisionProperty() {
        return this.cssRevision;
    }

    public static String readContentFromURL(URL url) throws IOException {
        StringBuilder result = new StringBuilder();
        try (InputStream is = url.openConnection().getInputStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));){
            char[] buffer = new char[1024];
            int readLength = r.read(buffer, 0, buffer.length);
            while (readLength != -1) {
                result.append(buffer, 0, readLength);
                readLength = r.read(buffer, 0, buffer.length);
            }
        }
        return result.toString();
    }

    public void beginHoldingSceneGraph(SceneGraphHolder holder) {
        assert (holder != null);
        assert (this.sceneGraphHolder == null);
        this.sceneGraphHolder = holder;
    }

    public void endHoldingSceneGraph() {
        assert (this.sceneGraphHolder != null);
        this.sceneGraphHolder = null;
    }

    public SceneGraphHolder getSceneGraphHolder() {
        return this.sceneGraphHolder;
    }

    public static interface SceneGraphHolder {
        public void fxomDocumentWillRefreshSceneGraph(FXOMDocument var1);

        public void fxomDocumentDidRefreshSceneGraph(FXOMDocument var1);
    }
}

