/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMBuilderFactory;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.GlueCursor;
import com.oracle.javafx.scenebuilder.kit.fxom.ResourceKeyCollector;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientClassLoader;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientNode;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientObject;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientProperty;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.sun.javafx.fxml.LoadListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.util.BuilderFactory;

class FXOMLoader
implements LoadListener {
    private final FXOMDocument document;
    private TransientNode currentTransientNode;
    private GlueCursor glueCursor;

    public FXOMLoader(FXOMDocument document) {
        assert (document != null);
        assert (document.getGlue().getRootElement() != null);
        this.document = document;
    }

    public void load(String fxmlText) throws IOException {
        assert (fxmlText != null);
        ClassLoader classLoader = this.document.getClassLoader() != null ? this.document.getClassLoader() : FXMLLoader.getDefaultClassLoader();
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(this.document.getLocation());
        fxmlLoader.setResources((ResourceBundle)new ResourceKeyCollector(this.document.getResources()));
        fxmlLoader.setClassLoader((ClassLoader)new TransientClassLoader(classLoader));
        fxmlLoader.setBuilderFactory((BuilderFactory)new FXOMBuilderFactory(classLoader));
        Deprecation.setStaticLoad(fxmlLoader, true);
        Deprecation.setLoadListener(fxmlLoader, this);
        Charset utf8 = Charset.forName("UTF-8");
        try (ByteArrayInputStream is = new ByteArrayInputStream(fxmlText.getBytes(utf8));){
            this.glueCursor = new GlueCursor(this.document.getGlue());
            this.currentTransientNode = null;
            assert (((InputStream)is).markSupported());
            ((InputStream)is).reset();
            this.document.setSceneGraphRoot(fxmlLoader.load((InputStream)is));
        }
        catch (IOException | RuntimeException x) {
            throw new IOException(x);
        }
    }

    public FXOMDocument getDocument() {
        return this.document;
    }

    public void readImportProcessingInstruction(String data) {
    }

    public void readLanguageProcessingInstruction(String data) {
    }

    public void readComment(String string) {
    }

    public void beginInstanceDeclarationElement(Class<?> declaredClass) {
        assert (declaredClass != null);
        assert (this.glueCursor.getCurrentElement().getTagName().equals(PropertyName.makeClassFullName(declaredClass)) || this.glueCursor.getCurrentElement().getTagName().equals(declaredClass.getCanonicalName()));
        TransientObject transientInstance = new TransientObject(this.currentTransientNode, declaredClass, this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientInstance;
        this.glueCursor.moveToNextElement();
    }

    public void beginUnknownTypeElement(String unknownClassName) {
        assert (unknownClassName != null);
        assert (this.glueCursor.getCurrentElement().getTagName().equals(unknownClassName));
        TransientObject transientInstance = new TransientObject(this.currentTransientNode, unknownClassName, this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientInstance;
        this.glueCursor.moveToNextElement();
    }

    public void beginIncludeElement() {
        assert (this.glueCursor.getCurrentElement().getTagName().equals("fx:include"));
        TransientIntrinsic transientIntrinsic = new TransientIntrinsic(this.currentTransientNode, FXOMIntrinsic.Type.FX_INCLUDE, this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientIntrinsic;
        this.glueCursor.moveToNextElement();
    }

    public void beginReferenceElement() {
        assert (this.glueCursor.getCurrentElement().getTagName().equals("fx:reference"));
        TransientIntrinsic transientIntrinsic = new TransientIntrinsic(this.currentTransientNode, FXOMIntrinsic.Type.FX_REFERENCE, this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientIntrinsic;
        this.glueCursor.moveToNextElement();
    }

    public void beginCopyElement() {
        assert (this.glueCursor.getCurrentElement().getTagName().equals("fx:copy"));
        TransientIntrinsic transientIntrinsic = new TransientIntrinsic(this.currentTransientNode, FXOMIntrinsic.Type.FX_COPY, this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientIntrinsic;
        this.glueCursor.moveToNextElement();
    }

    public void beginRootElement() {
        assert (this.glueCursor.getCurrentElement().getTagName().equals("fx:root"));
        TransientObject transientInstance = new TransientObject(this.currentTransientNode, this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientInstance;
        this.glueCursor.moveToNextElement();
    }

    public void beginPropertyElement(String name, Class<?> staticClass) {
        assert (name != null);
        TransientProperty transientProperty = new TransientProperty(this.currentTransientNode, new PropertyName(name, staticClass), this.glueCursor.getCurrentElement());
        this.currentTransientNode = transientProperty;
        this.glueCursor.moveToNextElement();
    }

    public void beginUnknownStaticPropertyElement(String string) {
    }

    public void beginScriptElement() {
    }

    public void beginDefineElement() {
    }

    public void readInternalAttribute(String attrName, String attrValue) {
        assert (this.currentTransientNode instanceof TransientObject || this.currentTransientNode instanceof TransientIntrinsic);
        if (attrName.equals("type")) {
            assert (this.currentTransientNode instanceof TransientObject);
            TransientObject transientObject = (TransientObject)this.currentTransientNode;
            transientObject.setFxRootType(attrValue);
        }
    }

    public void readPropertyAttribute(String name, Class<?> staticClass, String fxmlValue) {
        assert (this.currentTransientNode instanceof TransientObject || this.currentTransientNode instanceof TransientIntrinsic || this.currentTransientNode instanceof TransientProperty);
        assert (name != null);
        PropertyName pname = new PropertyName(name, staticClass);
        FXOMPropertyT fxomProperty = new FXOMPropertyT(this.document, pname, null, null, fxmlValue);
        if (this.currentTransientNode instanceof TransientObject) {
            TransientObject transientInstance = (TransientObject)this.currentTransientNode;
            transientInstance.getProperties().add(fxomProperty);
        } else if (this.currentTransientNode instanceof TransientProperty) {
            TransientProperty transientProperty = (TransientProperty)this.currentTransientNode;
            transientProperty.getCollectedProperties().add(fxomProperty);
        }
    }

    public void readUnknownStaticPropertyAttribute(String string, String string1) {
    }

    public void readEventHandlerAttribute(String name, String hashStatement) {
        this.readPropertyAttribute(name, null, hashStatement);
    }

    public void endElement(Object sceneGraphObject) {
        this.currentTransientNode.setSceneGraphObject(sceneGraphObject);
        if (this.currentTransientNode instanceof TransientObject) {
            TransientObject currentInstance = (TransientObject)this.currentTransientNode;
            FXOMObject currentFxomObject = currentInstance.makeFxomObject(this.document);
            TransientNode currentParent = currentInstance.getParentNode();
            if (currentParent instanceof TransientProperty) {
                TransientProperty parentProperty = (TransientProperty)currentParent;
                parentProperty.getValues().add(currentFxomObject);
            } else if (currentParent instanceof TransientObject) {
                TransientObject parentInstance = (TransientObject)currentParent;
                parentInstance.getCollectedItems().add(currentFxomObject);
            } else {
                assert (currentParent == null);
                this.document.updateRoots(currentFxomObject, currentFxomObject.getSceneGraphObject());
            }
        } else if (this.currentTransientNode instanceof TransientIntrinsic) {
            TransientIntrinsic currentIntrinsic = (TransientIntrinsic)this.currentTransientNode;
            FXOMIntrinsic currentFxomIntrinsic = currentIntrinsic.makeFxomIntrinsic(this.document);
            TransientNode currentParent = currentIntrinsic.getParentNode();
            if (currentParent instanceof TransientProperty) {
                TransientProperty parentProperty = (TransientProperty)currentParent;
                parentProperty.getValues().add(currentFxomIntrinsic);
            } else if (currentParent instanceof TransientObject) {
                TransientObject parentInstance = (TransientObject)currentParent;
                parentInstance.getCollectedItems().add(currentFxomIntrinsic);
            } else {
                assert (currentParent == null);
                this.document.updateRoots(currentFxomIntrinsic, currentFxomIntrinsic.getSceneGraphObject());
            }
        } else if (this.currentTransientNode instanceof TransientProperty) {
            TransientProperty currentProperty = (TransientProperty)this.currentTransientNode;
            TransientNode currentParent = currentProperty.getParentNode();
            FXOMProperty currentFxomProperty = currentProperty.makeFxomProperty(this.document);
            assert (currentParent instanceof TransientObject);
            TransientObject parentObject = (TransientObject)currentParent;
            parentObject.getProperties().add(currentFxomProperty);
        }
        this.currentTransientNode = this.currentTransientNode.getParentNode();
    }
}

