/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.StringListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FXOMPropertyT
extends FXOMProperty {
    private String value;
    private final GlueElement propertyElement;
    private final GlueElement valueElement;

    public FXOMPropertyT(FXOMDocument document, PropertyName name, GlueElement propertyElement, GlueElement valueElement, String value) {
        super(document, name);
        this.propertyElement = propertyElement;
        this.valueElement = valueElement;
        this.value = value;
    }

    public FXOMPropertyT(FXOMDocument document, PropertyName name, String value) {
        super(document, name);
        assert (value != null);
        this.propertyElement = null;
        this.valueElement = null;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        assert (newValue != null);
        if (this.propertyElement != null) {
            if (this.valueElement != null) {
                Map<String, String> attributes = this.valueElement.getAttributes();
                assert (attributes.get("fx:value") != null);
                assert (attributes.get("fx:value").equals(this.value));
                attributes.put("fx:value", newValue);
            } else {
                assert (this.propertyElement.getContentText() != null);
                assert (this.propertyElement.getContentText().equals(this.value));
                this.propertyElement.setContentText(newValue);
            }
        } else {
            FXOMInstance parentInstance = this.getParentInstance();
            if (parentInstance != null) {
                GlueElement parentElement = parentInstance.getGlueElement();
                Map<String, String> parentAttributes = parentElement.getAttributes();
                assert (parentAttributes.get(this.getName().toString()).equals(this.value));
                parentAttributes.put(this.getName().toString(), newValue);
            }
        }
        this.value = newValue;
    }

    public GlueElement getPropertyElement() {
        return this.propertyElement;
    }

    public GlueElement getValueElement() {
        return this.valueElement;
    }

    public static FXOMPropertyT newInstance(FXOMPropertyT source, FXOMDocument targetDocument) {
        assert (source != null);
        assert (targetDocument != null);
        assert (source.getFxomDocument() != targetDocument);
        FXOMPropertyT result = new FXOMPropertyT(targetDocument, source.getName(), source.getValue());
        return result;
    }

    @Override
    public void addToParentInstance(int index, FXOMInstance newParentInstance) {
        assert (newParentInstance != null);
        if (this.getParentInstance() != null) {
            this.removeFromParentInstance();
        }
        this.setParentInstance(newParentInstance);
        newParentInstance.addProperty(this);
        GlueElement newParentElement = newParentInstance.getGlueElement();
        if (this.propertyElement == null) {
            Map<String, String> attributes = newParentElement.getAttributes();
            assert (attributes.get(this.getName().toString()) == null);
            attributes.put(this.getName().toString(), this.value);
        } else {
            assert (-1 <= index);
            assert (index <= newParentElement.getChildren().size());
            this.propertyElement.addToParent(index, newParentElement);
        }
    }

    @Override
    public void removeFromParentInstance() {
        assert (this.getParentInstance() != null);
        FXOMInstance currentParentInstance = this.getParentInstance();
        GlueElement currentParentElement = currentParentInstance.getGlueElement();
        if (this.propertyElement == null) {
            Map<String, String> attributes = currentParentElement.getAttributes();
            assert (attributes.get(this.getName().toString()) != null);
            attributes.remove(this.getName().toString());
        } else {
            this.propertyElement.removeFromParent();
        }
        this.setParentInstance(null);
        currentParentInstance.removeProperty(this);
    }

    @Override
    public int getIndexInParentInstance() {
        int result;
        if (this.getParentInstance() == null) {
            result = -1;
        } else if (this.propertyElement == null) {
            result = -1;
        } else {
            GlueElement parentElement = this.getParentInstance().getGlueElement();
            result = parentElement.getChildren().indexOf(this.propertyElement);
            assert (result != -1);
        }
        return result;
    }

    @Override
    public void moveToFxomDocument(FXOMDocument destination) {
        assert (destination != null);
        assert (destination != this.getFxomDocument());
        this.documentLocationWillChange(destination.getLocation());
        if (this.getParentInstance() != null) {
            assert (this.getParentInstance().getFxomDocument() == this.getFxomDocument());
            this.removeFromParentInstance();
        }
        assert (this.getParentInstance() == null);
        assert (this.propertyElement == null || this.propertyElement.getParent() == null);
        if (this.propertyElement != null) {
            this.propertyElement.moveToDocument(destination.getGlue());
            assert (this.valueElement == null || this.valueElement.getDocument() == destination.getGlue());
        }
        this.changeFxomDocument(destination);
    }

    @Override
    protected void changeFxomDocument(FXOMDocument destination) {
        assert (destination != null);
        assert (destination != this.getFxomDocument());
        assert (this.propertyElement == null || destination.getGlue() == this.propertyElement.getDocument());
        super.changeFxomDocument(destination);
    }

    @Override
    public void documentLocationWillChange(URL newLocation) {
        URL currentLocation = this.getFxomDocument().getLocation();
        List<String> currentItems = StringListPropertyMetadata.splitValue(this.getValue());
        ArrayList<String> newItems = new ArrayList<String>();
        int changeCount = 0;
        for (String currentItem : currentItems) {
            URL assetURL;
            PrefixedValue pv = new PrefixedValue(currentItem);
            if (pv.isDocumentRelativePath()) {
                String newValue;
                assert (currentLocation != null);
                assetURL = pv.resolveDocumentRelativePath(currentLocation);
                if (newLocation == null) {
                    newValue = assetURL.toString();
                } else {
                    PrefixedValue pv2 = PrefixedValue.makePrefixedValue(assetURL, newLocation);
                    newValue = pv2.toString();
                }
                newItems.add(newValue);
                ++changeCount;
                continue;
            }
            if (pv.isPlainString() && currentLocation == null) {
                assert (newLocation != null);
                try {
                    assetURL = new URL(pv.getSuffix());
                    PrefixedValue pv2 = PrefixedValue.makePrefixedValue(assetURL, newLocation);
                    newItems.add(pv2.toString());
                    ++changeCount;
                }
                catch (MalformedURLException x) {
                    newItems.add(currentItem);
                }
                continue;
            }
            newItems.add(currentItem);
        }
        assert (currentItems.size() == newItems.size());
        if (changeCount >= 1) {
            this.setValue(StringListPropertyMetadata.assembleValue(newItems));
        }
    }
}

