/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

class FXOMSaver {
    private static final String NAME_SPACE_FX = "http://javafx.com/javafx/8";
    private static final String NAME_SPACE_FXML = "http://javafx.com/fxml/1";

    FXOMSaver() {
    }

    public String save(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        assert (fxomDocument.getGlue() != null);
        if (fxomDocument.getFxomRoot() != null) {
            this.updateNameSpace(fxomDocument);
            this.updateImportInstructions(fxomDocument);
        }
        return fxomDocument.getGlue().toString();
    }

    private void updateNameSpace(FXOMDocument fxomDocument) {
        assert (fxomDocument.getFxomRoot() != null);
        FXOMObject fxomRoot = fxomDocument.getFxomRoot();
        String currentNameSpaceFX = fxomRoot.getNameSpaceFX();
        String currentNameSpaceFXML = fxomRoot.getNameSpaceFXML();
        if (currentNameSpaceFX == null || !currentNameSpaceFX.equals(NAME_SPACE_FX)) {
            fxomRoot.setNameSpaceFX(NAME_SPACE_FX);
        }
        if (currentNameSpaceFXML == null || !currentNameSpaceFXML.equals(NAME_SPACE_FXML)) {
            fxomRoot.setNameSpaceFXML(NAME_SPACE_FXML);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateImportInstructions(FXOMDocument fxomDocument) {
        void var6_10;
        assert (fxomDocument.getFxomRoot() != null);
        GlueDocument glue = fxomDocument.getGlue();
        List<GlueInstruction> imports = glue.collectInstructions("import");
        HashSet<String> existingPackageNames = new HashSet<String>();
        for (GlueInstruction glueInstruction : imports) {
            String string = glueInstruction.getData();
            if (!string.endsWith(".*")) continue;
            String packageName = string.substring(0, string.length() - 2);
            existingPackageNames.add(packageName);
        }
        TreeSet<String> newPackageNames = new TreeSet<String>();
        for (Class<?> clazz : fxomDocument.getFxomRoot().collectDeclaredClasses()) {
            newPackageNames.add(clazz.getPackage().getName());
        }
        newPackageNames.add("java.lang");
        newPackageNames.removeAll(existingPackageNames);
        if (imports.isEmpty()) {
            boolean bl = false;
        } else {
            GlueInstruction glueInstruction = imports.get(0);
            int n = glue.getHeader().indexOf(glueInstruction);
        }
        void var7_16 = var6_10;
        for (String packageName : newPackageNames) {
            void var7_17;
            GlueInstruction instruction = new GlueInstruction(glue, "import", packageName + ".*");
            glue.getHeader().add((int)var7_17, instruction);
            ++var7_17;
        }
    }
}

