/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueAuxiliary;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueCharacters;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GlueElement
extends GlueNode {
    private static final int INDENT_STEP = 3;
    private GlueDocument document;
    private String tagName;
    private final List<GlueElement> children = new ArrayList<GlueElement>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<GlueAuxiliary> front = new ArrayList<GlueAuxiliary>();
    private final List<GlueAuxiliary> tail = new ArrayList<GlueAuxiliary>();
    private final List<GlueAuxiliary> content = new ArrayList<GlueAuxiliary>();
    private int indentDepth;
    private GlueElement parent;

    public GlueElement(GlueDocument document, String tagName) {
        this(document, tagName, 0, true);
    }

    public GlueElement(GlueDocument document, String tagName, int indentDepth, boolean preset) {
        assert (document != null);
        assert (tagName != null);
        this.document = document;
        this.tagName = tagName;
        this.indentDepth = indentDepth;
        if (preset) {
            this.front.add(new GlueCharacters(document, GlueCharacters.Type.TEXT, "\n"));
            this.tail.add(new GlueCharacters(document, GlueCharacters.Type.TEXT, "\n"));
        }
    }

    public GlueElement(GlueDocument document, String tagName, GlueElement template) {
        this(document, tagName, template.indentDepth, false);
        int templateIndent = template.guessIndent();
        if (templateIndent != -1) {
            this.front.add(this.makeIndentCharacters(templateIndent));
            this.tail.add(this.makeIndentCharacters(templateIndent));
        }
    }

    public GlueElement getParent() {
        return this.parent;
    }

    public GlueDocument getDocument() {
        return this.document;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        assert (tagName != null);
        assert (!tagName.isEmpty());
        this.tagName = tagName;
    }

    public List<GlueElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addToParent(GlueElement newParent) {
        this.addToParent(-1, newParent);
    }

    public void addToParent(int index, GlueElement newParent) {
        assert (newParent != null);
        assert (newParent != this.parent);
        assert (newParent.getDocument() == this.document);
        assert (-1 <= index);
        assert (index <= newParent.children.size());
        if (this.parent != null) {
            this.removeFromParent();
        } else if (this == this.document.getRootElement()) {
            this.document.setRootElement(null);
        }
        if (index == -1) {
            index = newParent.children.size();
        }
        newParent.children.add(index, this);
        this.parent = newParent;
    }

    public void addBefore(GlueElement nextSibling) {
        assert (nextSibling != null);
        assert (nextSibling.getDocument() == this.document);
        assert (nextSibling.getParent() != null);
        GlueElement siblingParent = nextSibling.getParent();
        int nextSiblingIndex = siblingParent.getChildren().indexOf(nextSibling);
        assert (nextSiblingIndex != -1);
        this.addToParent(nextSiblingIndex, siblingParent);
    }

    public void removeFromParent() {
        assert (this.parent != null);
        assert (this.parent.children.contains(this));
        this.parent.children.remove(this);
        this.parent = null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<GlueAuxiliary> getFront() {
        return this.front;
    }

    public List<GlueAuxiliary> getTail() {
        return this.tail;
    }

    public List<GlueAuxiliary> getContent() {
        return this.content;
    }

    public int getDepth() {
        int result = 0;
        for (GlueElement ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            ++result;
        }
        return result;
    }

    public void updateIndent(int depth) {
        if (this.indentDepth != depth) {
            GlueCharacters characters;
            int indentDelta = (depth - this.indentDepth) * 3;
            if (this.front.isEmpty()) {
                this.front.add(this.makeIndentCharacters(depth * 3));
            } else {
                for (GlueAuxiliary auxiliary : this.front) {
                    if (!(auxiliary instanceof GlueCharacters)) continue;
                    characters = (GlueCharacters)auxiliary;
                    characters.adjustIndentBy(indentDelta);
                }
            }
            if (this.tail.isEmpty()) {
                this.tail.add(this.makeIndentCharacters(depth * 3));
            } else {
                for (GlueAuxiliary auxiliary : this.tail) {
                    if (!(auxiliary instanceof GlueCharacters)) continue;
                    characters = (GlueCharacters)auxiliary;
                    characters.adjustIndentBy(indentDelta);
                }
            }
            this.indentDepth = depth;
        }
        for (GlueElement child : this.children) {
            child.updateIndent(depth + 1);
        }
    }

    public String getContentText() {
        GlueCharacters contentHolder = this.getContentHolder();
        String result = contentHolder == null ? null : contentHolder.getData();
        return result;
    }

    public void setContentText(String text) {
        String currentText = this.getContentText();
        if (!Objects.equals(currentText, text)) {
            GlueCharacters contentHolder = this.getContentHolder();
            if (text == null) {
                assert (currentText != null);
                assert (contentHolder != null);
                this.content.remove(contentHolder);
            } else if (contentHolder == null) {
                contentHolder = new GlueCharacters(this.document, GlueCharacters.Type.TEXT, text);
                this.content.add(contentHolder);
            } else {
                contentHolder.setData(text);
            }
        }
        assert (Objects.equals(this.getContentText(), text));
    }

    public void moveToDocument(GlueDocument targetDocument) {
        assert (targetDocument != null);
        assert (targetDocument != this.document);
        if (this == this.document.getRootElement()) {
            assert (this.parent == null);
            this.document.setRootElement(null);
        }
        if (this.parent != null && this.parent.getDocument() != targetDocument) {
            this.removeFromParent();
        }
        this.document = targetDocument;
        for (GlueElement child : this.children) {
            child.moveToDocument(targetDocument);
        }
        assert (this.document == targetDocument);
        assert (this != targetDocument.getRootElement());
    }

    public GlueElement getNextSibling() {
        GlueElement result;
        if (this.parent == null) {
            result = null;
        } else {
            int index = this.parent.children.indexOf(this);
            assert (index != -1);
            result = index + 1 < this.parent.children.size() ? this.parent.children.get(index + 1) : null;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" - ");
        result.append(this.tagName);
        return result.toString();
    }

    private GlueCharacters getContentHolder() {
        GlueCharacters result = null;
        for (int i = this.content.size() - 1; i >= 0 && result == null; --i) {
            GlueCharacters c;
            GlueAuxiliary auxiliary = this.content.get(i);
            if (!(auxiliary instanceof GlueCharacters) || (c = (GlueCharacters)auxiliary).getType() != GlueCharacters.Type.TEXT) continue;
            result = c;
        }
        return result;
    }

    private int guessIndent() {
        int result;
        if (this.front.isEmpty()) {
            result = -1;
        } else if (this.front.get(0) instanceof GlueCharacters) {
            GlueCharacters characters = (GlueCharacters)this.front.get(0);
            result = characters.guessIndent();
        } else {
            result = -1;
        }
        return result;
    }

    private GlueCharacters makeIndentCharacters(int indentSize) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < indentSize; ++i) {
            sb.append(' ');
        }
        return new GlueCharacters(this.getDocument(), GlueCharacters.Type.TEXT, sb.toString());
    }
}

